/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.event.BcEvent;
import ext.base.event.BcEventManager;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcWords;
import ext.lib.fx.tree.FxTreeCell;
import ext.lib.fx.tree.FxTreeFolder;
import ext.lib.fx.tree.FxTreeItem;
import ext.lib.fx.tree.FxTreeUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.InnerComparator1;
import ext.module.xdts.fx.XdtsCustomSqlPane;
import ext.module.xdts.fx.XdtsProfileTreeItemHelper;
import ext.module.xdts.fx.XdtsProfileTreePane;
import ext.module.xdts.model.XdtsCustomSql;
import ext.module.xdts.stub.XdtsCustomSqlStub;
import ext.module.xdts.swg.XdtsDataViewPanel_Sql;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.MouseEvent;

class XdtsSqlTreeItemHelper
extends XdtsProfileTreeItemHelper {
    ComparatorForId comparatorForId = new ComparatorForId();
    ComparatorForSort comparatorForSort = new ComparatorForSort();
    ContextMenu contextMenu1;
    ContextMenu contextMenu2;
    MenuItem addMenuItem;
    MenuItem editMenuItem;
    MenuItem deleteMenuItem;
    MenuItem copyMenuItem;
    MenuItem pastMenuItem;
    MenuItem refreshMenuItem;
    MenuItem dataViewMenuItem;

    public XdtsSqlTreeItemHelper() throws Exception {
        BcEventManager.getInstance().getEventHandlerList(XdtsCustomSql.class).addEventHandler(this);
    }

    @Override
    public FxTreeItem creaeSubTreeItem() throws Exception {
        FxTreeItem treeItem = this.creaeTreeItem();
        treeItem.setValue(new FxTreeFolder(SqlWords.getInstance().sql));
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
        return treeItem;
    }

    @Override
    public String getItemText(FxTreeItem treeItem) throws Exception {
        String str = null;
        if (XdtsCustomSql.class.isInstance(treeItem.getValue())) {
            XdtsCustomSql customSql = (XdtsCustomSql)treeItem.getValue();
            str = customSql.name;
        } else {
            str = super.getItemText(treeItem);
        }
        return str;
    }

    @Override
    public void refresh() throws Exception {
        super.refresh();
        List<Object> valueList = FxTreeUtil.getValueList(this.getTreeView().getSelectionModel().getSelectedItems());
        this.refresh_L2();
        ObservableList treeItemList = this.getSubTreeItem().getChildren();
        this.getTreeView().getSelectionModel().clearSelection();
        FxTreeUtil.selectTreeItems((List<? extends TreeItem>)treeItemList, valueList, this.comparatorForId, this.getTreeView().getSelectionModel());
    }

    protected void refresh_L2() throws Exception {
        List<XdtsCustomSql> customSqlList = XdtsCustomSqlStub.getInstance().getCustomSqlList(this.profile.getDataId());
        this.getSubTreeItem().getChildren().clear();
        int i = 0;
        while (i < customSqlList.size()) {
            XdtsCustomSql customSql = customSqlList.get(i);
            FxTreeItem treeItem = this.creaeTreeItem();
            treeItem.setValue(customSql);
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
            StringBuilder sb = new StringBuilder();
            if (!BcStringUtil.isEmpty(customSql.note)) {
                sb.append(customSql.note);
                sb.append("\n");
            }
            sb.append("\u767b\u9332\u65e5\u6642:");
            sb.append(BcTimeUtil.toString(customSql.getAddTimestamp(), "yyyy/MM/dd HH:mm"));
            sb.append("\n");
            if (!BcStringUtil.isEmpty(customSql.sql)) {
                sb.append("\n");
                sb.append(customSql.sql);
            }
            BcStringUtil.appendCaseOfNotEmpty(sb, customSql.note);
            treeItem.tooltip = new Tooltip();
            treeItem.tooltip.setText(sb.toString());
            XdtsProfileTreePane.setPath1(treeItem, this.getSubTreeItem(), customSql.group, this, this.comparatorForSort);
            ++i;
        }
        String str = String.format(String.valueOf(SqlWords.getInstance().sql) + "(%d)", customSqlList.size());
        this.getSubTreeItem().setValue(new FxTreeFolder(str));
    }

    @Override
    public void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        super.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        if (FxTreeUtil.isAncestor(this.getSubTreeItem(), treeItem) && doubleClicked && treeItem.getValue() instanceof XdtsCustomSql) {
            XdtsCustomSql customSql = (XdtsCustomSql)treeItem.getValue();
            this.dataView(customSql);
        }
    }

    @Override
    public void treeItemExpanded(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemExpanded(ev);
        TreeItem treeItem = ev.getTreeItem();
        if (FxTreeUtil.isAncestor(this.getSubTreeItem(), treeItem) && treeItem.getValue() instanceof FxTreeFolder) {
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("folder_opened_64x64.png"));
        }
    }

    @Override
    public void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemCollapsed(ev);
        TreeItem treeItem = ev.getTreeItem();
        if (FxTreeUtil.isAncestor(this.getSubTreeItem(), treeItem) && treeItem.getValue() instanceof FxTreeFolder) {
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("folder_closed_64x64.png"));
        }
    }

    @Override
    public void setContextMenu(FxTreeItem treeItem, FxTreeCell treeCell, EventHandler contextMeneEventHandler) throws Exception {
        if (this.contextMenu1 == null) {
            this.contextMenu1 = new ContextMenu();
            this.contextMenu2 = new ContextMenu();
            this.addMenuItem = new MenuItem(BcWords.getInstance().add, (Node)FxImageHelper.createImageView_icon("document_add_64x64.png"));
            this.addMenuItem.setOnAction(contextMeneEventHandler);
            this.editMenuItem = new MenuItem(BcWords.getInstance().edit, (Node)FxImageHelper.createImageView_icon("document_edit_64x64.png"));
            this.editMenuItem.setOnAction(contextMeneEventHandler);
            this.deleteMenuItem = new MenuItem(BcWords.getInstance().delete, (Node)FxImageHelper.createImageView_icon("document_delete_64x64.png"));
            this.deleteMenuItem.setOnAction(contextMeneEventHandler);
            this.copyMenuItem = new MenuItem(BcWords.getInstance().copy, (Node)FxImageHelper.createImageView_icon("copy_64x64.png"));
            this.copyMenuItem.setOnAction(contextMeneEventHandler);
            this.pastMenuItem = new MenuItem(BcWords.getInstance().past, (Node)FxImageHelper.createImageView_icon("paste_64x64.png"));
            this.pastMenuItem.setOnAction(contextMeneEventHandler);
            this.refreshMenuItem = new MenuItem(BcWords.getInstance().refresh, (Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
            this.refreshMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewMenuItem = new MenuItem(XdtsWords.getInstance().dataView, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewMenuItem.setOnAction(contextMeneEventHandler);
        }
        this.addMenuItem.setUserData((Object)treeCell);
        this.editMenuItem.setUserData((Object)treeCell);
        this.deleteMenuItem.setUserData((Object)treeCell);
        this.copyMenuItem.setUserData((Object)treeCell);
        this.pastMenuItem.setUserData((Object)treeCell);
        this.refreshMenuItem.setUserData((Object)treeCell);
        this.dataViewMenuItem.setUserData((Object)treeCell);
        if (treeItem == this.getSubTreeItem()) {
            this.contextMenu1.getItems().clear();
            this.contextMenu1.getItems().add((Object)this.addMenuItem);
            this.contextMenu1.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu1.getItems().add((Object)this.copyMenuItem);
            this.contextMenu1.getItems().add((Object)this.pastMenuItem);
            this.contextMenu1.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu1.getItems().add((Object)this.refreshMenuItem);
            treeCell.setContextMenu(this.contextMenu1);
        } else {
            this.contextMenu2.getItems().clear();
            this.contextMenu2.getItems().add((Object)this.dataViewMenuItem);
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.editMenuItem);
            ObservableList treeItemList = this.getTreeView().getSelectionModel().getSelectedItems();
            this.editMenuItem.setDisable(treeItemList.size() > 1);
            this.contextMenu2.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu2.getItems().add((Object)this.copyMenuItem);
            this.contextMenu2.getItems().add((Object)this.pastMenuItem);
            treeCell.setContextMenu(this.contextMenu2);
        }
        this.pastMenuItem.setDisable(true);
        this.clipboardValueList = null;
        if (treeItem.getValue() instanceof FxTreeFolder) {
            try {
                String tmpStr = Clipboard.getSystemClipboard().getString();
                this.clipboardValueList = BcCsvUtil.parseCsvRow(tmpStr, true);
                String className = (String)BcCollectionUtil.getElement(this.clipboardValueList, 0);
                if (this.getClass().getName().equals(className)) {
                    this.pastMenuItem.setDisable(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void contextMenuHandle(Event ev, FxTreeItem treeItem) throws Exception {
        if (ev.getSource() == this.addMenuItem) {
            XdtsCustomSqlPane.show2(this.profile.getDataId(), -1);
        } else if (ev.getSource() == this.editMenuItem) {
            XdtsCustomSql customSql = (XdtsCustomSql)treeItem.getValue();
            XdtsCustomSqlPane.show2(-1, customSql.getDataId());
        } else if (ev.getSource() == this.deleteMenuItem) {
            this.delete(ev, treeItem);
        } else if (ev.getSource() == this.copyMenuItem) {
            this.copy(ev, treeItem);
        } else if (ev.getSource() == this.pastMenuItem) {
            if (this.past(ev, treeItem)) {
                BcEventManager.getInstance().getEventHandlerList(XdtsCustomSql.class).fireEvent(new BcEvent(new XdtsCustomSql()));
            }
        } else if (ev.getSource() == this.refreshMenuItem) {
            this.refresh();
        } else if (ev.getSource() == this.dataViewMenuItem) {
            XdtsCustomSql customSql = (XdtsCustomSql)treeItem.getValue();
            this.dataView(customSql);
        }
    }

    @Override
    protected void delete(List<FxTreeItem> descendantList) throws Exception {
        ArrayList<Integer> entityIdList = new ArrayList<Integer>();
        for (FxTreeItem treeItemWk2 : descendantList) {
            if (!(treeItemWk2.getValue() instanceof XdtsCustomSql)) continue;
            XdtsCustomSql customSql = (XdtsCustomSql)treeItemWk2.getValue();
            entityIdList.add(customSql.getDataId());
        }
        XdtsCustomSqlStub.getInstance().deleteEntity(entityIdList);
        BcEventManager.getInstance().getEventHandlerList(XdtsCustomSql.class).fireEvent(new BcEvent(new XdtsCustomSql()));
    }

    @Override
    protected void temp2(TreeItem fromTreeItem, TreeItem toItem, String group) throws Exception {
        if (fromTreeItem.getValue() instanceof XdtsCustomSql) {
            XdtsCustomSql customSql1 = (XdtsCustomSql)fromTreeItem.getValue();
            ArrayList<Integer> entityIdList = new ArrayList<Integer>();
            entityIdList.add(customSql1.getDataId());
            List<XdtsCustomSql> customSqlList = XdtsCustomSqlStub.getInstance().copyCustomSql(this.profile.getDataId(), entityIdList, group);
            int j = 0;
            while (j < customSqlList.size()) {
                XdtsCustomSql customSql2 = customSqlList.get(j);
                FxTreeItem newTreeItem = this.creaeTreeItem();
                newTreeItem.setValue(customSql2);
                newTreeItem.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
                toItem.getChildren().add((Object)newTreeItem);
                ++j;
            }
        }
    }

    @Override
    public void handle(BcEvent event) throws Exception {
        Object element;
        if (event.getSource() instanceof XdtsCustomSql) {
            this.refresh();
        } else if (event.getSource() instanceof List && (element = BcCollectionUtil.getFirst((List)event.getSource())) instanceof XdtsCustomSql) {
            this.refresh();
        }
    }

    @Override
    public void destruct() throws Exception {
        super.destruct();
        BcEventManager.getInstance().getEventHandlerList(XdtsCustomSql.class).removeEventHandler(this);
    }

    protected void dataView(XdtsCustomSql customSql) throws Exception {
        XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
        dataViewPanel.setProfile(this.profile);
        dataViewPanel.setCustomSql(customSql);
        dataViewPanel.init();
        dataViewPanel.showAsFrame();
    }

    protected class ComparatorForId
    extends InnerComparator1 {
        protected ComparatorForId() {
        }

        @Override
        public int compare2(Object obj1, Object obj2) {
            if (obj1 instanceof XdtsCustomSql && obj2 instanceof XdtsCustomSql) {
                XdtsCustomSql customSql1 = (XdtsCustomSql)obj1;
                XdtsCustomSql customSql2 = (XdtsCustomSql)obj2;
                return super.compare2(customSql1.getDataId(), customSql2.getDataId());
            }
            return super.compare2(obj1, obj2);
        }
    }

    protected class ComparatorForSort
    extends InnerComparator1 {
        protected ComparatorForSort() {
        }

        @Override
        public int compare2(Object obj1, Object obj2) {
            if (obj1 instanceof XdtsCustomSql && obj2 instanceof XdtsCustomSql) {
                XdtsCustomSql customSql1 = (XdtsCustomSql)obj1;
                XdtsCustomSql customSql2 = (XdtsCustomSql)obj2;
                return super.compare2(customSql1.name, customSql2.name);
            }
            return super.compare2(obj1, obj2);
        }
    }
}

