/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.fx.XdtsPersistence;
import ext.module.xdts.fx.XdtsUiEventHandler;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import javafx.event.ActionEvent;
import javafx.scene.Node;

public class XdtsSearchFunctionPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField nameField = new FxTextField();
    FxButton completionButton;
    FxButton cancelButton;
    public XdtsUiEventHandler uiEventHandler;
    public boolean isCompleted;
    long profileId;
    XdtsExtractionCondition extractionCondition;

    public XdtsSearchFunctionPane() throws Exception {
        this.completionButton = new FxButton(BcWords.getInstance().completion);
        this.cancelButton = new FxButton(BcWords.getInstance().cancel);
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
    }

    public void setData(long profileId, XdtsExtractionCondition extractionCondition) throws Exception {
        this.profileId = profileId;
        this.extractionCondition = extractionCondition;
        this.centerPane.removeAll();
        this.nameField.setPrefColumnCount(60);
        this.nameField.setText(extractionCondition.name);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel("\u30c6\u30fc\u30d6\u30eb\u540d.\u30ab\u30e9\u30e0\u540d"), new Node[]{this.nameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void storeData() throws Exception {
        this.extractionCondition.name = this.nameField.getText();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData();
            String fileName = XdtsPersistence.createFileName(this.profileId, XdtsConstants.Category.search, this.extractionCondition.name, XdtsConstants.FileType.def);
            XdtsPersistence.saveObject(fileName, this.extractionCondition);
            this.isCompleted = true;
            if (this.uiEventHandler != null) {
                this.uiEventHandler.closeWindow(ev);
            }
        } else if (ev.getSource() == this.cancelButton && this.uiEventHandler != null) {
            this.uiEventHandler.closeWindow(ev);
        }
    }
}

