/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContextFactory;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.fx.XdtsFxImageUtil;
import ext.module.xdts.fx.XdtsProfileWizard;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;

class XdtsProductChoicePane
extends FxDecoratePane {
    GridPane gridPane = new GridPane();
    List<SqlConstants.DatabaseProduct> productList;
    List<Button> productButtonList;
    Button cancelButton;
    XdtsProfileWizard wizard;

    public XdtsProductChoicePane(XdtsProfileWizard wizard) throws Exception {
        this.wizard = wizard;
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.cancelButton = this.createButton(BcWords.getInstance().cancel);
        this.gridPane.setAlignment(Pos.CENTER);
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(16.0);
        this.productList = new ArrayList<SqlConstants.DatabaseProduct>();
        int i = 0;
        while (i < XdtsConstants.databaseProducts.length) {
            SqlConstants.DatabaseProduct databaseProduct = XdtsConstants.databaseProducts[i];
            this.productList.add(databaseProduct);
            ++i;
        }
        this.productButtonList = new ArrayList<Button>();
        int rouwMax = 4;
        int i2 = 0;
        while (i2 < this.productList.size()) {
            ImageView imageView;
            SqlConstants.DatabaseProduct databaseProduct = this.productList.get(i2);
            SqlContext sqlContext = SqlContextFactory.getSqlContext(databaseProduct);
            int columnId = i2 / rouwMax;
            int rowId = i2 - rouwMax * columnId;
            String productName = null;
            Tooltip tooltip = null;
            if (sqlContext != null) {
                productName = "";
                tooltip = new Tooltip(databaseProduct.productName);
            } else {
                productName = BcWords.getInstance().others;
                tooltip = new Tooltip(productName);
            }
            Button button = new Button();
            button.setUserData((Object)databaseProduct);
            button.setText(productName);
            button.setTooltip(tooltip);
            this.productButtonList.add(button);
            button.setOnAction(this.actionEventHandler);
            if (sqlContext != null && (imageView = XdtsFxImageUtil.createProductImageView(databaseProduct)) != null) {
                button.setGraphic((Node)imageView);
            }
            FxUtil.setFixedSize((Region)button, 160.0, 52.0);
            this.gridPane.add((Node)button, columnId, rowId);
            ++i2;
        }
        this.setCenter((Node)this.gridPane);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.cancelButton) {
            this.wizard.closeConfirm();
        } else {
            int i = 0;
            while (i < this.productButtonList.size()) {
                Button button = this.productButtonList.get(i);
                if (ev.getSource() == button) {
                    SqlConstants.DatabaseProduct databaseProduct = (SqlConstants.DatabaseProduct)((Object)button.getUserData());
                    this.wizard.profile1.productId = databaseProduct.id;
                    this.wizard.step1();
                }
                ++i;
            }
        }
    }
}

