/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Recruitment;
import ext.module.wbs1.model.WbsRecruitmentCondition;
import ext.module.wbs1.model.WbsShopCondition;
import java.util.List;

public class Wbs1RecruitmentDAO
extends OrmAbstractDAO<Wbs1Recruitment> {
    public static final int MODE_default = 1;
    public static final int MODE_personId = 2;

    private Wbs1RecruitmentDAO() {
        super(new Wbs1Recruitment[0]);
        this.setTableName("wbs1_recruitment");
    }

    public static Wbs1RecruitmentDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, long dataId, long personId) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (dataId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + dataId);
            selectSql.addWhereElement(whereElement);
        }
        if (personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + personId);
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "person_id");
        }
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectSql;
    }

    public <T> List<T> getList(DtsSession dtsSession, int mode, long dataId, long personId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, dataId, personId);
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long dataId) throws Exception {
        if (dataId <= 0L) {
            return null;
        }
        int personId = -1;
        List<T> entityList = this.getList(dtsSession, 1, dataId, personId);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getList(DtsSession dtsSession, WbsShopCondition shopCondition, WbsRecruitmentCondition recruitmentCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = new SqlSelectSql();
        SqlConditionParser.getInstance().parseCondition(selectSql, sqlContext, "shop.area", shopCondition.area, null);
        SqlConditionParser.getInstance().parseCondition(selectSql, sqlContext, "shop.business_type", shopCondition.businessType, null);
        SqlConditionParser.getInstance().parseCondition(selectSql, sqlContext, "rct.occupation", recruitmentCondition.occupation, null);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList("rct"));
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS rct" + " LEFT JOIN wbs1_shop AS shop ON shop.id = rct.shop_id");
        selectSql.getOrderByList().add("rct.id");
        String query = sqlContext.buildSelectSql(selectSql);
        BcLogUtil.debug("query=" + query);
        return this.getEntityList(dtsSession, query);
    }

    /* synthetic */ Wbs1RecruitmentDAO(Wbs1RecruitmentDAO wbs1RecruitmentDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1RecruitmentDAO instance = new Wbs1RecruitmentDAO(null);

        private SingletonHolder() {
        }
    }
}

