/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Customer;
import java.util.List;

public class Wbs1CustomerDAO
extends OrmAbstractDAO<Wbs1Customer> {
    public static final int MODE_ownerId = 1;

    private Wbs1CustomerDAO() {
        super(new Wbs1Customer[0]);
        this.setTableName("wbs1_customer");
    }

    public static Wbs1CustomerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, long ownerId, String emailAddress) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (ownerId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "owner_id =" + ownerId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(emailAddress)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "email_address" + sqlContext.toCondition_string("=", emailAddress));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "owner_id");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "email_address");
        }
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectSql;
    }

    public <T> List<T> getList(DtsSession dtsSession, int mode, long ownerId, String emailAddress) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, ownerId, emailAddress);
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByEmailAddress(DtsSession dtsSession, long ownerId, String emailAddress) throws Exception {
        if (BcStringUtil.isEmpty(emailAddress)) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, 1, ownerId, emailAddress);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1CustomerDAO(Wbs1CustomerDAO wbs1CustomerDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1CustomerDAO instance = new Wbs1CustomerDAO(null);

        private SingletonHolder() {
        }
    }
}

