/*
 * Decompiled with CFR 0.152.
 */
package ext.module.scrp.fx;

import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxUtil;
import ext.lib.script.SrpWords;
import ext.module.scrp.fx.ScrpScriptPane;
import ext.module.scrp.fx.ScrpScriptTableModel;
import ext.module.scrp.model.ScrpScript;
import ext.module.scrp.stub.ScrpScriptStub;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class ScrpScriptTablePane
extends FxDecoratePane {
    List<ScrpScript> scriptList;
    TabPane tabPane1 = new TabPane();
    protected Button addButton;
    protected Button editButton;
    protected Button deleteButton;
    protected Button closeButton;
    Number nextRowId;
    protected Stage stage;

    public ScrpScriptTablePane() throws Exception {
        this.addButton = this.createButton(BcWords.getInstance().add);
        this.editButton = this.createButton(BcWords.getInstance().edit);
        this.deleteButton = this.createButton(BcWords.getInstance().delete);
        this.closeButton = this.createButton(BcWords.getInstance().close);
        this.scriptList = ScrpScriptStub.getInstance().getScriptList();
        ScrpScriptTableModel scriptTableModel = new ScrpScriptTableModel(this.scriptList);
        FxTableRowList tableRowList = new FxTableRowList(scriptTableModel);
        InnerTableView tableView = new InnerTableView();
        BcTableColumnModel tableColumnModel = this.createTableColumnModel();
        FxTableUtil.createColumn(tableColumnModel, tableView, null);
        tableView.setItems(tableRowList);
        Tab scriptTab = new Tab();
        scriptTab.setText(SrpWords.getInstance().script);
        scriptTab.setContent((Node)tableView);
        scriptTab.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)scriptTab);
        this.tabPane1.setSide(Side.TOP);
        this.setCenter((Node)this.tabPane1);
        FxUtil.defaultInitialize((Node)this);
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = SrpWords.getInstance().scriptName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 20;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().note;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 80;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.addButton) {
            ScrpScriptPane scriptPane = new ScrpScriptPane();
            scriptPane.show(null);
        } else if (ev.getSource() == this.editButton) {
            ScrpScript script = this.scriptList.get(this.nextRowId.intValue());
            ScrpScriptPane scriptPane = new ScrpScriptPane();
            scriptPane.setData(script);
            scriptPane.show(null);
        } else if (ev.getSource() == this.deleteButton) {
            ScrpScript script = this.scriptList.get(this.nextRowId.intValue());
            ScrpScriptStub.getInstance().getScriptList();
            ScrpScriptPane scriptPane = new ScrpScriptPane();
            scriptPane.show((Window)this.stage);
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public void show() throws Exception {
        FxScene scene = new FxScene((Parent)this);
        this.stage = new FxStage();
        this.stage.setScene((Scene)scene);
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    ScrpScriptTablePane.this.close();
                }
                catch (Exception ex) {
                    ScrpScriptTablePane.this.handleException(ex);
                }
            }
        });
        this.stage.setResizable(true);
        FxUtil.setWindowSize((Window)this.stage, 600.0, 600.0, true);
        this.stage.setTitle(SrpWords.getInstance().script);
        this.stage.show();
    }

    class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            ScrpScriptTablePane.this.nextRowId = nextRowId;
        }
    }
}

