/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.etc.util;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.util.DtsWordManager;
import ext.libx.etc.model.EtcWord;
import ext.libx.etc.util.EtcEnumStrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EtcWordUtil {
    private EtcWordUtil() throws Exception {
    }

    public static List<String> createNewList(List<String> dataList) throws Exception {
        ArrayList<String> newList = new ArrayList<String>();
        int i = 0;
        while (i < dataList.size()) {
            String str = dataList.get(i);
            if (!BcStringUtil.isEmpty(str = BcStringUtil.trim(str))) {
                newList.add(str);
            }
            ++i;
        }
        return newList;
    }

    public static String getBaseName(String origName, String subscriptStart, String subscriptEnd) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            return null;
        }
        if (!origName.endsWith(subscriptEnd)) {
            return null;
        }
        String str1 = origName.substring(0, origName.length() - 1);
        int lastIndex = str1.lastIndexOf(subscriptStart);
        if (lastIndex < 0) {
            return null;
        }
        String str2 = str1.substring(lastIndex + 1);
        try {
            long l = Long.parseLong(str2);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            return null;
        }
        String baseName = str1.substring(0, lastIndex);
        return baseName;
    }

    public static String getBaseName(String origName) throws Exception {
        return EtcWordUtil.getBaseName(origName, EtcEnumStrUtil.STRAT, EtcEnumStrUtil.END);
    }

    public static void setWordCollection(DtsWordManager wordManager, Collection<EtcWord> wordCollection) throws Exception {
        for (EtcWord word : wordCollection) {
            wordManager.putWord(word.code, word.lang, word.value);
        }
    }
}

