/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableModel;
import ext.lib.swg.BcTextAreaComboBoxEditor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;

public class SwgTextAreaComboBox
extends JComboBox {
    private static final long serialVersionUID = 2386219100845791823L;
    protected BcTableModel tableModel;
    protected int dispColumnId = -1;
    protected boolean isDefault;
    protected String defaultStr = "";
    protected BcTextAreaComboBoxEditor comboBoxEditor = new BcTextAreaComboBoxEditor();

    public SwgTextAreaComboBox() throws Exception {
        this.setMaximumRowCount(16);
        this.comboBoxEditor.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent ev) {
            }

            @Override
            public void focusLost(FocusEvent ev) {
                SwgTextAreaComboBox.this.setSelectedItem(SwgTextAreaComboBox.this.comboBoxEditor.getItem());
            }
        });
        this.setEditor(this.comboBoxEditor);
    }

    @Override
    public void setSelectedItem(Object obj) {
        super.setSelectedItem(obj);
        if (super.getSelectedItem() != null && !super.getSelectedItem().equals(obj)) {
            super.addItem(obj);
            this.getEditor().setItem(obj);
        }
        super.setSelectedItem(obj);
    }

    @Override
    public ComboBoxEditor getEditor() {
        return this.comboBoxEditor;
    }

    public void setTableModel(BcTableModel tableModel, int dispColumnId, boolean isDefault, String defaultStr) {
        this.tableModel = tableModel;
        this.dispColumnId = dispColumnId;
        this.isDefault = isDefault;
        if (defaultStr != null) {
            this.defaultStr = defaultStr;
        }
        if (this.getItemCount() > 0) {
            super.removeAllItems();
        }
        if (isDefault) {
            super.addItem(this.defaultStr);
        }
        int i = 0;
        while (i < tableModel.getRowCount()) {
            Object valObj = tableModel.getValueAt(i, dispColumnId);
            if (valObj != null) {
                super.addItem(valObj);
            } else {
                super.addItem("");
            }
            ++i;
        }
    }

    public void setTableModel(BcTableModel tableModel, String columnName, boolean isDefault, String defaultStr) {
        this.setTableModel(tableModel, tableModel.getTableColumnModel().getIndexByTableColumnName(columnName), isDefault, defaultStr);
    }

    public int setSelectedItem(int columnId, Object valObj1) {
        if (valObj1 == null) {
            return -1;
        }
        int rowSeq = -1;
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            Object valObj2 = this.tableModel.getValueAt(i, columnId);
            if (valObj2 != null) {
                if (valObj1 instanceof Integer) {
                    Integer integer1 = (Integer)valObj1;
                    if (integer1.equals(valObj2)) {
                        rowSeq = i;
                        break;
                    }
                } else if (valObj1 instanceof String) {
                    String str1 = (String)valObj1;
                    if (str1.equals(valObj2)) {
                        rowSeq = i;
                        break;
                    }
                } else if (valObj1.equals(valObj2)) {
                    rowSeq = i;
                    break;
                }
            }
            ++i;
        }
        if (rowSeq >= 0) {
            if (this.isDefault) {
                super.setSelectedIndex(++rowSeq);
            } else {
                super.setSelectedIndex(rowSeq);
            }
        }
        return rowSeq;
    }

    public int setSelectedItem(String columnName, Object valObj) {
        return this.setSelectedItem(this.tableModel.getTableColumnModel().getIndexByTableColumnName(columnName), valObj);
    }

    public int getSelectedItemAsInt(int columnId, int defaultValue) {
        int rowSeq = super.getSelectedIndex();
        if (this.isDefault) {
            --rowSeq;
        }
        if (rowSeq >= 0) {
            return BcNumberUtil.parseInteger((String)this.tableModel.getValueAt(rowSeq, columnId));
        }
        return defaultValue;
    }

    public int getSelectedItemAsInt(String columnName, int defaultValue) {
        return this.getSelectedItemAsInt(this.tableModel.getTableColumnModel().getIndexByTableColumnName(columnName), defaultValue);
    }

    public String getSelectedItemAsString(int columnId, String defaultValue) {
        int rowSeq = super.getSelectedIndex();
        if (this.isDefault) {
            --rowSeq;
        }
        if (rowSeq >= 0) {
            Object valObj = this.tableModel.getValueAt(rowSeq, columnId);
            if (valObj != null) {
                return (String)valObj;
            }
            return "";
        }
        return defaultValue;
    }

    public String getSelectedItemAsString(String columnName, String defaultValue) {
        return this.getSelectedItemAsString(this.tableModel.getTableColumnModel().getIndexByTableColumnName(columnName), defaultValue);
    }

    public Object clone() {
        SwgTextAreaComboBox obj = null;
        try {
            obj = new SwgTextAreaComboBox();
            obj.setTableModel(this.tableModel, this.dispColumnId, this.isDefault, this.defaultStr);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return obj;
    }
}

