/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcConstants;
import ext.base.core.BcInteger;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.core.BcUnicode;
import ext.base.io.BcStreamTransmitter;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcObjectConvertor;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlTableMetadata;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlSetClause;
import ext.lib.sql.model.SqlUpdateSql;
import ext.lib.sql.model.SqlWhereElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SqlContext
extends BcLoggableObject {
    public static final int TERM_MODE_1 = 1;
    public static final int TERM_MODE_2 = 2;
    public static final int TERM_MODE_3 = 3;
    private SqlConstants.DatabaseProduct databaseProduct;
    protected Map<String, String> tableNameMap;
    public static final String TCN_sy_oid = "sy_oid";
    BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
    public String indent = " ";

    public SqlContext(SqlConstants.DatabaseProduct databaseProduct) {
        this.databaseProduct = databaseProduct;
    }

    public SqlConstants.DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public abstract String[] getDriverClassNames();

    public int getDefaultPort() {
        return -1;
    }

    public void setTransactionIsolation(SqlConnection sqlCon) throws Exception {
        sqlCon.setTransactionIsolation(2);
    }

    public SqlStatement createStatement(SqlConnection sqlConnection, Statement stmt1) throws SQLException {
        SqlStatement stmt2 = new SqlStatement(sqlConnection, stmt1, this);
        return stmt2;
    }

    public SqlStatement createStatementForForward(SqlConnection sqlConnection) throws Exception {
        SqlStatement stmt = sqlConnection.createStatement(1003, 1007);
        return stmt;
    }

    public SqlStatement createStatementForScroll(SqlConnection sqlConnection) throws Exception {
        SqlStatement stmt = sqlConnection.createStatement(1005, 1007, 1);
        return stmt;
    }

    public String getEncoding() throws Exception {
        return "UTF-8";
    }

    public List<SqlTableMetadata> getTableMetadataList(SqlConnection sqlCon, String catalogName, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws Exception {
        ArrayList<SqlTableMetadata> tableMetadataList = new ArrayList<SqlTableMetadata>();
        Throwable throwable = null;
        Object var8_10 = null;
        try (ResultSet rs = sqlCon.getMetaData().getTables(catalogName, schemaNamePattern, tableNamePattern, tableTypes);){
            while (rs.next()) {
                SqlTableMetadata tableMetadata = new SqlTableMetadata();
                this.getTableMetadata(rs, tableMetadata);
                tableMetadataList.add(tableMetadata);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tableMetadataList;
    }

    public List<SqlTableMetadata> getTableMetadataList(SqlConnection sqlCon, String tableNamePattern, String[] tableTypes) throws Exception {
        return this.getTableMetadataList(sqlCon, sqlCon.getCatalog(), sqlCon.getSchema(), tableNamePattern, tableTypes);
    }

    public SqlTableMetadata getTableMetadata(SqlConnection sqlCon, String tableNamePattern) throws Exception {
        List<SqlTableMetadata> tableMetadataList = this.getTableMetadataList(sqlCon, tableNamePattern, null);
        return BcCollectionUtil.getFirst(tableMetadataList);
    }

    protected void getTableMetadata(ResultSet rs, SqlTableMetadata tableMetadata) throws Exception {
        tableMetadata.TABLE_CAT = rs.getString("TABLE_CAT");
        tableMetadata.TABLE_SCHEM = rs.getString("TABLE_SCHEM");
        tableMetadata.TABLE_NAME = rs.getString("TABLE_NAME");
        tableMetadata.TABLE_TYPE = rs.getString("TABLE_TYPE");
        tableMetadata.REMARKS = rs.getString("REMARKS");
        tableMetadata.TYPE_CAT = rs.getString("TYPE_CAT");
        tableMetadata.TYPE_SCHEM = rs.getString("TYPE_SCHEM");
        tableMetadata.TYPE_NAME = rs.getString("TYPE_NAME");
        tableMetadata.SELF_REFERENCING_COL_NAME = rs.getString("SELF_REFERENCING_COL_NAME");
        tableMetadata.REF_GENERATION = rs.getString("REF_GENERATION");
    }

    public List<String> getTableNameList(SqlConnection sqlCon, String ... tableTypes) throws Exception {
        ArrayList<String> tableNameList = new ArrayList<String>();
        Throwable throwable = null;
        Object var5_7 = null;
        try (ResultSet rs = sqlCon.getMetaData().getTables(sqlCon.getCatalog(), sqlCon.getSchema(), null, tableTypes);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                tableNameList.add(tableName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tableNameList;
    }

    public List<String> getTableNameList(SqlConnection sqlCon) throws Exception {
        return this.getTableNameList(sqlCon, SqlConstants.TableType.TABLE.name());
    }

    public List<String> getViewNameList(SqlConnection sqlCon) throws Exception {
        return this.getTableNameList(sqlCon, SqlConstants.TableType.VIEW.name());
    }

    public String tableNameToDB(SqlConnection sqlCon, String tableName) throws Exception {
        String resValue;
        if (this.tableNameMap == null) {
            this.tableNameMap = new HashMap<String, String>();
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = sqlCon.getMetaData().getTables(null, null, null, null);){
                while (rs.next()) {
                    String tmpStr = rs.getString("TABLE_NAME");
                    this.tableNameMap.put(tmpStr.toLowerCase(), tmpStr);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (BcStringUtil.isEmpty(resValue = this.tableNameMap.get(tableName.toLowerCase()))) {
            resValue = tableName;
        }
        return resValue;
    }

    public MmdModel createModelMetaData(SqlConnection sqlCon, String tableName, boolean doGetKey) throws Exception {
        if (BcStringUtil.isEmpty(tableName)) {
            throw new Exception("Table name is null.");
        }
        MmdModel mmdModel = new MmdModel();
        String tableName2 = this.tableNameToDB(sqlCon, tableName);
        SqlTableMetadata tableMetadata = this.getTableMetadata(sqlCon, tableName2);
        if (SqlConstants.TableType.VIEW.value.equals(tableMetadata.TABLE_TYPE)) {
            doGetKey = false;
        }
        Throwable throwable = null;
        Object var8_10 = null;
        try (ResultSet rs = sqlCon.getMetaData().getColumns(null, null, tableName2, null);){
            mmdModel.modelName = tableName;
            mmdModel.tableName = tableName;
            mmdModel.note = tableMetadata.REMARKS;
            while (rs.next()) {
                MmdField mmdField = new MmdField();
                String tableNameTmp = rs.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(tableNameTmp)) {
                    break;
                }
                mmdField.columnName = rs.getString("COLUMN_NAME");
                mmdField.sqlTypeId = rs.getInt("DATA_TYPE");
                mmdField.dataSize = rs.getInt("COLUMN_SIZE");
                mmdField.dataClass = MmdUtil.toJavaType(mmdField.sqlTypeId);
                if (!BcNumberUtil.isFloatingaPointClass(mmdField.dataClass)) {
                    MmdUtil.setDecimalPosition(mmdField, rs.getInt("DECIMAL_DIGITS"));
                }
                String isNullable = rs.getString("IS_NULLABLE");
                mmdField.nullable = BcBooleanUtil.toShort(BcBooleanUtil.parseBoolean(isNullable));
                mmdField.ordinalPosition = rs.getInt("ORDINAL_POSITION");
                mmdField.note = rs.getString("REMARKS");
                mmdModel.addField(mmdField);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (doGetKey) {
            List<MmdIndex> mmdIndexList = this.getKeyList(sqlCon, tableName, mmdModel);
            int i = 0;
            while (i < mmdIndexList.size()) {
                MmdIndex mmdIndex = mmdIndexList.get(i);
                mmdModel.addIndex(mmdIndex);
                ++i;
            }
            mmdModel.primaryIndexName = this.getPrimaryKeyName(sqlCon, tableName);
        }
        return mmdModel;
    }

    public MmdModel createModelMetaData(SqlConnection sqlCon, String tableName) throws Exception {
        return this.createModelMetaData(sqlCon, tableName, true);
    }

    public MmdIndex getPrimaryKey(SqlConnection sqlCon, String tableName) throws Exception {
        String tableName2 = this.tableNameToDB(sqlCon, tableName);
        MmdIndex mmdIndex = null;
        Throwable throwable = null;
        Object var6_8 = null;
        try (ResultSet rs = sqlCon.getMetaData().getPrimaryKeys(null, null, tableName2);){
            while (rs.next()) {
                if (mmdIndex == null) {
                    mmdIndex = new MmdIndex();
                    mmdIndex.name = rs.getString("PK_NAME");
                }
                MmdIndexElement indexElement = new MmdIndexElement();
                indexElement.columnName = rs.getString("COLUMN_NAME");
                short keySeq = rs.getShort("KEY_SEQ");
                BcCollectionUtil.setElement(mmdIndex.indexElementList, keySeq - 1, indexElement);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return mmdIndex;
    }

    public String getPrimaryKeyName(SqlConnection sqlCon, String tableName) throws Exception {
        String tableName2 = this.tableNameToDB(sqlCon, tableName);
        String primaryKeyName = null;
        Throwable throwable = null;
        Object var6_8 = null;
        try (ResultSet rs = sqlCon.getMetaData().getPrimaryKeys(null, null, tableName2);){
            if (rs.next()) {
                primaryKeyName = rs.getString("PK_NAME");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return primaryKeyName;
    }

    public List<MmdIndex> getKeyList(SqlConnection sqlCon, String tableName, MmdModel mmdModel) throws Exception {
        ArrayList<MmdIndex> mmdIndexList = new ArrayList<MmdIndex>();
        String tableName2 = this.tableNameToDB(sqlCon, tableName);
        MmdIndex mmdIndex = null;
        Throwable throwable = null;
        Object var8_10 = null;
        try (ResultSet rs = sqlCon.getMetaData().getIndexInfo(sqlCon.getCatalog(), sqlCon.getSchema(), tableName2, false, false);){
            String indexNamePre = null;
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (BcStringUtil.isEmpty(indexName)) continue;
                if (!indexName.equals(indexNamePre)) {
                    if (mmdIndex != null) {
                        mmdIndexList.add(mmdIndex);
                    }
                    mmdIndex = new MmdIndex();
                    mmdIndex.name = indexName;
                }
                MmdIndexElement indexElement = new MmdIndexElement();
                indexElement.columnName = rs.getString("COLUMN_NAME");
                indexElement.ordinalPosition = rs.getShort("ORDINAL_POSITION");
                boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                mmdIndex.isUnique = !nonUnique;
                String ascOrDesc = rs.getString("ASC_OR_DESC");
                indexElement.isAscending = BcStringUtil.equals(ascOrDesc, "A");
                BcCollectionUtil.setElement(mmdIndex.indexElementList, indexElement.ordinalPosition - 1, indexElement);
                indexNamePre = indexName;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (mmdIndex != null) {
            mmdIndexList.add(mmdIndex);
        }
        return mmdIndexList;
    }

    public String reformForMetadata(CharSequence objectName) throws Exception {
        if (objectName == null) {
            return null;
        }
        return objectName.toString();
    }

    public int getSqlType(SqlConnection sqlCon, String tableName, String columnName) throws Exception {
        String tableName2 = this.reformForMetadata(tableName);
        String columnName2 = this.reformForMetadata(columnName);
        Throwable throwable = null;
        Object var7_9 = null;
        try (ResultSet rs = sqlCon.getMetaData().getColumns(sqlCon.getCatalog(), sqlCon.getSchema(), tableName2, columnName2);){
            if (rs.next()) {
                return rs.getInt("DATA_TYPE");
            }
            throw new Exception("not found tableName=" + tableName2 + " columnName=" + columnName2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<Integer> getSqlTypeList(SqlConnection sqlCon, String tableName, List<String> columnNameList) throws Exception {
        ArrayList<Integer> sqlTypeList = new ArrayList<Integer>();
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            int sqlType = this.getSqlType(sqlCon, tableName, columnName);
            sqlTypeList.add(sqlType);
            ++i;
        }
        return sqlTypeList;
    }

    public String type_TINYINT() {
        return "TINYINT";
    }

    public String type_SMALLINT() {
        return "SMALLINT";
    }

    public String type_INTEGER() {
        return "INTEGER";
    }

    public String type_BIGINT() {
        return "BIGINT";
    }

    public String type_REAL() {
        return "REAL";
    }

    public String type_DOUBLE() {
        return "DOUBLE";
    }

    public String type_NUMERIC(int precision, int scale) {
        return "NUMERIC(" + precision + ", " + scale + ")";
    }

    public String type_CHAR(int size) {
        if (size <= 255) {
            return "CHAR(" + size + ")";
        }
        return this.type_VARCHAR(size);
    }

    public String type_VARCHAR(int size) {
        if (size <= 255) {
            return "VARCHAR(" + size + ")";
        }
        return this.type_LONGVARCHAR();
    }

    public String type_LONGVARCHAR() {
        return "TEXT";
    }

    public String type_CLOB() {
        return "CLOB";
    }

    public String type_DATE() {
        return "DATE";
    }

    public String type_TIME() {
        return "TIME";
    }

    public String type_TIMESTAMP() {
        return "TIMESTAMP";
    }

    public String type_BIT() {
        return this.type_BOOLEAN();
    }

    public String type_BOOLEAN() {
        return "BOOLEAN";
    }

    public String type_BINARY() {
        return "BINARY";
    }

    public String type_LONGVARBINARY() {
        return "LONGVARBINARY";
    }

    public String type_BLOB() {
        return "BLOB";
    }

    public String escapEncode(String srcStr) throws Exception {
        if (srcStr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < srcStr.length()) {
            this.escapEncode_L2(srcStr.charAt(i), sb);
            ++i;
        }
        return sb.toString();
    }

    public void escapEncode_L2(char aChar, StringBuilder sb) throws Exception {
        switch (aChar) {
            case '\'': {
                sb.append('\'');
                sb.append(aChar);
                break;
            }
            case '\\': {
                sb.append('\\');
                sb.append(aChar);
                break;
            }
            default: {
                sb.append(aChar);
            }
        }
    }

    public String getTimestampFormatForUpdate() {
        return "yyyy/MM/dd HH:mm:ss";
    }

    public String getTimestampFormatForCondition() {
        return "yyyy/MM/dd HH:mm:ss";
    }

    public String getDateTimeFormatForCondition() {
        return "yyyy/MM/dd HH:mm:ss";
    }

    public String getDateFormatForCondition() {
        return "yyyy/MM/dd";
    }

    public void set_LONGVARCHAR(PreparedStatement ppst, int colmunIndex, Reader reader, int dataSize) throws Exception {
        if (reader != null) {
            if (dataSize > 0) {
                ppst.setCharacterStream(colmunIndex, reader, dataSize);
            } else {
                ppst.setNull(colmunIndex, -1);
            }
        } else {
            ppst.setNull(colmunIndex, -1);
        }
    }

    public void set_LONGVARCHAR(PreparedStatement ppst, int colmunIndex, Reader reader) throws Exception {
        if (reader != null) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            BcStreamUtil.transmit(reader, charArrayWriter, 1024);
            CharArrayReader charArrayReader = new CharArrayReader(charArrayWriter.toCharArray());
            this.set_LONGVARCHAR(ppst, colmunIndex, charArrayReader, charArrayWriter.size());
        } else {
            ppst.setNull(colmunIndex, -1);
        }
    }

    public void set_LONGVARCHAR(PreparedStatement ppst, int colmunIndex, String charSequence) throws Exception {
        if (!BcStringUtil.isEmpty(charSequence)) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            charArrayWriter.append(charSequence);
            CharArrayReader charArrayReader = new CharArrayReader(charArrayWriter.toCharArray());
            this.set_LONGVARCHAR(ppst, colmunIndex, charArrayReader, charArrayWriter.size());
        } else {
            ppst.setNull(colmunIndex, -1);
        }
    }

    public void set_LONGVARBINARY(PreparedStatement ppst, int colmunIndex, InputStream is) throws Exception {
        if (is != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.streamTransmitter.transmit(is, baos);
            is.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            if (baos.size() > 0) {
                ppst.setBinaryStream(colmunIndex, (InputStream)bais, baos.size());
            } else {
                this.setNull_LONGVARBINARY(ppst, colmunIndex);
            }
        } else {
            this.setNull_LONGVARBINARY(ppst, colmunIndex);
        }
    }

    public void setNull_LONGVARBINARY(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, -4);
    }

    public void set_BLOB(PreparedStatement ppst, int colmunIndex, Blob blob) throws Exception {
        ppst.setBlob(colmunIndex, blob);
    }

    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, 2004);
    }

    public void setPreStmtValue(PreparedStatement ppst, int columnIndex, Object value, int sqlTypeId) throws Exception {
        if (value == null) {
            ppst.setNull(columnIndex, sqlTypeId);
        } else {
            Object jdbcValue = this.toJdbcValue(value);
            ppst.setObject(columnIndex, jdbcValue);
        }
    }

    public void setPreStmtValue(PreparedStatement ppst, BcInteger columnIndex, Object value, int sqlTypeId) throws Exception {
        ++columnIndex.value;
        this.setPreStmtValue(ppst, columnIndex.value, value, sqlTypeId);
    }

    public void setPreStmtValues(PreparedStatement ppst, List<Object> valueList, List<Integer> sqlTypeIdList) throws Exception {
        int i = 0;
        while (i < valueList.size()) {
            Object value = valueList.get(i);
            this.setPreStmtValue(ppst, i + 1, value, (int)sqlTypeIdList.get(i));
            ++i;
        }
    }

    public int convSqlType(int sqlTypeId) {
        return sqlTypeId;
    }

    public Object toJdbcValue(Object src) throws Exception {
        if (src == null) {
            return null;
        }
        Object jdbcValue = src;
        if (Character.class.isAssignableFrom(src.getClass()) || Character.TYPE.isAssignableFrom(src.getClass())) {
            jdbcValue = src.toString();
        } else if (Calendar.class.isAssignableFrom(src.getClass())) {
            Calendar calendar = (Calendar)src;
            jdbcValue = new Timestamp(calendar.getTimeInMillis());
        } else if (java.util.Date.class.isAssignableFrom(src.getClass())) {
            java.util.Date date = (java.util.Date)src;
            jdbcValue = new Date(date.getTime());
        }
        return jdbcValue;
    }

    public String toSet(Object value, Class valueClass) throws Exception {
        if (Number.class.isAssignableFrom(valueClass)) {
            return this.toSet((Number)value);
        }
        if (CharSequence.class.isAssignableFrom(valueClass)) {
            return this.toSet((CharSequence)value);
        }
        if (Character.class.isAssignableFrom(valueClass)) {
            return this.toSet(value.toString());
        }
        if (Calendar.class.isAssignableFrom(valueClass)) {
            return this.toSet((Calendar)value);
        }
        if (java.util.Date.class.isAssignableFrom(valueClass)) {
            return this.toSet((java.util.Date)value);
        }
        return this.toSet(value, MmdUtil.toSqlTypeId(valueClass));
    }

    public String toSet(Object value) throws Exception {
        if (value != null) {
            return this.toSet(value, value.getClass());
        }
        return "NULL";
    }

    public String toSet(Number number) {
        if (number != null) {
            return number.toString();
        }
        return "NULL";
    }

    public String toSet(boolean value) {
        return String.valueOf(value);
    }

    public String toSet(CharSequence charSequence) throws Exception {
        if (charSequence == null) {
            return "NULL";
        }
        return BcStringUtil.singleQuotation(this.escapEncode(charSequence.toString()));
    }

    public String toSet(Calendar calendar) throws Exception {
        if (calendar != null) {
            return BcStringUtil.singleQuotation(BcTimeUtil.toString(calendar, this.getTimestampFormatForUpdate()));
        }
        return "NULL";
    }

    public String toSet(java.util.Date date) throws Exception {
        if (date != null) {
            Calendar calendar = BcTimeUtil.createCalendar();
            calendar.setTimeInMillis(date.getTime());
            return this.toSet(calendar);
        }
        return "NULL";
    }

    public String toSet(Object value, int sqlType) throws Exception {
        if (value == null) {
            return "NULL";
        }
        switch (sqlType) {
            case 0: {
                return "NULL";
            }
        }
        throw new Exception("not suport sqlType=" + sqlType);
    }

    public String func_trim(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TRIM(");
        sb.append(columnName);
        sb.append(")");
        return sb.toString();
    }

    public String func_length(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("LENGTH(");
        sb.append(columnName);
        sb.append(")");
        return sb.toString();
    }

    public String func_toChar(String columnName, String format) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TOCHAR(");
        sb.append(columnName);
        if (!BcStringUtil.isEmpty(format)) {
            sb.append("," + format);
        }
        sb.append(")");
        return sb.toString();
    }

    public String func_toChar(String columnName) throws Exception {
        return this.func_toChar(columnName, null);
    }

    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTR(");
        sb.append(columnName);
        if (startIndex > 0) {
            sb.append("," + startIndex);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        sb.append(")");
        return sb.toString();
    }

    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    public String func_sum(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUM(");
        sb.append(columnName);
        sb.append(")");
        return sb.toString();
    }

    public String func_clockTimestamp() throws Exception {
        return "clock_timestamp()";
    }

    public String func_statementTimestamp() throws Exception {
        return "statement_timestamp()";
    }

    public String func_transactionTimestamp() throws Exception {
        return "transaction_timestamp()";
    }

    public String func_coalesce(String ... values) throws Exception {
        return "COALESCE(" + BcStringUtil.toCsv(true, values) + ")";
    }

    public String func_replace2(String src, String search, String replacement) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("REPLACE(");
        sb.append(src);
        sb.append(", ");
        sb.append(search);
        sb.append(", ");
        sb.append(replacement);
        sb.append(")");
        return sb.toString();
    }

    public String func_replace(String src, String search, String replacement) throws Exception {
        return this.func_replace(src, BcStringUtil.singleQuotation(search), BcStringUtil.singleQuotation(replacement));
    }

    public String func_replace_regexp(String src, String regexp, String replacement, String flags) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("REGEXP_REPLACE(");
        sb.append(src);
        sb.append(", ");
        sb.append(regexp);
        sb.append(", ");
        sb.append(replacement);
        if (!BcStringUtil.isEmpty(flags)) {
            sb.append(", ");
            sb.append(flags);
        }
        sb.append(")");
        return sb.toString();
    }

    public String func_replace_regexp(String src, String regexp, String replacement) throws Exception {
        return this.func_replace_regexp(src, BcStringUtil.singleQuotation(regexp), BcStringUtil.singleQuotation(replacement), null);
    }

    public String funk_deleteSpace(String src, boolean isFullWidth) throws Exception {
        String formula1 = this.func_replace2(src, BcStringUtil.singleQuotation(BcStringUtil.SPACE_STR), "''");
        if (isFullWidth) {
            return this.func_replace2(formula1, BcUnicode.FULLWIDTH_SPACE_STR, "''");
        }
        return formula1;
    }

    public String createCreateTableSql(MmdModel mmdModel, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(mmdModel.tableName);
        sb.append(lineSep);
        sb.append(" (");
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            if (i == 0) {
                sb.append(" ");
            } else {
                sb.append("  ,");
            }
            sb.append((CharSequence)this.createColumnPhrase(mmdField));
            sb.append(lineSep);
            ++i;
        }
        String primaryKeySql = this.createCreateTableSql_primaryKey(mmdModel, lineSep);
        if (!BcStringUtil.isEmpty(primaryKeySql)) {
            sb.append("  ,");
            sb.append(primaryKeySql);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String createCreateTableSql_primaryKey(MmdModel mmdModel, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            sb.append("CONSTRAINT");
            sb.append(" " + primaryKey.name);
            sb.append(" PRIMARY KEY");
            sb.append(" (");
            int i = 0;
            while (i < primaryKey.indexElementList.size()) {
                MmdIndexElement indexElement = primaryKey.indexElementList.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(indexElement.columnName);
                ++i;
            }
            sb.append(")");
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public String createCreateTableSql(MmdModel mmdModel) throws Exception {
        return this.createCreateTableSql(mmdModel, BcStringUtil.lineSeparator);
    }

    public StringBuilder createColumnPhrase(MmdField mmdField) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(mmdField.columnName);
        sb.append(" ");
        String dataType = this.toDataType(mmdField);
        sb.append(dataType);
        return sb;
    }

    public String toDataType(MmdField mmdField) throws Exception {
        StringBuilder sb = new StringBuilder();
        switch (mmdField.sqlTypeId) {
            case -6: {
                sb.append(this.type_TINYINT());
                break;
            }
            case 5: {
                sb.append(this.type_SMALLINT());
                break;
            }
            case 4: {
                sb.append(this.type_INTEGER());
                break;
            }
            case -5: {
                sb.append(this.type_BIGINT());
                break;
            }
            case 6: 
            case 7: {
                sb.append(this.type_REAL());
                break;
            }
            case 8: {
                sb.append(this.type_DOUBLE());
                break;
            }
            case 2: 
            case 3: {
                String tmpStr = this.type_NUMERIC(mmdField.dataSize, mmdField.decimalPosition);
                sb.append(tmpStr);
                break;
            }
            case 1: {
                sb.append(this.type_CHAR(mmdField.dataSize));
                break;
            }
            case 12: {
                sb.append(this.type_VARCHAR(mmdField.dataSize));
                break;
            }
            case -1: {
                sb.append(this.type_LONGVARCHAR());
                break;
            }
            case 91: {
                sb.append(this.type_DATE());
                break;
            }
            case 92: {
                sb.append(this.type_TIME());
                break;
            }
            case 93: {
                sb.append(this.type_TIMESTAMP());
                break;
            }
            case -7: {
                sb.append(this.type_BIT());
                break;
            }
            case 16: {
                sb.append(this.type_BOOLEAN());
                break;
            }
            case 2005: {
                sb.append(this.type_CLOB());
                break;
            }
            case -3: 
            case -2: {
                sb.append(this.type_BINARY());
                break;
            }
            case -4: 
            case 2004: {
                sb.append(this.type_BLOB());
                break;
            }
            default: {
                throw new Exception("not supported jdbc type:" + mmdField.sqlTypeId);
            }
        }
        if (mmdField.nullable != BcConstants.Existence.TRUE.value) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    public int createTable(SqlConnection sqlCon, MmdModel mmdModel, BcLogger logger) throws Exception {
        String sql = this.createCreateTableSql(mmdModel);
        logger.info("sql=" + sql);
        int cnt = 0;
        try (SqlStatement stmt = sqlCon.createStatement();){
            stmt.executeUpdate(sql);
        }
        return cnt;
    }

    public int createIndex(SqlConnection sqlCon, MmdModel mmdModel, BcLogger logger) throws Exception {
        int cnt = 0;
        Throwable throwable = null;
        Object var6_8 = null;
        try (SqlStatement stmt = sqlCon.createStatement();){
            for (Map.Entry<String, MmdIndex> mapEntry : mmdModel.indexMap.entrySet()) {
                MmdIndex mmdIndex = mapEntry.getValue();
                if (mmdModel.getPrimaryIndex() != null && mmdIndex.name.equalsIgnoreCase(mmdModel.getPrimaryIndex().name)) continue;
                cnt += this.createIndex(sqlCon, mmdModel, mmdIndex);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return cnt;
    }

    public int dropTable(SqlConnection sqlCon, String tableName) throws Exception {
        String sql = "DROP TABLE " + tableName;
        this.getLogger().info("sql=" + sql);
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public String createCreateIndexSql(MmdModel mmdModel, MmdIndex mmdIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (mmdIndex.isUnique) {
            sb.append("CREATE UNIQUE INDEX ");
        } else {
            sb.append("CREATE INDEX ");
        }
        sb.append(mmdIndex.name);
        sb.append(" ON ");
        sb.append(mmdModel.tableName);
        sb.append("(");
        int i = 0;
        while (i < mmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdIndex.indexElementList.get(i);
            if (i == 0) {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            sb.append(indexElement.columnName);
            ++i;
        }
        sb.append(" )");
        return sb.toString();
    }

    public int createIndex(SqlConnection sqlCon, MmdModel mmdModel, MmdIndex mmdIndex) throws Exception {
        String sql = this.createCreateIndexSql(mmdModel, mmdIndex);
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public int dropIndex(SqlConnection sqlCon, String tableName, String indexName) throws Exception {
        String sql = "DROP INDEX " + indexName + " ON " + tableName;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public int addColumn(SqlConnection sqlCon, String tableName, String columnName, String dataType) throws Exception {
        String sql = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + dataType;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public int dropColumn(SqlConnection sqlCon, String tableName, String columnName) throws Exception {
        String sql = "ALTER TABLE " + tableName + " DROP COLUMN " + columnName;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public String createCreateViewSql(String viewName, String selectSql) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE VIEW ");
        sb.append(viewName);
        sb.append(" AS ");
        sb.append(selectSql);
        return sb.toString();
    }

    public int createView(SqlConnection sqlCon, String viewName, String selectSql) throws Exception {
        String sql = this.createCreateViewSql(viewName, selectSql);
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public int dropView(SqlConnection sqlCon, String viewName) throws Exception {
        String sql = "DROP VIEW " + viewName;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public List<String> dropViewAndTableByPattern(SqlConnection sqlCon, String namePattern) throws Exception {
        ArrayList<String> nameList = new ArrayList<String>();
        Pattern pattern = null;
        if (!BcStringUtil.isEmpty(namePattern)) {
            pattern = Pattern.compile(namePattern.toString());
        }
        List<String> viewNameList = this.getViewNameList(sqlCon);
        int i = 0;
        while (i < viewNameList.size()) {
            String viewName = viewNameList.get(i);
            boolean doDrop = false;
            if (pattern != null) {
                Matcher matcher = pattern.matcher(viewName);
                doDrop = matcher.matches();
            } else {
                doDrop = true;
            }
            if (doDrop) {
                this.dropView(sqlCon, viewName);
                nameList.add(viewName);
            }
            ++i;
        }
        List<String> tableNameList = this.getTableNameList(sqlCon);
        int i2 = 0;
        while (i2 < tableNameList.size()) {
            String tableName = tableNameList.get(i2);
            boolean doDrop = false;
            if (pattern != null) {
                Matcher matcher = pattern.matcher(tableName);
                doDrop = matcher.matches();
            } else {
                doDrop = true;
            }
            if (doDrop) {
                this.dropTable(sqlCon, tableName);
                nameList.add(tableName);
            }
            ++i2;
        }
        return nameList;
    }

    public int dropFunction(SqlConnection sqlCon, String functionName) throws Exception {
        String sql = "DROP FUNCTION " + functionName;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public int truncateTable(SqlConnection sqlCon, String tableName) throws Exception {
        String sql = "TRUNCATE TABLE " + tableName;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public void truncateTables(SqlConnection sqlCon, String ... tableNames) throws Exception {
        int i = 0;
        while (i < tableNames.length) {
            this.truncateTable(sqlCon, tableNames[i]);
            ++i;
        }
    }

    public int deleteAllRow(SqlConnection sqlCon, String tableName) throws Exception {
        String sql = "DELETE FROM " + tableName;
        return SqlUtil.executeUpdate(sqlCon, sql);
    }

    public boolean existIndex(SqlConnection sqlCon, String tableName, String indexName) throws Exception {
        boolean bool = false;
        try (ResultSet rs = sqlCon.getMetaData().getIndexInfo(sqlCon.getCatalog(), sqlCon.getSchema(), tableName, false, false);){
            while (rs.next()) {
                String vTABLE_CAT = rs.getString("TABLE_CAT");
                String vTABLE_SCHEM = rs.getString("TABLE_SCHEM");
                String tableName2 = rs.getString("TABLE_NAME");
                boolean vNON_UNIQUE = rs.getBoolean("NON_UNIQUE");
                String vINDEX_QUALIFIER = rs.getString("INDEX_QUALIFIER");
                String indexName2 = rs.getString("INDEX_NAME");
                short vTYPE = rs.getShort("TYPE");
                short vORDINAL_POSITION = rs.getShort("ORDINAL_POSITION");
                String vCOLUMN_NAME = rs.getString("COLUMN_NAME");
                String vASC_OR_DESC = rs.getString("ASC_OR_DESC");
                this.getLogger().debug("tableName=" + tableName2 + " indexName=" + indexName2 + " " + vORDINAL_POSITION + " vCOLUMN_NAME=" + vCOLUMN_NAME);
                int vCARDINALITY = rs.getInt("CARDINALITY");
                int vPAGES = rs.getInt("PAGES");
                String vFILTER_CONDITION = rs.getString("FILTER_CONDITION");
                if (BcStringUtil.isEmpty(indexName2) || !indexName2.equalsIgnoreCase(indexName)) continue;
                bool = true;
                break;
            }
        }
        return bool;
    }

    public boolean existIndex(SqlConnection sqlCon, String indexName) throws Exception {
        boolean bool = false;
        List<String> tableNameList = this.getTableNameList(sqlCon);
        int i = 0;
        while (i < tableNameList.size()) {
            String tableName = tableNameList.get(i);
            bool = this.existIndex(sqlCon, tableName, indexName);
            if (bool) break;
            ++i;
        }
        return bool;
    }

    public String buildWhereClause(Collection<SqlWhereElement> whereElementCollection, CharSequence lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (SqlWhereElement whereElement : whereElementCollection) {
            if (BcStringUtil.isEmpty(whereElement.getFormula())) continue;
            if (sb.length() > 0) {
                sb.append(lineSep);
                sb.append(" ");
                sb.append(whereElement.getLogical());
                sb.append(" ");
            }
            sb.append(whereElement.getFormula());
        }
        return sb.toString();
    }

    public String buildWhereClause(List<SqlWhereElement> whereElementList) throws Exception {
        return this.buildWhereClause(whereElementList, BcStringUtil.lineSeparator);
    }

    public abstract String setLimit(String var1, int var2, int var3) throws Exception;

    public String setLimit(String srcSql, int limit) throws Exception {
        return this.setLimit(srcSql, limit, 0);
    }

    public StringBuilder toNumber(String columnName, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CONVERT(");
        sb.append(columnName);
        sb.append(", INT)");
        return sb;
    }

    public void margeCondition(StringBuilder condition1, String logical, String condition2) throws Exception {
        if (condition2 == null) {
            return;
        }
        if (BcStringUtil.isEmpty(condition2.toString())) {
            return;
        }
        if (!BcStringUtil.isEmpty(condition1)) {
            condition1.append(" ");
            condition1.append(logical);
            condition1.append(" ");
        }
        condition1.append(condition2);
    }

    public boolean isOperatorEquals(String operator) {
        return operator.trim().equals("=");
    }

    public String isNull() {
        return "Is NULL";
    }

    public String isNotNull() {
        return "Is Not NULL";
    }

    public String toCondition(String operator, Object value) throws Exception {
        if (value == null) {
            if (this.isOperatorEquals(operator)) {
                return " " + this.isNull();
            }
            return " " + this.isNotNull();
        }
        Class<?> valueClass = value.getClass();
        if (Number.class.isAssignableFrom(valueClass)) {
            return this.toCondition_number(operator, (Number)value);
        }
        if (CharSequence.class.isAssignableFrom(valueClass)) {
            return this.toCondition_string(operator, value.toString());
        }
        return String.valueOf(operator) + this.toSet(value);
    }

    public String toCondition_string(String operator, String value) throws Exception {
        if (value != null) {
            return String.valueOf(operator) + this.toSet(value);
        }
        if (this.isOperatorEquals(operator)) {
            return " " + this.isNull();
        }
        return " " + this.isNotNull();
    }

    public String toCondition_string(SqlConstants.PatternMatch patternMatch, boolean isEquals, String value) throws Exception {
        if (value != null) {
            if (SqlConstants.PatternMatch.exactMatch == patternMatch) {
                if (isEquals) {
                    return "=" + this.toSet(value);
                }
                return "<>" + this.toSet(value);
            }
            return this.toPatternMatch(patternMatch, value);
        }
        if (isEquals) {
            return " " + this.isNull();
        }
        return " " + this.isNotNull();
    }

    public String toCondition_number(String operator, Number number) throws Exception {
        if (number != null) {
            return String.valueOf(operator) + number.toString();
        }
        if (this.isOperatorEquals(operator)) {
            return " " + this.isNull();
        }
        return " " + this.isNotNull();
    }

    public StringBuilder toCondition_between1(String columnName1, String columnName2, Object value, boolean isNumber) throws Exception {
        StringBuilder sb = new StringBuilder();
        String tmpStr = null;
        tmpStr = isNumber ? value.toString() : BcStringUtil.singleQuotation(BcStringUtil.toString(value)).toString();
        sb.append("(" + columnName1 + " <= " + tmpStr + " AND " + columnName2 + " >= " + tmpStr + ")");
        return sb;
    }

    public StringBuilder toCondition_between_number(String columnName, Object number1, Object number2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (number1 != null) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + " >= " + number1);
        }
        if (number2 != null) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + " <= " + number2);
        }
        return sb;
    }

    public StringBuilder toCondition_between_string(String columnName, String str1, String str2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(str1)) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + this.toCondition_string(" >= ", str1));
        }
        if (!BcStringUtil.isEmpty(str2)) {
            this.margeCondition(sb, "AND", String.valueOf(columnName) + this.toCondition_string(" <= ", str2));
        }
        return sb;
    }

    public String toCondition_timestamp(Calendar calendar) {
        String tmpStr = BcTimeUtil.toString(calendar, this.getTimestampFormatForCondition());
        return BcStringUtil.singleQuotation(tmpStr).toString();
    }

    public String toCondition_datetime(Calendar calendar) {
        String tmpStr = BcTimeUtil.toString(calendar, this.getDateTimeFormatForCondition());
        return BcStringUtil.singleQuotation(tmpStr).toString();
    }

    public String toCondition_date(Calendar calendar) {
        String tmpStr = BcTimeUtil.toString(calendar, this.getDateFormatForCondition());
        return BcStringUtil.singleQuotation(tmpStr).toString();
    }

    public String toCondition_timestamp(CharSequence columnName, Calendar calendar) throws Exception {
        if (calendar != null) {
            return columnName + "=" + this.toCondition_timestamp(calendar);
        }
        return columnName + " " + this.isNull();
    }

    public String toCondition_date(CharSequence columnName, Calendar calendar) throws Exception {
        if (calendar != null) {
            return columnName + "=" + this.toCondition_date(calendar);
        }
        return columnName + " " + this.isNull();
    }

    public StringBuilder toCondition_period_datetime(CharSequence columnName, Calendar datetime1, Calendar datetime2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (datetime1 == null && datetime2 == null) {
            return sb;
        }
        if (datetime1 != null) {
            sb.append(columnName + " >= " + this.toCondition_datetime(datetime1));
        }
        if (datetime2 != null) {
            if (datetime1 != null) {
                sb.append(" AND ");
                sb.append(columnName + " <= " + this.toCondition_datetime(datetime2));
            } else {
                sb.append(columnName + " <= " + this.toCondition_datetime(datetime2));
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb;
    }

    public StringBuilder toCondition_period_date(CharSequence columnName, Calendar date1, Calendar date2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (date1 == null && date2 == null) {
            return sb;
        }
        if (date1 != null) {
            Calendar tmpCalendar1 = (Calendar)date1.clone();
            BcTimeUtil.initTimeField(tmpCalendar1);
            sb.append(columnName + " >= " + this.toCondition_datetime(tmpCalendar1));
        }
        if (date2 != null) {
            Calendar tmpCalendar2 = (Calendar)date2.clone();
            tmpCalendar2.add(5, 1);
            BcTimeUtil.initTimeField(tmpCalendar2);
            if (date1 != null) {
                sb.append(" AND ");
            }
            sb.append(columnName + " < " + this.toCondition_datetime(tmpCalendar2));
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb;
    }

    public StringBuilder toCondition_period_date(String columnName, int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        Calendar calendar1 = BcTimeUtil.toCalendar(yyyyMMdd1);
        Calendar calendar2 = BcTimeUtil.toCalendar(yyyyMMdd2);
        return this.toCondition_period_date((CharSequence)columnName, calendar1, calendar2);
    }

    public StringBuilder toCondition_period_date(String columnName1, String columnName2, Calendar calendar1, Calendar calendar2, int termMode, boolean nullable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (calendar1 == null && calendar2 == null) {
            return sb;
        }
        switch (termMode) {
            case 2: {
                sb.append("(");
                sb.append((CharSequence)this.toCondition_period_date((CharSequence)columnName1, calendar1, calendar2));
                sb.append(" AND ");
                sb.append((CharSequence)this.toCondition_period_date((CharSequence)columnName2, calendar1, calendar2));
                sb.append(")");
                break;
            }
            case 3: {
                Calendar calendar1Tmp = (Calendar)calendar1.clone();
                BcTimeUtil.initTimeField(calendar1Tmp);
                Calendar calendar2Tmp = (Calendar)calendar2.clone();
                calendar2Tmp.add(5, 1);
                BcTimeUtil.initTimeField(calendar2Tmp);
                sb.append(String.valueOf(columnName1) + " >= " + this.toCondition_datetime(calendar1Tmp));
                sb.append(" AND ");
                sb.append(String.valueOf(columnName2) + " < " + this.toCondition_datetime(calendar2Tmp));
                break;
            }
            default: {
                sb.append((CharSequence)this.toCondition_period_date((CharSequence)columnName1, calendar1, calendar2));
                sb.append(" OR ");
                sb.append((CharSequence)this.toCondition_period_date((CharSequence)columnName2, calendar1, calendar2));
                sb.append(" OR ");
                sb.append(this.toCondition_between_date(columnName1, columnName2, calendar1, nullable));
                sb.append(" OR ");
                sb.append(this.toCondition_between_date(columnName1, columnName2, calendar2, nullable));
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb;
    }

    public StringBuilder toCondition_period_date(String columnName1, String columnName2, Calendar calendar1, Calendar calendar2) throws Exception {
        return this.toCondition_period_date(columnName1, columnName2, calendar1, calendar2, 1, true);
    }

    public StringBuilder toCondition_period_yyyyMMddHHmm(String columnName1, long dateTime1, long dateTime2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (dateTime1 > 0L) {
            sb.append(String.valueOf(columnName1) + ">=" + dateTime1);
        }
        if (dateTime2 > 0L) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(String.valueOf(columnName1) + "<=" + dateTime2);
        }
        if (sb.length() > 0) {
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb;
    }

    public StringBuilder toCondition_period_yyyyMMddHHmm(CharSequence columnName1, CharSequence columnName2, Long date1, Long date2, int termMode) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (date1 == null && date2 == null) {
            return sb;
        }
        switch (termMode) {
            case 2: {
                sb.append("(");
                sb.append(columnName1 + ">=" + date1 + " AND " + columnName1 + "<=" + date2);
                sb.append(" AND ");
                sb.append(columnName2 + ">=" + date1 + " AND " + columnName2 + "<=" + date2);
                sb.append(")");
                break;
            }
            case 3: {
                sb.append("(");
                sb.append(columnName1 + "<=" + date1 + " AND " + columnName2 + ">=" + date2);
                sb.append(")");
                break;
            }
            default: {
                if (date1 > 0L) {
                    sb.append("(" + columnName1 + "<=" + date1 + " AND (" + columnName2 + ">=" + date1 + " OR " + columnName2 + "=" + 0 + "))");
                    if (date2 > 0L) {
                        sb.append(" OR ");
                        sb.append("(" + columnName1 + ">=" + date1 + " AND " + columnName1 + "<=" + date2 + ")");
                        sb.append(" OR ");
                        sb.append("(" + columnName2 + ">=" + date1 + " AND " + columnName2 + "<=" + date2 + ")");
                        break;
                    }
                    sb.append(" OR ");
                    sb.append("(" + columnName1 + ">=" + date1 + " AND " + columnName2 + "=" + 0 + ")");
                    break;
                }
                if (date2 <= 0L) break;
                sb.append("(" + columnName1 + "<=" + date2 + ")");
                sb.append(" AND ");
                sb.append("(" + columnName2 + "<=" + date2 + " OR " + columnName2 + "=" + 0 + ")");
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb;
    }

    public StringBuilder toCondition_period_yyyyMMdd(CharSequence columnName1, CharSequence columnName2, int date1, int date2, int termMode) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (date1 < 0 && date2 <= 0) {
            return sb;
        }
        switch (termMode) {
            case 2: {
                sb.append("(");
                sb.append(columnName1 + ">=" + date1 + " AND " + columnName1 + "<=" + date2);
                sb.append(" AND ");
                sb.append(columnName2 + ">=" + date1 + " AND " + columnName2 + "<=" + date2);
                sb.append(")");
                break;
            }
            case 3: {
                sb.append("(");
                sb.append(columnName1 + "<=" + date1 + " AND " + columnName2 + ">=" + date2);
                sb.append(")");
                break;
            }
            default: {
                if (date1 > 0) {
                    sb.append("(" + columnName1 + "<=" + date1 + " AND (" + columnName2 + ">=" + date1 + " OR " + columnName2 + "=" + 0 + "))");
                    if (date2 > 0) {
                        sb.append(" OR ");
                        sb.append("(" + columnName1 + ">=" + date1 + " AND " + columnName1 + "<=" + date2 + ")");
                        sb.append(" OR ");
                        sb.append("(" + columnName2 + ">=" + date1 + " AND " + columnName2 + "<=" + date2 + ")");
                        break;
                    }
                    sb.append(" OR ");
                    sb.append("(" + columnName1 + ">=" + date1 + " AND " + columnName2 + "=" + 0 + ")");
                    break;
                }
                if (date2 <= 0) break;
                sb.append("(" + columnName1 + "<=" + date2 + ")");
                sb.append(" AND ");
                sb.append("(" + columnName2 + "<=" + date2 + " OR " + columnName2 + "=" + 0 + ")");
            }
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb;
    }

    public StringBuilder toCondition_period_yyyyMMdd(CharSequence columnName, int date1, int date2) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (date1 <= 0 && date2 <= 0) {
            return sb;
        }
        if (date1 == date2) {
            sb.append(columnName + " = " + date1);
        } else {
            sb.insert(0, "(");
            if (date1 > 0) {
                sb.append(columnName + " >= " + date1);
            }
            if (date2 > 0) {
                if (date1 > 0) {
                    sb.append(" AND ");
                }
                sb.append(columnName + " <= " + date2);
            }
            sb.append(")");
        }
        return sb;
    }

    public StringBuilder periodOverlap_yyyyMMdd(String columnName1, String columnName2, int date1, int date2, boolean isText) throws Exception {
        StringBuilder sb = new StringBuilder();
        String date1wk = null;
        String date2wk = null;
        if (isText) {
            int length = 8;
            date1wk = BcStringUtil.fillPrefix(date1, length, '0');
            date1wk = BcStringUtil.singleQuotation(date1wk).toString();
            date2wk = BcStringUtil.fillPrefix(date2, length, '0');
            date2wk = BcStringUtil.singleQuotation(date2wk).toString();
        } else {
            date1wk = Integer.toString(date1);
            date2wk = Integer.toString(date2);
        }
        if (date1 > 0 && date2 > 0) {
            sb.append("(" + columnName1 + " <= " + date2wk + " AND " + columnName2 + " >= " + date1wk + ")");
        } else if (date1 > 0 && date2 <= 0) {
            sb.append(String.valueOf(columnName1) + " >= " + date1wk);
        } else if (date1 <= 0 && date2 > 0) {
            sb.append(String.valueOf(columnName2) + " <= " + date2wk);
        }
        return sb;
    }

    public StringBuilder periodOverlap_yyyyMMdd(String columnName1, String columnName2, int date1, int date2) throws Exception {
        return this.periodOverlap_yyyyMMdd(columnName1, columnName2, date1, date2, false);
    }

    public StringBuilder periodOverlap_yyyyMMdd_text(String columnName1, String columnName2, int date1, int date2) throws Exception {
        return this.periodOverlap_yyyyMMdd(columnName1, columnName2, date1, date2, true);
    }

    public String toCondition_between_datetime(String columnName1, String columnName2, Calendar calendar, boolean isNullable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (isNullable) {
            sb.append("(");
            sb.append(String.valueOf(columnName1) + " " + this.isNull());
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " >= " + this.toCondition_datetime(calendar));
            sb.append(")");
            sb.append(" OR ");
            sb.append("(");
            sb.append(String.valueOf(columnName1) + " <= " + this.toCondition_datetime(calendar));
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " " + this.isNull());
            sb.append(")");
            sb.append(" OR ");
            sb.append("(");
            sb.append(String.valueOf(columnName1) + " <= " + this.toCondition_datetime(calendar));
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " >= " + this.toCondition_datetime(calendar));
            sb.append(")");
        } else {
            sb.append(String.valueOf(columnName1) + " <= " + this.toCondition_datetime(calendar));
            sb.append(" AND ");
            sb.append(String.valueOf(columnName2) + " >= " + this.toCondition_datetime(calendar));
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb.toString();
    }

    public String toCondition_between_date(String columnName1, String columnName2, Calendar calendar, boolean nullable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (calendar == null) {
            return sb.toString();
        }
        Calendar dateCalendar = (Calendar)calendar.clone();
        BcTimeUtil.initTimeField(dateCalendar);
        return this.toCondition_between_datetime(columnName1, columnName2, dateCalendar, nullable);
    }

    public String toCondition_period_year_month(String yearColumnName, String monthColumnName, int yyyyMMdd1, short HHmm1, int yyyyMMdd2, short HHmm2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("(" + yearColumnName + "*10^4+" + monthColumnName + ") >= " + yyyyMMdd1 * (int)Math.pow(10.0, 4.0) + HHmm1);
        sb.append(" AND ");
        sb.append("(" + yearColumnName + "*10^4+" + monthColumnName + ") <= " + yyyyMMdd2 * (int)Math.pow(10.0, 4.0) + HHmm2);
        sb.append("))");
        return sb.toString();
    }

    public String toCondition_period_year_month(String yearColumnName, String monthColumnName, int year1, int month1, int year2, int month2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("((");
        sb.append(String.valueOf(yearColumnName) + "=" + year1 + " AND " + monthColumnName + ">=" + month1 + " OR " + yearColumnName + ">" + year1);
        sb.append(") AND (");
        sb.append(String.valueOf(yearColumnName) + "=" + year2 + " AND " + monthColumnName + "<=" + month2 + " OR " + yearColumnName + "<" + year2);
        sb.append("))");
        return sb.toString();
    }

    public String toCondition_boolean(String columnName, boolean bool) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(columnName);
        sb.append(" = ");
        sb.append(Boolean.toString(bool));
        return sb.toString();
    }

    public String toPatternMatch(boolean isEquals, String pattern) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!isEquals) {
            sb.append(" NOT");
        }
        sb.append(" LIKE ");
        sb.append(BcStringUtil.singleQuotation(pattern));
        return sb.toString();
    }

    public String toPatternMatch(String pattern) throws Exception {
        return this.toPatternMatch(true, pattern);
    }

    public String toPatternMatch(SqlConstants.PatternMatch patternMatch, String pattern) throws Exception {
        if (SqlConstants.PatternMatch.partialMatch == patternMatch) {
            return this.toPatternMatch(String.valueOf(BcStringUtil.PERCENT_STR) + pattern + BcStringUtil.PERCENT_STR).toString();
        }
        if (SqlConstants.PatternMatch.forwardMatch == patternMatch) {
            return this.toPatternMatch(String.valueOf(BcStringUtil.PERCENT_STR) + pattern).toString();
        }
        if (SqlConstants.PatternMatch.backwardMatch == patternMatch) {
            return this.toPatternMatch(String.valueOf(pattern) + BcStringUtil.PERCENT_STR).toString();
        }
        throw new IllegalArgumentException("patternMatch=" + (Object)((Object)patternMatch));
    }

    public String escapeForPatternMatch(String pattern) throws Exception {
        StringBuilder sb = new StringBuilder(pattern);
        return sb.toString();
    }

    public String toKeyword(String keyword) throws Exception {
        return this.toPatternMatch(String.valueOf(BcStringUtil.PERCENT_STR) + keyword + BcStringUtil.PERCENT_STR);
    }

    public String toKeywordTop(String columnName, List<Object> keywordList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < keywordList.size()) {
            if (i > 0) {
                sb.append(" OR ");
            }
            Object keyStr = keywordList.get(i);
            sb.append(String.valueOf(columnName) + this.toPatternMatch(String.valueOf(keyStr.toString()) + BcStringUtil.PERCENT_STR));
            ++i;
        }
        return sb.toString();
    }

    public String toKeywordTop(String columnName, Object keyword) throws Exception {
        ArrayList<Object> keywordList = new ArrayList<Object>();
        keywordList.add(keyword);
        return this.toKeywordTop(columnName, keywordList);
    }

    public String toCondition_differentValue(String columnName1, String columnName2) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("(" + columnName1 + " <> " + columnName2 + ")");
        sb.append(" OR ");
        sb.append("(" + columnName1 + " Is Not Null AND " + columnName2 + " Is Null)");
        sb.append(" OR ");
        sb.append("(" + columnName1 + " Is Null AND " + columnName2 + " Is Not Null)");
        sb.append(")");
        return sb.toString();
    }

    public int putBinary(SqlConnection sqlCon, String tableName, String columnName, String whereClause, InputStream is, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE " + tableName + " SET " + columnName + "=" + '?');
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(" WHERE " + whereClause);
        }
        try (SqlPreparedStatement ppst = sqlCon.prepareStatement(sb.toString());){
            ppst.setBinaryStream(1, is, length);
            int n = ppst.executeUpdate();
            return n;
        }
    }

    public String decode(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public List<String> toSetList(Collection valueCollection) throws Exception {
        ArrayList<String> setList = new ArrayList<String>();
        for (Object value : valueCollection) {
            setList.add(this.toSet(value));
        }
        return setList;
    }

    public String createColumnNameCsv(MmdModel mmdModel) throws Exception {
        List<String> columnNameList = MmdUtil.toColumnNameList(mmdModel);
        return BcStringUtil.toCsv(columnNameList, true);
    }

    public String toEnumeration(Collection stringCollection) throws Exception {
        return BcStringUtil.marge(stringCollection, BcStringUtil.COMMA_STR);
    }

    public String createInsertSql(String tableName, List columnNameList, List<? extends CharSequence> textValueList, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineSep2 = BcStringUtil.toStringNotNull(lineSep);
        sb.append("INSERT INTO " + tableName);
        sb.append(lineSep2);
        sb.append(" (");
        sb.append(BcStringUtil.marge(columnNameList, ", "));
        sb.append(")");
        sb.append(lineSep2);
        sb.append(" VALUES");
        sb.append(lineSep2);
        sb.append(" (");
        sb.append(BcStringUtil.marge(textValueList, ", "));
        sb.append(")");
        return sb.toString();
    }

    public List<String> createValueListForPrepareStatement(Collection<SqlSetClause> setClauseCollection, boolean withNumber) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        int index = 0;
        for (SqlSetClause setClause : setClauseCollection) {
            ++index;
            if (BcStringUtil.isEmpty(setClause.function)) {
                StringBuilder sb = new StringBuilder();
                sb.append('?');
                if (withNumber) {
                    sb.append(Integer.toString(index));
                }
                valueList.add(sb.toString());
                continue;
            }
            valueList.add(setClause.function.toString());
        }
        return valueList;
    }

    public List<String> createValueListForPrepareStatement(Collection<SqlSetClause> setClauseCollection) throws Exception {
        return this.createValueListForPrepareStatement(setClauseCollection, false);
    }

    public String createInsertSqlForPrepareStatement(MmdModel mmdModel, String lineSep, boolean withNumber) throws Exception {
        List<String> columnNameList = MmdUtil.toColumnNameList(mmdModel);
        ArrayList<SqlSetClause> setClauseList = new ArrayList<SqlSetClause>();
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            SqlSetClause setClause = new SqlSetClause(columnName, null);
            setClauseList.add(setClause);
            ++i;
        }
        List<String> textValueList = this.createValueListForPrepareStatement(setClauseList, withNumber);
        return this.createInsertSql(mmdModel.tableName, columnNameList, textValueList, lineSep);
    }

    public String createInsertSqlForPrepareStatement(MmdModel mmdModel) throws Exception {
        return this.createInsertSqlForPrepareStatement(mmdModel, null, false);
    }

    public String createUpdateSql(String tableName, List columnNameList, List valueList, String whereClause) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE " + tableName + " SET ");
        int i = 0;
        while (i < columnNameList.size()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(columnNameList.get(i) + "=" + this.toSet(valueList.get(i)));
            ++i;
        }
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(whereClause);
        }
        return sb.toString();
    }

    public List<String> toColumnNameList(Collection<SqlSetClause> setClauseCollection) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        for (SqlSetClause setClause : setClauseCollection) {
            columnNameList.add(setClause.columnName);
        }
        return columnNameList;
    }

    public List<String> toTextValueList(Collection<SqlSetClause> setClauseCollection) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        for (SqlSetClause setClause : setClauseCollection) {
            if (BcStringUtil.isEmpty(setClause.function)) {
                valueList.add(this.toSet(setClause.value));
                continue;
            }
            valueList.add(setClause.function.toString());
        }
        return valueList;
    }

    public String buildInsertSql(SqlUpdateSql updateSql, String lineSep) throws Exception {
        List<String> columnNameList = this.toColumnNameList(updateSql.getSetClauseList());
        List<String> textValueList = this.toTextValueList(updateSql.getSetClauseList());
        return this.createInsertSql(updateSql.tableName, columnNameList, textValueList, lineSep);
    }

    public String buildInsertSql(SqlUpdateSql updateSql) throws Exception {
        return this.buildInsertSql(updateSql, BcStringUtil.lineSeparator);
    }

    public String buildInsertSqlForPrepareStatement(SqlUpdateSql updateSql) throws Exception {
        List<String> columnNameList = this.toColumnNameList(updateSql.getSetClauseList());
        List<String> textValueList = this.createValueListForPrepareStatement(updateSql.getSetClauseList());
        return this.createInsertSql(updateSql.tableName, columnNameList, textValueList, BcStringUtil.lineSeparator);
    }

    public String buildUpdateSql(SqlUpdateSql updateSql, String lineSep, boolean isPreparedStatement) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(updateSql.tableName);
        sb.append(lineSep);
        sb.append("  SET");
        sb.append(lineSep);
        int i = 0;
        while (i < updateSql.getSetClauseList().size()) {
            SqlSetClause setClause = updateSql.getSetClauseList().get(i);
            sb.append("    ");
            if (i == 0) {
                sb.append(" ");
            } else {
                sb.append(",");
            }
            sb.append(setClause.columnName);
            sb.append(" = ");
            if (BcStringUtil.isEmpty(setClause.function)) {
                if (isPreparedStatement) {
                    sb.append("?");
                } else {
                    sb.append(this.toSet(setClause.value));
                }
            } else {
                sb.append(setClause.function);
            }
            sb.append(lineSep);
            ++i;
        }
        String whereClause = this.buildWhereClause(updateSql.getWhereElementList(), lineSep);
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(" WHERE " + whereClause);
        }
        sb.append(lineSep);
        return sb.toString();
    }

    public String buildUpdateSql(SqlUpdateSql updateSql, boolean isPreparedStatement) throws Exception {
        return this.buildUpdateSql(updateSql, BcStringUtil.lineSeparator, isPreparedStatement);
    }

    public String buildUpdateSql(SqlUpdateSql updateSql) throws Exception {
        return this.buildUpdateSql(updateSql, BcStringUtil.lineSeparator, false);
    }

    public String buildUpdateSqlForPrepareStatement(SqlUpdateSql updateSql) throws Exception {
        return this.buildUpdateSql(updateSql, BcStringUtil.lineSeparator, true);
    }

    public String buildDeleteSql(SqlUpdateSql updateSql, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(updateSql.tableName);
        String whereClause = this.buildWhereClause(updateSql.getWhereElementList(), lineSep);
        if (!BcStringUtil.isEmpty(whereClause)) {
            sb.append(lineSep);
            sb.append(" WHERE " + whereClause);
        }
        sb.append(lineSep);
        return sb.toString();
    }

    public String buildDeleteSql(SqlUpdateSql updateSql) throws Exception {
        return this.buildDeleteSql(updateSql, BcStringUtil.lineSeparator);
    }

    public String buildSelectSql(SqlSelectSql selectSql, String lineSep) throws Exception {
        String whereClause;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(lineSep);
        sb.append(this.indent);
        sb.append(BcStringUtil.marge(selectSql.getSelectColumnList(), String.valueOf(lineSep) + this.indent + ", "));
        sb.append(lineSep);
        sb.append("FROM ");
        sb.append(selectSql.getFromClause());
        if (!BcCollectionUtil.isEmpty(selectSql.getWhereElementList()) && !BcStringUtil.isEmpty(whereClause = this.buildWhereClause(selectSql.getWhereElementList(), lineSep))) {
            sb.append(lineSep);
            sb.append("WHERE ");
            sb.append(whereClause);
        }
        if (!BcCollectionUtil.isEmpty(selectSql.getGroupByColumnList())) {
            sb.append(lineSep);
            sb.append("GROUP BY ");
            sb.append(BcStringUtil.marge(selectSql.getGroupByColumnList(), ", "));
        }
        if (!BcCollectionUtil.isEmpty(selectSql.getGroupByColumnList())) {
            sb.append(lineSep);
            String havingClause = this.buildWhereClause(selectSql.havingElementList, lineSep);
            if (!BcStringUtil.isEmpty(havingClause)) {
                sb.append("HAVING ");
                sb.append(havingClause);
            }
        }
        if (!BcCollectionUtil.isEmpty(selectSql.getOrderByList())) {
            sb.append(lineSep);
            sb.append(this.buildOrderBy(selectSql.getOrderByList(), lineSep));
        }
        if (selectSql.rowLimit > 0) {
            sb.append(lineSep);
            String newSql = this.setLimit(sb.toString(), selectSql.rowLimit, selectSql.rowOffset);
            BcStringUtil.clear(sb);
            sb.append(newSql);
        }
        if (selectSql.isForUpdate) {
            sb.append(lineSep);
            sb.append("FOR UPDATE");
        }
        return sb.toString();
    }

    public String buildSelectSql(SqlSelectSql selectSql) throws Exception {
        return this.buildSelectSql(selectSql, BcStringUtil.lineSeparator);
    }

    public String createSelectSql(MmdModel mmdModel) throws Exception {
        String columnNameCsv = this.createColumnNameCsv(mmdModel);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT " + columnNameCsv + " FROM " + mmdModel.tableName);
        return sb.toString();
    }

    public String buildOrderBy(List<String> orderByList, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (BcCollectionUtil.isEmpty(orderByList)) {
            return sb.toString();
        }
        sb.append(lineSep);
        sb.append(" ORDER BY ");
        sb.append(BcStringUtil.marge(orderByList, String.valueOf(lineSep) + this.indent + ", "));
        return sb.toString();
    }

    public long getRowCount(SqlConnection sqlCon, String tableName) throws Exception {
        String sql = "SELECT COUNT(*) FROM " + tableName;
        long cnt = 0L;
        try (SqlStatement stmt = sqlCon.createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                cnt = rs.getLong(1);
            }
            rs.close();
        }
        return cnt;
    }

    public boolean isSelectForUpdateEnabled() throws Exception {
        return true;
    }

    public boolean inputStreamAvailableEnabled() throws Exception {
        return true;
    }

    public Object beginTransaction(SqlConnection sqlConnection) throws Exception {
        Object res = SqlUtil.execute(sqlConnection, "BEGIN");
        return res;
    }

    public Object prepareTransaction(SqlConnection sqlCon, String transactionId) throws Exception {
        String sql = "PREPARE TRANSACTION '" + transactionId + "'";
        Object res = SqlUtil.execute(sqlCon, sql);
        return res;
    }

    public Object commitPrepared(SqlConnection sqlCon, String transactionId) throws Exception {
        String sql = "COMMIT PREPARED '" + transactionId + "'";
        Object res = SqlUtil.execute(sqlCon, sql);
        return res;
    }

    public Object rollbackPrepared(SqlConnection sqlCon, String transactionId) throws Exception {
        String sql = "ROLLBACK PREPARED '" + transactionId + "'";
        Object res = SqlUtil.execute(sqlCon, sql);
        return res;
    }

    public List<String> createTabelColumnNameList(SqlConnection sqlCon, String tableName, String asName) throws Exception {
        ArrayList<String> tabelColumnNameList = new ArrayList<String>();
        try (ResultSet rs = sqlCon.getMetaData().getColumns(null, null, tableName, null);){
            while (rs.next()) {
                if (BcStringUtil.isEmpty(asName)) {
                    tabelColumnNameList.add(String.valueOf(tableName) + "." + rs.getString("COLUMN_NAME"));
                    continue;
                }
                tabelColumnNameList.add(String.valueOf(asName) + "." + rs.getString("COLUMN_NAME"));
            }
        }
        return tabelColumnNameList;
    }

    public List<String> createSelectColumnList(SqlConnection sqlCon, String sql) throws Exception {
        int pos2;
        int pos1;
        String sql2 = sql.toString().toLowerCase();
        String columns = sql2.substring((pos1 = sql2.indexOf("select")) + 6, pos2 = sql2.indexOf("from")).trim();
        List<String> columnNameList = BcStringUtil.stringTokenize((CharSequence)columns, ",", false, true);
        if (columnNameList.size() == 1 && columnNameList.get(0).equals("*")) {
            int sql5;
            String sql3 = sql2.toString().substring(pos2 + 4).trim();
            int pos3 = sql3.indexOf(32);
            String tableName = sql3.substring(0, pos3);
            String asName = null;
            String sql4 = sql2.toString().substring(pos3);
            int pos4 = sql4.indexOf(" as ");
            if (pos4 >= 0 && (sql5 = (asName = sql4.substring(pos4 + 4).trim()).indexOf(32)) >= 0) {
                asName = asName.substring(0, sql5);
            }
            columnNameList = this.createTabelColumnNameList(sqlCon, tableName, asName);
        }
        return columnNameList;
    }

    public String toCommaEnumeration(boolean isNumber, Object array) throws Exception {
        int length = Array.getLength(array);
        ArrayList<String> strList = new ArrayList<String>();
        int i = 0;
        while (i < length) {
            Object value = Array.get(array, i);
            String str = null;
            if (value != null) {
                String encoded = this.escapEncode(value.toString());
                str = isNumber ? encoded : BcStringUtil.singleQuotation(encoded).toString();
            } else {
                str = "NULL";
            }
            strList.add(str);
            ++i;
        }
        return BcStringUtil.toCsv(strList, true);
    }

    public String numberToCommaEnumeration(Object array) throws Exception {
        return this.toCommaEnumeration(true, array);
    }

    public String stringToCommaEnumeration(String ... array) throws Exception {
        return this.toCommaEnumeration(false, array);
    }

    public StringBuilder coalesce(String ... values) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("coalesce(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(values[i]);
            ++i;
        }
        sb.append(")");
        return sb;
    }

    public StringBuilder margeColumn(String sep, String ... columnNames) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < columnNames.length) {
            if (i > 0) {
                sb.append(" || ");
                if (!BcStringUtil.isEmpty(sep)) {
                    sb.append(" || ");
                    sb.append(sep);
                }
            }
            sb.append((CharSequence)this.coalesce(columnNames[i], "''"));
            ++i;
        }
        return sb;
    }

    public String yyyyMMddToTimestamp(String columnName) throws Exception {
        String tmp = "TO_CHAR(" + columnName + ", '99999999')";
        return "TO_TIMESTAMP(" + tmp + ", 'YYYYMMDD')";
    }

    public String yyyyMMddToCahrYYYYMM(String columnName) throws Exception {
        String tmp = this.yyyyMMddToTimestamp(columnName);
        return "TO_CHAR(" + tmp + ", 'YYYYMM')";
    }

    public String yyyyMMddToDate(String columnName) throws Exception {
        String tmp = "TO_CHAR(" + columnName + ", '99999999')";
        return "TO_DATE(" + tmp + ", 'YYYYMMDD')";
    }

    public String yyyyMMddAddMonth(String columnName, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.yyyyMMddToTimestamp(columnName));
        sb.append(" + '" + month + " months'");
        return sb.toString();
    }

    public String timestampToEndOfMonth(String columnName) throws Exception {
        return "DATE_TRUNC('month', " + columnName + " + '1 months') + '-1 days'";
    }

    public String getWildCard() throws Exception {
        return BcStringUtil.PERCENT_STR;
    }

    public String toLineComment(CharSequence comment) {
        return "-- " + BcStringUtil.toStringNotNull(comment);
    }

    public String toInlineComment(String comment) {
        return "/* " + BcStringUtil.toStringNotNull(comment) + " */";
    }

    public boolean isScrollSupport() throws Exception {
        return true;
    }

    public MmdModel convertReservedWord(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        return mmdModel2;
    }

    public String convertSql(String sql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        return sql;
    }

    public boolean isSelectSql(String sql) throws Exception {
        return sql.trim().toUpperCase().startsWith("SELECT ");
    }

    public boolean isUpdateSql(String sql) throws Exception {
        return sql.trim().toUpperCase().startsWith("UPDATE ");
    }

    public boolean isInsertSql(String sql) throws Exception {
        return sql.trim().toUpperCase().startsWith("INSERT ");
    }

    public String getString(SqlConnection sqlCon, String tableName, String columnName, String wherePhrase, String defaultVal) throws Exception {
        String resStr = defaultVal;
        String query = "SELECT " + columnName + " FROM " + tableName + " WHERE " + wherePhrase;
        try (SqlStatement stmt = sqlCon.createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                resStr = rs.getString(1);
            }
            rs.close();
        }
        return resStr;
    }

    public int getIndex(List<String> columnNameList, String columnName1) {
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName2 = columnNameList.get(i);
            if (BcStringUtil.equalsIgnoreCase(columnName1, columnName2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void copyRow(ResultSet rs1, int colmunIndex1, SqlContext sqlContext2, PreparedStatement ppst2, int colmunIndex2, BcLogger logger) throws Exception {
        ResultSetMetaData rsmd1 = rs1.getMetaData();
        int sqlType1 = rsmd1.getColumnType(colmunIndex1);
        switch (sqlType1) {
            case -1: {
                InputStream io1 = rs1.getBinaryStream(colmunIndex1);
                InputStreamReader inputStreamReader = new InputStreamReader(io1, this.getEncoding());
                sqlContext2.set_LONGVARCHAR(ppst2, colmunIndex2, inputStreamReader);
                break;
            }
            case -4: {
                InputStream io1 = rs1.getBinaryStream(colmunIndex1);
                sqlContext2.set_LONGVARBINARY(ppst2, colmunIndex2, io1);
                break;
            }
            case 2004: {
                sqlContext2.set_BLOB(ppst2, colmunIndex2, rs1.getBlob(colmunIndex1));
                break;
            }
            default: {
                Object value = rs1.getObject(colmunIndex1);
                int sqlType2 = sqlContext2.convSqlType(sqlType1);
                sqlContext2.setPreStmtValue(ppst2, colmunIndex2, value, sqlType2);
            }
        }
    }

    public SqlResultSet convToSqlResultSet(ResultSet rs) throws SQLException {
        return new SqlResultSet(rs, this);
    }

    public Object objectConvert(Object srcObj, Class toClass) throws Exception {
        Object newObject = BcObjectConvertor.objectConvert(srcObj, toClass);
        return newObject;
    }

    public boolean existTable(SqlConnection sqlCon, String objectName) throws Exception {
        boolean exist = false;
        try (ResultSet rs = sqlCon.getMetaData().getTables(sqlCon.getCatalog(), sqlCon.getSchema(), null, null);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(objectName)) continue;
                exist = true;
                break;
            }
        }
        return exist;
    }

    public boolean existColumn(SqlConnection sqlCon, CharSequence tableName, CharSequence columnName) throws Exception {
        boolean resValue = false;
        try (ResultSet rs = sqlCon.getMetaData().getColumns(sqlCon.getCatalog(), sqlCon.getSchema(), tableName.toString(), columnName.toString());){
            if (rs.next()) {
                resValue = true;
            }
        }
        return resValue;
    }

    public int copyColumn(SqlConnection sqlCon, String tableName, String columnName1, String columnName2) throws Exception {
        String sql = "UPDATE " + tableName + " SET " + columnName2 + "=" + columnName1;
        int cnt = 0;
        try (SqlStatement stmt = sqlCon.createStatement();){
            cnt = stmt.executeUpdate(sql);
        }
        return cnt;
    }

    public int remakeColumn(SqlConnection sqlCon, String tableName, String columnName1, String columnName2, String dataType) throws Exception {
        String tmpColumnName = "temp_field";
        if (BcStringUtil.isEmpty(columnName2)) {
            columnName2 = columnName1;
        }
        this.addColumn(sqlCon, tableName, tmpColumnName, dataType);
        this.copyColumn(sqlCon, tableName, columnName1, tmpColumnName);
        this.dropColumn(sqlCon, tableName, columnName1);
        this.addColumn(sqlCon, tableName, columnName2, dataType);
        int cnt = this.copyColumn(sqlCon, tableName, tmpColumnName, columnName2);
        this.dropColumn(sqlCon, tableName, tmpColumnName);
        return cnt;
    }

    public int remakeColumn(SqlConnection sqlCon, String tableName, String columnName1, String dataType) throws Exception {
        return this.remakeColumn(sqlCon, tableName, columnName1, null, dataType);
    }

    public static enum RegexFrag {
        i,
        c,
        n,
        m;

    }
}

