/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdUtil;
import ext.base.mmd.MmdValueConverter;
import ext.base.reflect.BcReflectUtil;
import ext.base.runtime.BcClassLoader;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableModel;
import ext.lib.sql.InnerStatementVisitor;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.model.SqlSelectSql;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class SqlUtil {
    public static Map<String, MmdValueConverter> valueConverterMap = new HashMap<String, MmdValueConverter>();
    static final int MODE_1 = 1;
    static final int MODE_sentence = 2;
    static final int MODE_literal = 3;

    private SqlUtil() {
    }

    public static Driver createDriver(String className, ClassLoader classLoader) throws Exception {
        Class<?> clazz = BcLangUtil.forName(className, true, classLoader);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        Driver driver = (Driver)clazz.newInstance();
        return driver;
    }

    public static Driver createDriver(String className) throws Exception {
        return SqlUtil.createDriver(className, SqlUtil.class.getClassLoader());
    }

    public static Driver createDriver(File jarFil, String className) throws Exception {
        BcFileUtil.notEexistsException(jarFil);
        URL url = jarFil.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader classLoader = new URLClassLoader(urls, (ClassLoader)new BcClassLoader());
        Driver driver = SqlUtil.createDriver(className, classLoader);
        return driver;
    }

    public static Connection connect(Driver driver, String url, Properties dtsProps) throws Exception {
        Connection con = driver.connect(url, dtsProps);
        return con;
    }

    public static Connection connect(String driverClassName, String url, Properties dtsProps, ClassLoader classLoader) throws Exception {
        Driver driver = SqlUtil.createDriver(driverClassName, classLoader);
        return SqlUtil.connect(driver, url, dtsProps);
    }

    public static Connection connect(String driverClassName, String url, Properties dtsProps) throws Exception {
        return SqlUtil.connect(driverClassName, url, dtsProps, SqlUtil.class.getClassLoader());
    }

    public static int executeUpdate(SqlConnection sqlConnection, String sql, BcLogger logger) throws Exception {
        int updateCount = 0;
        Throwable throwable = null;
        Object var5_7 = null;
        try (SqlStatement stmt = sqlConnection.createStatement();){
            updateCount = stmt.executeUpdate(sql);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return updateCount;
    }

    public static int executeUpdate(SqlConnection sqlConnection, String sql) throws Exception {
        return SqlUtil.executeUpdate(sqlConnection, sql, BcLogUtil.getDefaultLogger());
    }

    public static Object execute(SqlConnection sqlConnection, String sql) throws Exception {
        Object respons = false;
        Throwable throwable = null;
        Object var4_6 = null;
        try (SqlStatement stmt = sqlConnection.createStatement();){
            respons = stmt.execute(sql) ? stmt.getResultSet() : Integer.valueOf(stmt.getUpdateCount());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return respons;
    }

    public static int countRecord(SqlConnection sqlConnection, String sql) throws Exception {
        int cnt = 0;
        Throwable throwable = null;
        Object var4_6 = null;
        try (SqlStatement stmt = sqlConnection.createStatement();){
            Throwable throwable2 = null;
            Object var7_12 = null;
            try (SqlResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    ++cnt;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return cnt;
    }

    public static boolean isNumber(int sqlTypeId) throws Exception {
        boolean bool = false;
        switch (sqlTypeId) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bool = true;
                break;
            }
        }
        return bool;
    }

    public static boolean isText(int sqlTypeId) throws Exception {
        boolean bool = false;
        switch (sqlTypeId) {
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                bool = true;
                break;
            }
        }
        return bool;
    }

    public static String extractTableName(CharSequence tableColumnName) {
        ArrayList<String> strArray = new ArrayList<String>();
        BcStringUtil.stringTokenize(tableColumnName, BcStringUtil.DOT_STR, false, false, strArray);
        if (strArray.size() >= 2) {
            String tmpStr = (String)strArray.get(strArray.size() - 2);
            return BcStringUtil.trim(tmpStr);
        }
        return null;
    }

    public static String extractColumnName(CharSequence tableColumnName) {
        ArrayList<String> strArray = new ArrayList<String>();
        BcStringUtil.stringTokenize(tableColumnName, BcStringUtil.DOT_STR, false, false, strArray);
        if (strArray.size() >= 2) {
            String tmpStr = (String)strArray.get(strArray.size() - 1);
            return BcStringUtil.trim(tmpStr);
        }
        return null;
    }

    public static String extractTableColumnName(CharSequence src) {
        ArrayList<String> strArray = new ArrayList<String>();
        BcStringUtil.stringTokenize(src, BcStringUtil.DOT_STR, false, false, strArray);
        if (strArray.size() >= 2) {
            String tableName = (String)strArray.get(strArray.size() - 2);
            String columnName = (String)strArray.get(strArray.size() - 1);
            return MmdUtil.createTableColumnName(tableName, columnName);
        }
        return null;
    }

    public static String enumerateByCommma(List columnNameList) {
        return BcStringUtil.marge(columnNameList, BcStringUtil.COMMA_STR);
    }

    public static String enumerateByCommma(String[] columnNames) throws Exception {
        return SqlUtil.enumerateByCommma(Arrays.asList(columnNames));
    }

    public static List createGroupByColumnList(List<String> selectColumnList, List<String> nonGroupByColumnList) {
        ArrayList<String> groupByColumnList = new ArrayList<String>();
        boolean bool = false;
        int i = 0;
        while (i < selectColumnList.size()) {
            String columnName = selectColumnList.get(i);
            bool = true;
            int j = 0;
            while (j < nonGroupByColumnList.size()) {
                String disableColumnName = nonGroupByColumnList.get(j);
                if (columnName.equals(disableColumnName)) {
                    bool = false;
                }
                ++j;
            }
            if (bool) {
                groupByColumnList.add(columnName);
            }
            ++i;
        }
        return groupByColumnList;
    }

    public static void margeSetElement(StringBuilder sb, String src) {
        if (sb.length() > 0) {
            sb.append(BcStringUtil.COMMA_STR);
        }
        sb.append(src);
    }

    public static String extractAlias(String src) {
        String alias = null;
        int idx = src.toUpperCase().lastIndexOf(" AS ");
        if (idx >= 0) {
            alias = src.substring(idx + " AS ".length()).trim();
        }
        return alias;
    }

    public static String choiceAlias(String src) {
        String alias = SqlUtil.extractAlias(src);
        if (BcStringUtil.isEmpty(alias)) {
            return src;
        }
        return alias;
    }

    public static String extractColumnName2(String src) {
        int idx = src.toUpperCase().lastIndexOf(" AS ");
        if (idx >= 0) {
            return src.substring(0, idx).trim();
        }
        return src;
    }

    public static Object getValue(ResultSet rs, int columnlIndex, MmdField mmdField) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        Object value = rs.getObject(columnlIndex);
        MmdValueConverter valueConverter = null;
        if (mmdField != null && !BcStringUtil.isEmpty(mmdField.datasourceConverterClassName) && (valueConverter = valueConverterMap.get(mmdField.tableColumnName)) == null) {
            Class<?> clazz = Class.forName(mmdField.datasourceConverterClassName);
            if (MmdValueConverter.class.isAssignableFrom(clazz)) {
                valueConverter = (MmdValueConverter)BcReflectUtil.getInstance(clazz);
                valueConverterMap.put(mmdField.tableColumnName, valueConverter);
            } else {
                String msg = "Not suppoted class. '" + mmdField.datasourceConverterClassName + "'";
                throw new Exception(msg);
            }
        }
        if (valueConverter != null) {
            value = valueConverter.convertValue(mmdField, value);
        }
        return value;
    }

    public static Object getValue(ResultSet rs, int columnlIndex, BcTableColumn tableColumn) throws Exception {
        MmdField mmdField = tableColumn.getMmdField();
        return SqlUtil.getValue(rs, columnlIndex, mmdField);
    }

    public static List<Object> getValueList(ResultSet rs, List<? extends BcTableColumn> tableColumnList) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>(tableColumnList.size());
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            Object value = SqlUtil.getValue(rs, i + 1, tableColumn);
            valueList.add(value);
            ++i;
        }
        return valueList;
    }

    public static int getValueList(ResultSet rs, int columnIndex, List valueList) throws Exception {
        int cnt = 0;
        while (rs.next()) {
            Object value = rs.getObject(columnIndex);
            valueList.add(value);
            ++cnt;
        }
        return cnt;
    }

    public static List getValueList(ResultSet rs, int columnIndex) throws Exception {
        ArrayList valueList = new ArrayList();
        SqlUtil.getValueList(rs, columnIndex, valueList);
        return valueList;
    }

    public static BcTableModel getAsTable(ResultSet rs, List<? extends BcTableColumn> tableColumnList) throws Exception {
        BcTableModel tableModel = new BcTableModel();
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            tableModel.addColumn(tableColumn);
            ++i;
        }
        while (rs.next()) {
            List<Object> row = SqlUtil.getValueList(rs, tableColumnList);
            tableModel.addRow(row);
        }
        return tableModel;
    }

    public static String escapEncode(CharSequence argStr) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (argStr == null) {
            return sb.toString();
        }
        int i = 0;
        while (i < argStr.length()) {
            char aChar = argStr.charAt(i);
            switch (aChar) {
                case '\'': 
                case '\\': {
                    sb.append(aChar);
                    sb.append(aChar);
                    break;
                }
                default: {
                    sb.append(aChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toSet(Object value, int sqlTypeId) throws Exception {
        if (value == null) {
            return "NULL";
        }
        switch (sqlTypeId) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (BcStringUtil.isEmpty(value.toString())) {
                    return "NULL";
                }
                return value.toString();
            }
            case -1: 
            case 1: 
            case 12: {
                return BcStringUtil.singleQuotation(value.toString()).toString();
            }
            case 91: 
            case 92: 
            case 93: {
                if (BcStringUtil.isEmpty(value.toString())) {
                    return "NULL";
                }
                return BcStringUtil.singleQuotation(value.toString()).toString();
            }
            case 0: {
                return "NULL";
            }
        }
        throw new Exception("Not suport sqlType=" + sqlTypeId);
    }

    public static String toWhere(String operator, Object value, int sqlTypeId) throws Exception {
        if (value == null) {
            if (operator.equals("=")) {
                return " Is NULL";
            }
            return " Is Not NULL";
        }
        switch (sqlTypeId) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return String.valueOf(operator) + SqlUtil.escapEncode(value.toString());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(operator) + BcStringUtil.singleQuotation(SqlUtil.escapEncode(value.toString()));
            }
            case 91: 
            case 92: 
            case 93: {
                return String.valueOf(operator) + BcStringUtil.singleQuotation(SqlUtil.escapEncode(value.toString()));
            }
            case 0: {
                return " Is NULL";
            }
        }
        throw new Exception("not suport sqlType=" + sqlTypeId);
    }

    public static SqlSelectSql createGroupByQuery(String fromClause, Collection<String> columnNameCollection, boolean ascending, int rowLimit) throws Exception {
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.getSelectColumnList().addAll(columnNameCollection);
        selectSql.getSelectColumnList().add("COUNT(*)");
        selectSql.getGroupByColumnList().addAll(columnNameCollection);
        selectSql.setFromClause(fromClause);
        String orderBy = "COUNT(*)";
        if (!ascending) {
            orderBy = String.valueOf(orderBy) + " DESC";
        }
        selectSql.getOrderByList().add(orderBy);
        selectSql.rowLimit = rowLimit;
        return selectSql;
    }

    public static SqlSelectSql createGroupByQuery(String tableName, String columnName, boolean ascending, int rowLimit) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        columnNameList.add(columnName);
        return SqlUtil.createGroupByQuery(tableName, columnNameList, ascending, rowLimit);
    }

    public static List<String> splitSentence(CharSequence src) throws Exception {
        ArrayList<String> queryList = new ArrayList<String>();
        if (src == null) {
            return queryList;
        }
        StringBuilder sb1 = new StringBuilder();
        int mode = 1;
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            block0 : switch (mode) {
                case 1: {
                    switch (aChar) {
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                    }
                    sb1.append(aChar);
                    mode = 2;
                    break;
                }
                case 2: {
                    switch (aChar) {
                        case ';': {
                            sb1.append(aChar);
                            queryList.add(sb1.toString());
                            sb1.delete(0, sb1.length());
                            mode = 1;
                            break block0;
                        }
                        case '\'': {
                            sb1.append(aChar);
                            mode = 3;
                            break block0;
                        }
                    }
                    sb1.append(aChar);
                    break;
                }
                case 3: {
                    switch (aChar) {
                        case '\'': {
                            sb1.append(aChar);
                            mode = 2;
                            break block0;
                        }
                    }
                    sb1.append(aChar);
                }
            }
            ++i;
        }
        if (sb1.length() > 0) {
            queryList.add(sb1.toString());
        }
        return queryList;
    }

    public static String tableAliasToNotNull(String tableAlias) throws Exception {
        if (BcStringUtil.isEmpty(tableAlias)) {
            return "";
        }
        return String.valueOf(tableAlias) + ".";
    }

    public static String createTableName(String tableName, String alias) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        if (!BcStringUtil.isEmpty(alias)) {
            sb.append(" AS ");
            sb.append(alias);
        }
        return sb.toString();
    }

    public static String createInfo(ResultSetMetaData rsmd) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnCount=" + rsmd.getColumnCount());
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            int columnIndex = i + 1;
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(SqlUtil.createInfo(rsmd, columnIndex));
            ++i;
        }
        return sb.toString();
    }

    public static String createInfo(ResultSetMetaData rsmd, int columnIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("---- columnIndex=" + columnIndex);
        sb.append("\n  TableName=" + rsmd.getTableName(columnIndex));
        sb.append("\n  ColumnName=" + rsmd.getColumnName(columnIndex));
        sb.append("\n  ColumnLabel=" + rsmd.getColumnLabel(columnIndex));
        sb.append("\n  ColumnTypeName=" + rsmd.getColumnTypeName(columnIndex));
        sb.append("\n  ColumnDisplaySize=" + rsmd.getColumnDisplaySize(columnIndex));
        sb.append("\n  Precision=" + rsmd.getPrecision(columnIndex));
        sb.append("\n  Scale=" + rsmd.getScale(columnIndex));
        sb.append("\n  Nullable=" + rsmd.isNullable(columnIndex));
        sb.append("\n  AutoIncrement=" + rsmd.isAutoIncrement(columnIndex));
        sb.append("\n  ColumnClassName=" + rsmd.isNullable(columnIndex));
        sb.append("\n  ColumnClassName=" + rsmd.getColumnClassName(columnIndex));
        sb.append("\n  SchemaName=" + rsmd.getSchemaName(columnIndex));
        sb.append("\n  CatalogName=" + rsmd.getCatalogName(columnIndex));
        return sb.toString();
    }

    public static StringBuilder createExceptionInfo(SQLException ex) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SQL State=" + ex.getSQLState());
        sb.append("SQL Error Code=" + ex.getErrorCode());
        sb.append("SQL Message=" + ex.getLocalizedMessage());
        return sb;
    }

    public static StringBuilder orList(CharSequence columnName, CharSequence str) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        BcStringUtil.stringTokenize(str, BcStringUtil.COMMA_STR, true, true, valueList);
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        while (i < valueList.size()) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(columnName + "=" + (String)valueList.get(i));
            ++i;
        }
        return sb;
    }

    public static List<String> toStatementList(String src) throws Exception {
        ArrayList<String> statementList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(src)) {
            return statementList;
        }
        InnerStatementVisitor statementVisitor = new InnerStatementVisitor(statementList);
        BufferedReader reader = new BufferedReader(new StringReader(src));
        statementVisitor.parse(reader);
        return statementList;
    }
}

