/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcConditionElement;
import ext.base.util.BcGeneralTextFormatter;
import ext.base.util.BcTextFormatter;
import ext.lib.sql.SqlConditionSpliter;
import ext.lib.sql.SqlConditionUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlWhereElement;
import ext.lib.sql.model.SqlWherecClauseSql;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SqlConditionParser
extends BcLoggableObject
implements Serializable {
    private static final long serialVersionUID = 2563955383851281352L;
    protected SqlConditionSpliter conditionSpliter = SqlConditionSpliter.getInstance();
    public String rangeSign = BcStringUtil.HYPHEN_STR;
    public String wildCard = BcStringUtil.QUESTION_STR;

    public static SqlConditionParser getInstance() {
        return SingletonHolder.instance;
    }

    public StringBuilder parseCondition(SqlContext sqlContext, String columnName1, boolean isNumber1, BcTextFormatter complementer1, String columnName2, boolean isNumber2, BcTextFormatter complementer2, String condition) throws Exception {
        if (BcStringUtil.isEmpty(condition)) {
            return null;
        }
        Object signOfInequality = null;
        List<String> conditionList = this.conditionSpliter.split(condition);
        ArrayList<StringBuilder> whereList = new ArrayList<StringBuilder>();
        int i = 0;
        while (i < conditionList.size()) {
            String conditionElement = conditionList.get(i);
            if (!BcStringUtil.isEmpty(conditionElement)) {
                int rangeIndex = conditionElement.indexOf(this.rangeSign);
                if (rangeIndex >= 0) {
                    StringBuilder sb = this.parseRange(sqlContext, columnName2, isNumber2, conditionElement, complementer2);
                    whereList.add(sb);
                } else {
                    StringBuilder sb;
                    int wildCardIndex = conditionElement.indexOf(this.wildCard);
                    if (wildCardIndex >= 0) {
                        sb = this.parseWildCard(sqlContext, columnName1, conditionElement, complementer1);
                        whereList.add(sb);
                    } else {
                        sb = this.parseCondition_L2(sqlContext, columnName1, isNumber1, conditionElement, complementer1);
                        whereList.add(sb);
                    }
                }
            }
            ++i;
        }
        StringBuilder sb2 = new StringBuilder();
        int i2 = 0;
        while (i2 < whereList.size()) {
            StringBuilder sb1 = (StringBuilder)whereList.get(i2);
            if (i2 > 0) {
                sb2.append(" OR ");
            }
            sb2.append((CharSequence)sb1);
            ++i2;
        }
        if (whereList.size() > 1) {
            sb2.insert(0, "(");
            sb2.append(")");
        }
        return sb2;
    }

    public StringBuilder parseCondition(SqlContext sqlContext, String columnName1, String columnName2, boolean isNumber, String condition, BcTextFormatter complementer) throws Exception {
        return this.parseCondition(sqlContext, columnName1, isNumber, complementer, columnName2, isNumber, complementer, condition);
    }

    public StringBuilder parseCondition(SqlContext sqlContext, String columnName1, boolean isNumber, String condition, BcTextFormatter complementer) throws Exception {
        return this.parseCondition(sqlContext, columnName1, columnName1, isNumber, condition, complementer);
    }

    protected StringBuilder parseCondition_L2(SqlContext sqlContext, String columnName, boolean isNumber, String condition, BcTextFormatter complementer) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (complementer != null) {
            condition = complementer.format(condition);
        }
        if (isNumber) {
            sb.append(columnName);
            sb.append("=" + condition);
        } else {
            sb.append((CharSequence)SqlConditionUtil.createKeywordClause(sqlContext, columnName, condition));
        }
        return sb;
    }

    protected StringBuilder parseRange(SqlContext sqlContext, String columnName, boolean isNumber, String condition, BcTextFormatter complementer) throws Exception {
        String from = null;
        String to = null;
        StringTokenizer tokenizer = new StringTokenizer(condition.toString(), this.rangeSign, true);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            if (i > 2) {
                throw new Exception("parseRange error.");
            }
            String token = tokenizer.nextToken();
            if (i == 0) {
                if (!token.equals(this.rangeSign)) {
                    from = token;
                }
            } else if (!token.equals(this.rangeSign)) {
                to = token;
            }
            ++i;
        }
        if (complementer != null) {
            from = complementer.format(from);
            to = complementer.format(to);
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.parseRange_L2(sqlContext, columnName, from, to, isNumber));
        return sb;
    }

    protected StringBuilder parseRange_L2(SqlContext sqlContext, String columnName, String from, String to, boolean isNumber) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (isNumber) {
            sb.append((CharSequence)sqlContext.toCondition_between_number(columnName, from, to));
        } else {
            sb.append((CharSequence)sqlContext.toCondition_between_string(columnName, from, to));
        }
        sb.insert(0, "(");
        sb.append(")");
        return sb;
    }

    protected final StringBuilder parseWildCard(SqlContext sqlContext, String columnName, String condition, BcTextFormatter complementer) throws Exception {
        String element2 = BcStringUtil.replace((CharSequence)condition, this.wildCard, sqlContext.getWildCard()).toString();
        element2 = BcStringUtil.replace((CharSequence)element2, BcStringUtil.UNDER_SCORE_STR, String.valueOf(BcStringUtil.BACKSLASH_STR) + BcStringUtil.UNDER_SCORE_STR).toString();
        StringBuilder sb = new StringBuilder();
        sb.append(columnName);
        sb.append(sqlContext.toPatternMatch(element2));
        return sb;
    }

    public SqlWhereElement parseCondition1(SqlContext sqlContext, String columnName1, String columnName2, String condition, BcTextFormatter complementer, boolean isNumber) throws Exception {
        if (BcStringUtil.isEmpty(condition)) {
            return null;
        }
        StringBuilder sb = this.parseCondition(sqlContext, columnName1, columnName2, isNumber, condition, complementer);
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula(sb);
        return whereElement;
    }

    public SqlWhereElement parseCondition1(SqlContext sqlContext, String columnName1, String condition, BcTextFormatter complementer, boolean isNumber) throws Exception {
        return this.parseCondition1(sqlContext, columnName1, columnName1, condition, complementer, isNumber);
    }

    public void parseCondition(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, String condition, BcTextFormatter complementer, String conditionName, boolean isNumber) throws Exception {
        SqlWhereElement whereElement = this.parseCondition1(sqlContext, columnName1, columnName2, condition, complementer, isNumber);
        if (whereElement != null) {
            wherecClauseSql.addWhereElement(whereElement);
            if (!BcStringUtil.isEmpty(conditionName)) {
                wherecClauseSql.addCondition(new BcConditionElement(BcStringUtil.toStringNotNull(conditionName), BcStringUtil.toStringNotNull(condition)));
            }
        }
    }

    public void parseCondition(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, String condition, BcTextFormatter complementer, String conditionName) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName2, condition, complementer, conditionName, false);
    }

    public void parseCondition(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, String condition, BcTextFormatter complementer) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName2, condition, complementer, null, false);
    }

    public void parseCondition(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition, BcTextFormatter complementer, String conditionName) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName1, condition, complementer, conditionName, false);
    }

    public void parseCondition(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition, BcTextFormatter complementer) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName1, condition, complementer, null, false);
    }

    public void parseCondition(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName1, condition, null, null, false);
    }

    public void parseCondition4Number(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition, String conditionName) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName1, condition, null, conditionName, true);
    }

    public void parseCondition4Number(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition) throws Exception {
        this.parseCondition(wherecClauseSql, sqlContext, columnName1, columnName1, condition, null, null, true);
    }

    public StringBuilder parse4Number(SqlContext sqlContext, String columnName1, String columnName2, String condition) throws Exception {
        return this.parseCondition(sqlContext, columnName1, columnName2, true, condition, null);
    }

    public StringBuilder parse4Number(SqlContext sqlContext, String columnName1, String condition) throws Exception {
        return this.parse4Number(sqlContext, columnName1, columnName1, condition);
    }

    public void parse4String(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, String condition, int length, char complementChar) throws Exception {
        if (BcStringUtil.isEmpty(condition)) {
            return;
        }
        BcGeneralTextFormatter complementer = null;
        if (length > 0) {
            complementer = new BcGeneralTextFormatter(length, complementChar);
        }
        StringBuilder sb = this.parseCondition(sqlContext, columnName1, columnName2, false, condition, (BcTextFormatter)complementer);
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula(sb);
        wherecClauseSql.addWhereElement(whereElement);
    }

    public void parse4String(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, String condition) throws Exception {
        this.parse4String(wherecClauseSql, sqlContext, columnName1, columnName2, condition, -1, '0');
    }

    public void parse4String(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition) throws Exception {
        this.parse4String(wherecClauseSql, sqlContext, columnName1, columnName1, condition);
    }

    public void parse4StringFillZero(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, String condition, int length) throws Exception {
        this.parse4String(wherecClauseSql, sqlContext, columnName1, columnName2, condition, length, '0');
    }

    public void parse4StringFillZero(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition, int length) throws Exception {
        this.parse4StringFillZero(wherecClauseSql, sqlContext, columnName1, columnName1, condition, length);
    }

    public void parse4StringSimple(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String condition, String conditionName) throws Exception {
        if (BcStringUtil.isEmpty(condition)) {
            return;
        }
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula(String.valueOf(columnName1) + sqlContext.toCondition_string("=", condition));
        wherecClauseSql.addWhereElement(whereElement);
        if (!BcStringUtil.isEmpty(conditionName)) {
            wherecClauseSql.addCondition(new BcConditionElement(BcStringUtil.toStringNotNull(conditionName), BcStringUtil.toStringNotNull(condition)));
        }
    }

    public void period_yyyyMMdd(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName, int date1, int date2) throws Exception {
        if (date1 > 0 || date2 > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_yyyyMMdd(columnName, date1, date2));
            wherecClauseSql.addWhereElement(whereElement);
        }
    }

    public void periodOverlap_yyyyMMddd(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName1, String columnName2, int date1, int date2) throws Exception {
        if (date1 > 0 || date2 > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.periodOverlap_yyyyMMdd(columnName1, columnName2, date1, date2));
            wherecClauseSql.addWhereElement(whereElement);
        }
    }

    public void IsExistence(SqlWherecClauseSql wherecClauseSql, SqlContext sqlContext, String columnName, int existenceFlag) throws Exception {
        if (existenceFlag == BcConstants.Existence.TRUE.value) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(sqlContext.func_length(columnName)) + " > 0");
            wherecClauseSql.addWhereElement(whereElement);
        } else if (existenceFlag == BcConstants.Existence.FALSE.value) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("(" + sqlContext.func_length(columnName) + " <= 0 OR " + columnName + " Is Null)");
            wherecClauseSql.addWhereElement(whereElement);
        }
    }

    private static final class SingletonHolder {
        private static final SqlConditionParser instance = new SqlConditionParser();

        private SingletonHolder() {
        }
    }
}

