/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.html.common;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.html.common.HtmlDataElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HtmlDataAttribute
implements Serializable {
    private static final long serialVersionUID = 4818017701864969520L;
    public String name;
    public String value;
    public List<HtmlDataElement> dataElementList;

    public HtmlDataAttribute(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HtmlDataAttribute(String name) {
        this.name = name;
        this.dataElementList = new ArrayList<HtmlDataElement>();
    }

    public String toValueString() {
        if (BcCollectionUtil.isEmpty(this.dataElementList)) {
            return this.value;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < this.dataElementList.size()) {
            HtmlDataElement dataElement = this.dataElementList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(BcStringUtil.singleQuotation(dataElement.getKey()));
            sb.append(":");
            sb.append(BcStringUtil.singleQuotation(dataElement.getValue()));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

