/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.util;

import ext.base.log.BcLogUtil;
import ext.base.util.BcExceptionHandler;
import ext.base.util.BcWarningException;
import ext.base.util.BcWords;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgOptionPane;
import java.awt.Component;
import javafx.scene.Node;
import javafx.stage.Window;

public class FxExceptionHandler
implements BcExceptionHandler {
    @Override
    public void handleException(Throwable \uff54hrowable, Object source) {
        String message = null;
        int messageType = 0;
        String title = BcWords.getInstance().exception;
        if (\uff54hrowable instanceof BcWarningException) {
            BcLogUtil.warning(\uff54hrowable);
            BcWarningException warningException = (BcWarningException)\uff54hrowable;
            message = warningException.getMessage();
            messageType = 2;
            title = BcWords.getInstance().warning;
        } else {
            BcLogUtil.error(\uff54hrowable);
            message = BcLogUtil.convertMessage(\uff54hrowable);
            messageType = 0;
            title = BcWords.getInstance().exception;
        }
        if (source == null) {
            FxOptionPane.showMessageDialog(message, title, messageType);
            return;
        }
        if (source instanceof Node) {
            Node node = (Node)source;
            Window ownerWindow = FxUtil.getWindow(node);
            FxOptionPane.showMessageDialog(ownerWindow, (Object)message, title, messageType);
            return;
        }
        if (source instanceof Component) {
            Component component = (Component)source;
            SwgOptionPane.showMessageDialog(component, message, title, messageType);
            return;
        }
    }
}

