/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.layout;

import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.skin.FxSkinDefault;
import ext.lib.fx.skin.FxSkinUtil;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxUtil;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

class FxTitledPane_3
extends FxBorderPane {
    protected HBox topBorderPane = new HBox();
    protected FxBorderPane contentBasePane = new FxBorderPane();
    double fontSizeDefault = 12.0;
    double topBorderPadding = 2.0;
    private Node titleNode;
    private Node iconNode;

    public FxTitledPane_3() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        this.topBorderPane.setPadding(new Insets(this.topBorderPadding));
        this.topBorderPane.setSpacing(4.0);
        this.setTop((Node)this.topBorderPane);
        Font font = Font.font((String)"Monospaced", (double)this.fontSizeDefault);
        Dimension2D dim = FxUtil.getTextFieldSize(font, 1);
        dim = new Dimension2D(dim.getWidth(), dim.getHeight() + this.topBorderPadding);
        this.topBorderPane.setPrefHeight(dim.getHeight());
        FxSkinDefault fxSkin = FxSkinUtil.getSkin();
        Color borderColor = fxSkin.getTextColor();
        String style = FxCssUtil.css_border(1, 3, borderColor);
        this.contentBasePane.setStyle(style);
        this.setCenter((Node)this.contentBasePane);
        FxCssUtil.setBackgroundColor((Region)this.topBorderPane, Color.YELLOW);
        FxCssUtil.setBackgroundColor((Region)this.contentBasePane, Color.AQUA);
    }

    private void resetChildren() throws Exception {
        FxUtil.resetChildren((Pane)this.topBorderPane, this.iconNode, this.titleNode);
    }

    public void setIconNode(Node iconNode) throws Exception {
        this.iconNode = iconNode;
        this.resetChildren();
    }

    public void setTitleNode(Node titleNode) throws Exception {
        this.titleNode = titleNode;
        this.resetChildren();
    }

    public void setTitle(String title, double fontFSize) throws Exception {
        Text text = new Text();
        text.setTextAlignment(TextAlignment.LEFT);
        text.setLineSpacing(2.0);
        text.setText(title);
        FxSkinDefault fxSkin = FxSkinUtil.getSkin();
        text.setFill((Paint)Color.DARKSLATEBLUE);
        Font font = Font.font((String)FxFontUtil.defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)fontFSize);
        text.setFont(font);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(2.0);
        dropShadow.setOffsetY(2.0);
        dropShadow.setRadius(2.0);
        dropShadow.setColor(Color.GRAY);
        text.setEffect((Effect)dropShadow);
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 1.0, 0.0, 6.0));
        hBox.getChildren().add((Object)text);
        this.setTitleNode((Node)hBox);
    }

    public void setTitle(String title) throws Exception {
        this.setTitle(title, this.fontSizeDefault);
    }

    public Node getContentNode() throws Exception {
        return this.contentBasePane.getCenter();
    }

    public void setContentNode(Node contentNode) throws Exception {
        this.contentBasePane.setCenter(contentNode);
    }
}

