/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource;

import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import javax.transaction.xa.XAException;

public class DtsTwoPhaseCommitHelper
extends BcLoggableObject {
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void beginTransaction(DtsSession ... dtsSessions) throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("2\u76f8\u30b3\u30df\u30c3\u30c8\u7121\u52b9");
            return;
        }
        this.getLogger().debug("beginTransaction:dtsSessions.length=" + dtsSessions.length);
        int i = 0;
        while (i < dtsSessions.length) {
            DtsSession dtsSession = dtsSessions[i];
            this.getLogger().debug("connection=" + dtsSession.getSessionFactory().getName());
            try {
                SqlContext sqlContext = dtsSession.getSqlContext();
                sqlContext.beginTransaction(dtsSession.getConnection());
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    public void prepareTransaction(String transactionId, DtsSession ... dtsSessions) throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("2\u76f8\u30b3\u30df\u30c3\u30c8\u7121\u52b9");
            return;
        }
        this.getLogger().debug("prepareTransaction:TRX=" + transactionId);
        int i = 0;
        while (i < dtsSessions.length) {
            DtsSession dtsSession = dtsSessions[i];
            this.getLogger().debug("connection=" + dtsSession.getSessionFactory().getName());
            try {
                SqlContext sqlContext = dtsSession.getSqlContext();
                sqlContext.prepareTransaction(dtsSession.getConnection(), transactionId);
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    public void commitPrepared(String transactionId, DtsSession ... dtsSessions) throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("2\u76f8\u30b3\u30df\u30c3\u30c8\u7121\u52b9");
            this.commit(dtsSessions);
            return;
        }
        this.getLogger().info("commitPrepared:TRX=" + transactionId);
        int i = 0;
        while (i < dtsSessions.length) {
            DtsSession dtsSession = dtsSessions[i];
            this.getLogger().debug("connection=" + dtsSession.getSessionFactory().getName());
            try {
                try {
                    SqlContext sqlContext = dtsSession.getSqlContext();
                    dtsSession.getConnection().setAutoCommit(true);
                    sqlContext.commitPrepared(dtsSession.getConnection(), transactionId);
                }
                catch (Exception ex) {
                    throw new XAException(ex.getMessage());
                }
            }
            finally {
                dtsSession.getConnection().setAutoCommit(false);
            }
            ++i;
        }
    }

    public void commit(DtsSession ... dtsSessions) throws Exception {
        int i = 0;
        while (i < dtsSessions.length) {
            DtsSession dtsSession = dtsSessions[i];
            try {
                dtsSession.commit();
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    public void rollback(String transactionId, DtsSession ... dtsSessions) throws XAException {
        int i = 0;
        while (i < dtsSessions.length) {
            DtsSession dtsSession = dtsSessions[i];
            try {
                this.getLogger().debug("connection=" + dtsSession.getSessionFactory().getName());
                if (!DtsTwoPhaseCommitHelper.existTransaction(dtsSession, transactionId)) {
                    this.getLogger().debug("rollback:transaction not exist.");
                } else {
                    SqlContext sqlContext = dtsSession.getSqlContext();
                    sqlContext.rollbackPrepared(dtsSession.getConnection(), transactionId);
                }
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    public void repairTransaction(DtsSession ... dtsSessions) throws Exception {
        if (!this.isEnabled()) {
            this.getLogger().info("2\u76f8\u30b3\u30df\u30c3\u30c8\u7121\u52b9");
            return;
        }
        int i = 0;
        while (i < dtsSessions.length) {
            DtsSession dtsSession = dtsSessions[i];
            this.getLogger().debug("connection=" + dtsSession.getSessionFactory().getName());
            try {
                DtsTwoPhaseCommitHelper.repairTransaction_L2(dtsSession);
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    protected static void repairTransaction_L2(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT * FROM pg_prepared_xacts";
        dtsSession.getConnection().setAutoCommit(true);
        SqlStatement stmt = dtsSession.getConnection().createStatement();
        try {
            SqlResultSet rs = stmt.executeQuery(query);
            int gidCnt = 0;
            while (rs.next()) {
                String gid = rs.getString("gid");
                BcLogUtil.debug("repairTransaction_L2:gid=" + gid);
                ++gidCnt;
                sqlContext.commitPrepared(dtsSession.getConnection(), gid);
            }
            if (gidCnt <= 0) {
                BcLogUtil.info("\u4fee\u5fa9\u304c\u5fc5\u8981\u306a\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002(hashCode:" + dtsSession.hashCode() + ")");
            }
            rs.close();
        }
        finally {
            stmt.close();
            dtsSession.getConnection().setAutoCommit(false);
        }
    }

    public static boolean existTransaction(DtsSession dtsSession, String gid) throws Exception {
        String query = "SELECT * FROM pg_prepared_xacts WHERE gid='" + gid + "'";
        boolean exist = false;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                exist = true;
            }
            rs.close();
        }
        return exist;
    }
}

