/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource;

import ext.lib.datasource.AbstractSession;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.context.SqlContext;
import java.util.Locale;

public class DtsSession
extends AbstractSession {
    private DtsSessionFactory sessionFactory;
    private Locale locale;
    private DtsConnectionManager connectionManager;
    private SqlContext sqlContext;
    private SqlConnection dbCon;

    public DtsSession(DtsSessionFactory sessionFactory) {
        this.startTime = System.currentTimeMillis();
        this.sessionFactory = sessionFactory;
    }

    public DtsSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public DtsConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(DtsConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public void setSqlContext(SqlContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    public SqlConnection getConnection() throws Exception {
        if (this.dbCon == null) {
            this.dbCon = this.connectionManager.getConnection();
        }
        this.dbCon.setOwner(this.owner);
        return this.dbCon;
    }

    public void setConnection(SqlConnection dbCon) {
        this.dbCon = dbCon;
    }

    public boolean hasConnection() {
        return this.dbCon != null;
    }

    public void commit() throws Exception {
        if (this.dbCon != null && !this.dbCon.getAutoCommit()) {
            this.dbCon.commit();
        }
    }

    public void rollback() throws Exception {
        if (this.dbCon != null) {
            this.dbCon.rollback();
        }
    }

    public void desturuct() throws Exception {
        if (this.dbCon != null) {
            try {
                this.connectionManager.connectionUsed(this.dbCon);
                this.dbCon = null;
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        this.locale = null;
        this.connectionManager = null;
        this.sqlContext = null;
        if (this.sessionFactory != null) {
            this.sessionFactory.getSessionList().remove(this);
        }
        this.sessionFactory = null;
    }

    @Override
    public void close() {
        try {
            this.desturuct();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }
}

