/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcStringUtil;
import java.math.BigDecimal;

public final class BcSIUnit {
    public static final String UNIT_Y = "Y";
    public static final String UNIT_Z = "Z";
    public static final String UNIT_E = "E";
    public static final String UNIT_P = "P";
    public static final String UNIT_T = "T";
    public static final String UNIT_G = "G";
    public static final String UNIT_M = "M";
    public static final String UNIT_k = "k";
    public static final String UNIT_h = "h";
    public static final String UNIT_da = "da";
    public static final String UNIT_d = "d";
    public static final String UNIT_c = "c";
    public static final String UNIT_m = "m";
    public static final String UNIT_\u03bc = "\u03bc";
    public static final String UNIT_u = "u";
    public static final String UNIT_n = "n";
    public static final String UNIT_p = "p";
    public static final String UNIT_f = "f";
    public static final String UNIT_a = "a";
    public static final String UNIT_z = "z";
    public static final String UNIT_y = "y";
    public static final String[] unitPrefixs = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "\u03bc", "u", "n", "p", "f", "a", "z", "y"};
    public static final int[] multipliers = new int[]{24, 21, 18, 15, 12, 9, 6, 3, 2, 1, -1, -2, -3, -6, -6, -9, -12, -15, -18, -21, -24};

    private BcSIUnit() {
    }

    public static int getMultiplier(CharSequence unitPrefix) throws Exception {
        if (BcStringUtil.isEmpty(unitPrefix)) {
            return 0;
        }
        int i = 0;
        while (i < unitPrefixs.length) {
            if (unitPrefix.equals(unitPrefixs[i])) {
                return multipliers[i];
            }
            ++i;
        }
        throw new Exception("not suppoted unitPrefix '" + unitPrefix + "'.");
    }

    public static BigDecimal convUnitPrefix(BigDecimal bigDecimal, CharSequence unitPrefix1, CharSequence unitPrefix2) throws Exception {
        int multiplier1 = BcSIUnit.getMultiplier(unitPrefix1);
        int multiplier2 = BcSIUnit.getMultiplier(unitPrefix2);
        int gap = multiplier1 - multiplier2;
        return bigDecimal.movePointRight(gap);
    }

    public static BigDecimal convUnitPrefix(Number number, CharSequence unitPrefix1, CharSequence unitPrefix2) throws Exception {
        if (number == null) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(number.toString());
        return BcSIUnit.convUnitPrefix(bigDecimal, unitPrefix1, unitPrefix2);
    }

    public static double weightConvert(double v1, String u1, String u2) throws Exception {
        u1 = BcStringUtil.replace((CharSequence)u1, "t", UNIT_M).toString();
        String u1SiPrefix = BcStringUtil.replace((CharSequence)u1, "g", "").toString();
        int m1 = BcSIUnit.getMultiplier(u1SiPrefix);
        u2 = BcStringUtil.replace((CharSequence)u2, "t", UNIT_M).toString();
        String u2SiPrefix = BcStringUtil.replace((CharSequence)u2, "g", "").toString();
        int m2 = BcSIUnit.getMultiplier(u2SiPrefix);
        double resValue = v1 * Math.pow(10.0, m1 - m2);
        return resValue;
    }
}

