/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.runtime.BcRuntimeUtil;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public final class BcConsoleHelper {
    private PrintStream os = System.out;
    private InputStream is = System.in;
    public String prompt = ">";
    public String lineSeparator = BcStringUtil.LINE_FEED_STR;
    public final String ESC_SCREEN_CLEAR = "\u001b[2J";
    public final String windows_cmd = "cmd";

    public void disp(CharSequence msg) throws Exception {
        this.os.print(msg);
    }

    public String input(CharSequence msg) throws Exception {
        if (!BcStringUtil.isEmpty(msg)) {
            this.disp(msg);
            this.disp(this.lineSeparator);
        }
        this.disp(this.prompt);
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (true) {
            int intValue = this.is.read();
            char aChar = (char)intValue;
            if (intValue == -1) break;
            if (aChar == '\r') continue;
            if (aChar == '\n') break;
            byteList.add((byte)intValue);
        }
        Byte[] byteObjects = byteList.toArray(new Byte[byteList.size()]);
        byte[] bytes = ArrayUtils.toPrimitive(byteObjects);
        String str = new String(bytes, BcConstants.baseCharset);
        return str;
    }

    public void screenClear() throws Exception {
        if (BcRuntimeUtil.getOsType() == 31) {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", "cls");
            processBuilder.inheritIO().start().waitFor();
        } else {
            this.os.println("\u001b[2J");
            this.os.println("\u001b[1;1H");
        }
    }

    public void pause(CharSequence msg) throws Exception {
        this.disp(msg);
        int c = this.is.read();
    }

    public boolean ask_yn(CharSequence msg) throws Exception {
        String input = this.input(msg);
        char aChar = '\u0000';
        if (input.length() == 0) {
            aChar = input.charAt(0);
        }
        boolean bool = false;
        if (aChar == 'y' || aChar == 'Y') {
            bool = true;
        }
        return bool;
    }
}

