/*
 * Decompiled with CFR 0.152.
 */
package ext.base.log;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLog4jHelper;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogger;
import ext.base.log.BcLoggerImpl;
import ext.base.runtime.BcRuntimeUtil;
import ext.base.util.BcThrowableUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;

public final class BcLogUtil {
    public static Map<String, BcLogger> loggerMap = new HashMap<String, BcLogger>();
    static BcLog4jHelper log4jHelper = new BcLog4jHelper();
    public static final String CATEGORY_NAME_default = "";
    static String layout = "%d{yyyy/MM/dd HH:mm:ss.SSS} %-5p %c{1} - %m%n";
    public static BcLogger loggerDefault;

    static {
        BcLoggerImpl loggerTemp = new BcLoggerImpl();
        loggerTemp.setLog4jLogger(log4jHelper.getLogger(CATEGORY_NAME_default));
        loggerDefault = loggerTemp;
        File destDir = new File(BcRuntimeUtil.getUserDir(), "log");
        File destFile = new File(destDir, "init.log");
        try {
            loggerDefault = BcLogUtil.createLogger(CATEGORY_NAME_default, BcLogConstants.LogLevel.ALL, destFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log4jHelper.getLogger(CATEGORY_NAME_default).error(ex);
        }
    }

    private BcLogUtil() {
    }

    public static String convertMessage(Object message) {
        if (message == null) {
            return null;
        }
        String newMessage = null;
        if (Throwable.class.isAssignableFrom(message.getClass())) {
            Throwable throwable = (Throwable)message;
            newMessage = BcThrowableUtil.getStackTrace(throwable);
        } else {
            newMessage = message.toString();
        }
        return newMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BcLogger createLogger(String loggerName, BcLogConstants.LogLevel logLevel, File destFile) throws Exception {
        System.out.println("createLogger:loggerName" + loggerName + " logLevel=" + logLevel.name() + " destFile=" + destFile.getPath());
        Logger log4jLogger = log4jHelper.getLogger(loggerName);
        Level log4JLevel = BcLogUtil.tolog4JLevel(logLevel);
        log4jHelper.setAllLevels(loggerName, log4JLevel);
        log4jHelper.removeAllAppender(log4jLogger.getName());
        log4jHelper.addConsoleAppender(log4jLogger, AppenderName.CONSOLE.name(), layout);
        if (destFile != null) {
            BcFileUtil.writeableCheck(destFile);
            log4jHelper.addFileAppender(log4jLogger, AppenderName.FILE.name(), layout, destFile);
        }
        BcLoggerImpl loggerImpl = null;
        Map<String, BcLogger> map = loggerMap;
        synchronized (map) {
            loggerImpl = (BcLoggerImpl)loggerMap.get(loggerName);
            if (loggerImpl == null) {
                loggerImpl = new BcLoggerImpl();
            }
            loggerImpl.setLog4jLogger(log4jLogger);
            loggerMap.put(loggerName, loggerImpl);
        }
        return loggerImpl;
    }

    public static BcLogger getLogger(String loggerName) {
        BcLogger logger = loggerMap.get(loggerName);
        return logger;
    }

    public static BcLogger getDefaultLogger() {
        return loggerDefault;
    }

    public static void info(Object log) {
        loggerDefault.info(log);
    }

    public static void error(Object log) {
        loggerDefault.error(log);
    }

    public static void warning(Object log) {
        loggerDefault.warning(log);
    }

    public static void debug(Object log) {
        loggerDefault.debug(log);
    }

    public static Level tolog4JLevel(BcLogConstants.LogLevel logLevel) {
        Level log4JLevel = null;
        switch (logLevel) {
            case FATAL: {
                log4JLevel = Level.FATAL;
                break;
            }
            case ERROR: {
                log4JLevel = Level.ERROR;
                break;
            }
            case WARN: {
                log4JLevel = Level.WARN;
                break;
            }
            case INFO: {
                log4JLevel = Level.INFO;
                break;
            }
            case DEBUG: {
                log4JLevel = Level.DEBUG;
                break;
            }
            case TRACE: {
                log4JLevel = Level.TRACE;
                break;
            }
            case ALL: {
                log4JLevel = Level.ALL;
            }
        }
        return log4JLevel;
    }

    public static String createLabel(String title, String charStr, int pre, int totalLength) {
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.fill(charStr, pre));
        sb.append(" ");
        sb.append(title);
        sb.append(" ");
        if (sb.length() < totalLength) {
            sb.append(BcStringUtil.fill(charStr, totalLength - sb.length()));
        }
        return sb.toString();
    }

    public static void info(Object log, BcLogger logger) {
        if (logger != null) {
            logger.info(log);
        }
    }

    public static void error(Object log, BcLogger logger) {
        if (logger != null) {
            logger.error(log);
        }
    }

    public static void warning(Object log, BcLogger logger) {
        if (logger != null) {
            logger.warning(log);
        }
    }

    public static void debug(Object log, BcLogger logger) {
        if (logger != null) {
            logger.debug(log);
        }
    }

    public static enum AppenderName {
        CONSOLE,
        FILE;

    }
}

