/*
 * Decompiled with CFR 0.152.
 */
package ext.appfw.common;

import ext.appfw.common.AfbApplicationContext;
import ext.appfw.common.AfbApplicationEvent;
import ext.appfw.common.AfbApplicationEventHandler;
import ext.appfw.common.AfbApplicationSetupProxy;
import ext.appfw.common.AfbConstants;
import ext.appfw.common.AfbShutdownManager;
import ext.appfw.common.AfbSingleInstanceHelper;
import ext.appfw.common.AfbXmlUtil;
import ext.base.charset.BcUtf8Util;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.runtime.BcRuntimeContext;
import ext.base.runtime.BcRuntimeUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcArgumentUtil;
import ext.base.util.BcCipherUtil;
import ext.base.util.BcLocaleUtil;
import ext.base.xml.BcXmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.w3c.dom.Document;

public class AfbApplication
extends BcLoggableObject
implements Serializable {
    private static final long serialVersionUID = -3388841829444427001L;
    private static BcRuntimeContext runtimeContext = new BcRuntimeContext();
    private String[] mainArgs;
    private int exitCode;
    private BcMonitor monitor = new BcMonitor();
    private File rootDir;
    private File commonDir;
    private String configDirStr;
    private File tempDir;
    private Document bootConfig;
    private Document generalConfigDom;
    private AfbApplicationContext appContext = new AfbApplicationContext();
    private Locale locale;
    private List<String> taskIdList = new ArrayList<String>();
    private Map<String, String> fileAliasMap = new HashMap<String, String>();
    public Class setupClass;
    public List<AfbApplicationEventHandler> applicationEventHandlerList = new ArrayList<AfbApplicationEventHandler>();
    public boolean bootEnabled = true;
    public String lockFileName = ".lock";
    public String logFileName = "general.log";
    private boolean isServer = false;

    static {
        try {
            runtimeContext.setSystemProperties(System.getProperties());
            AfbApplication.runtimeContext.hostAddress = InetAddress.getLocalHost().getHostAddress();
            AfbApplication.runtimeContext.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    private AfbApplication() {
        AfbShutdownManager.getInstance();
        this.setLocale(Locale.getDefault());
    }

    public static AfbApplication getInstance() {
        return SingletonHolder.instance;
    }

    public BcRuntimeContext getRuntimeContext() {
        return runtimeContext;
    }

    public String[] getMainArguments() {
        return this.mainArgs;
    }

    public void setMainArguments(String[] mainArgs) throws Exception {
        this.mainArgs = mainArgs;
        String argValue = BcArgumentUtil.getArgumentValue(mainArgs, "-appRootDir");
        if (BcStringUtil.isEmpty(argValue)) {
            File rootDir1 = null;
            URL jarFileUrl = BcRuntimeUtil.getStartJarUrl();
            if (jarFileUrl == null) {
                rootDir1 = BcRuntimeUtil.getUserDir();
            } else {
                File jarFile = new File(jarFileUrl.toURI());
                rootDir1 = jarFile.getParentFile().getParentFile();
            }
            this.setRootDirectry(rootDir1);
        } else {
            File rootDir1 = new File(argValue);
            this.setRootDirectry(rootDir1);
        }
        this.configDirStr = BcArgumentUtil.getArgumentValue(mainArgs, "-configDir");
        argValue = BcArgumentUtil.getArgumentValue(mainArgs, "-runMode");
        this.appContext.runMode = BcNumberUtil.parseInt(argValue, -1);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public File getRootDirectry() {
        return this.rootDir;
    }

    public void setRootDirectry(File rootDir) throws Exception {
        this.rootDir = rootDir;
        if (this.tempDir == null) {
            this.setTempDir(new File(this.toReal("${ROOT}temp/")));
        }
    }

    public File getParentDirectry() {
        return this.rootDir.getParentFile();
    }

    public File getCommonDirectry() {
        if (this.commonDir == null) {
            this.commonDir = new File(this.getParentDirectry(), "common");
        }
        return this.commonDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) throws Exception {
        this.tempDir = tempDir;
    }

    public AfbApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public String toReal(String vPath) throws Exception {
        StringBuilder sb = BcStringUtil.replace((CharSequence)vPath, "${DATA_DIR}", "${ROOT}data/");
        sb = BcStringUtil.isEmpty(this.configDirStr) ? BcStringUtil.replace((CharSequence)sb, "${CONFIG_DIR}", "${ROOT}config/") : BcStringUtil.replace((CharSequence)sb, "${CONFIG_DIR}", this.configDirStr);
        sb = BcStringUtil.replace((CharSequence)sb, "${TEMP_DIR}", "${ROOT}temp/");
        if (this.getRootDirectry() != null) {
            sb = BcStringUtil.replace((CharSequence)sb, "${ROOT}", BcFileUtil.toDirectoryPath(this.getRootDirectry()));
            sb = BcStringUtil.replace((CharSequence)sb, "${PARENT_DIR}", BcFileUtil.toDirectoryPath(this.getParentDirectry()));
            sb = BcStringUtil.replace((CharSequence)sb, "${COMMON}", BcFileUtil.toDirectoryPath(this.getCommonDirectry()));
            if (this.getTempDir() != null) {
                sb = BcStringUtil.replace((CharSequence)sb, "${ROOT}temp/", BcFileUtil.toDirectoryPath(this.getTempDir()));
            }
        }
        if (this.fileAliasMap != null) {
            Set<Map.Entry<String, String>> entrySet = this.fileAliasMap.entrySet();
            for (Map.Entry<String, String> mapEntry : entrySet) {
                sb = BcStringUtil.replace((CharSequence)sb, mapEntry.getKey(), mapEntry.getValue());
            }
        }
        return sb.toString();
    }

    public Document getBootConfig() {
        return this.bootConfig;
    }

    public Document getGeneralConfig() {
        return this.generalConfigDom;
    }

    public void setGeneralConfig(Document generalConfigDom) throws Exception {
        this.generalConfigDom = generalConfigDom;
    }

    public void updateGeneralConfig(Document generalConfigDom) throws Exception {
        this.generalConfigDom = generalConfigDom;
        String filePath = this.toReal("${ROOT}config/general.xml");
        File file = new File(filePath);
        File tmpFile = File.createTempFile("general", ".tmp", file.getParentFile());
        BcXmlUtil.output(generalConfigDom, tmpFile, true);
        if (file.delete()) {
            tmpFile.renameTo(file);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void addTask(String taskName) {
        this.taskIdList.add(taskName);
    }

    public void addTask(int id) {
        this.addTask(Integer.toString(id));
    }

    public void removeTask(String name) {
        this.taskIdList.remove(name);
    }

    public void removeTask(int id) {
        this.taskIdList.remove(Integer.toString(id));
    }

    public boolean isTask(String name) {
        return this.taskIdList.indexOf(name) >= 0;
    }

    public boolean isTask(int id) {
        return this.isTask(Integer.toString(id));
    }

    public void startCommon() throws Exception {
        File commonLibDir;
        File libDir;
        String logFilePath = String.valueOf(this.toReal("${ROOT}log/")) + this.logFileName;
        File logFile = new File(logFilePath);
        BcLogUtil.createLogger("", BcLogConstants.LogLevel.ALL, logFile);
        File binLibDir = new File(this.toReal("${ROOT}bin/lib/"));
        if (binLibDir.exists()) {
            this.getLogger().info("binLibDir=" + binLibDir.getPath());
            BcRuntimeUtil.addClassPath(this.getClass().getClassLoader(), binLibDir);
        }
        if ((libDir = new File(this.toReal("${ROOT}lib/"))).exists()) {
            this.getLogger().info("libDir=" + libDir.getPath());
            BcRuntimeUtil.addClassPath(this.getClass().getClassLoader(), libDir);
        }
        if ((commonLibDir = new File(this.toReal("${COMMON}lib/"))).exists()) {
            this.getLogger().info("commonLibDir=" + commonLibDir.getPath());
            BcRuntimeUtil.addClassPath(this.getClass().getClassLoader(), commonLibDir);
        }
    }

    public boolean isServer() {
        return this.isServer;
    }

    public int start(String[] mainArgs, boolean doWait, boolean isServer) {
        this.isServer = isServer;
        try {
            this.start_L2(mainArgs, doWait);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            this.setExitCode(AfbConstants.ExitCode.NG.code);
        }
        return this.getExitCode();
    }

    protected void start_L2(String[] mainArgs, boolean doWait) throws Exception {
        File bootConfigDir;
        this.setExitCode(AfbConstants.ExitCode.OK.code);
        this.setMainArguments(mainArgs);
        File lockFile = new File(this.getRootDirectry(), this.lockFileName);
        FileLock fileLock = AfbSingleInstanceHelper.getInstance().tryLock(lockFile);
        if (fileLock == null) {
            this.getLogger().warning("Unlock file." + lockFile.getPath());
            this.setExitCode(11);
            return;
        }
        this.startCommon();
        String bootConfigDirName = BcArgumentUtil.getArgumentValue(mainArgs, "-bootConfig");
        this.fireEvent(new AfbApplicationEvent(this, 41, "Talisker \u8a2d\u5b9a\u60c5\u5831\u3092\u8aad\u8fbc\u307f\u4e2d\u3067\u3059..."));
        if (BcStringUtil.isEmpty(bootConfigDirName)) {
            if (this.bootEnabled) {
                bootConfigDir = new File(this.getRootDirectry(), "BOOT-CONFIG/");
                if (bootConfigDir.exists()) {
                    this.bootConfigByFile(bootConfigDir);
                } else {
                    this.setBootConfigFromZip(null);
                }
            }
        } else {
            bootConfigDir = new File(bootConfigDirName);
            this.bootConfigByFile(bootConfigDir);
        }
        if (doWait) {
            this.monitor.lock();
        }
        AfbApplicationSetupProxy applicationSetupProxy = new AfbApplicationSetupProxy();
        applicationSetupProxy.start(this, this.bootConfig);
        if (doWait) {
            this.monitor.sync();
        }
    }

    public void startForServlet(File bootConfigDir) throws Exception {
        this.getLogger().info("AfbApplication.startForServlet");
        this.startCommon();
        this.bootConfigByFile(bootConfigDir);
        AfbApplicationSetupProxy applicationSetupProxy = new AfbApplicationSetupProxy();
        applicationSetupProxy.start(this, this.bootConfig);
    }

    protected void bootConfigByFile(File bootConfigDir) throws Exception {
        File bootConfigFile = new File(bootConfigDir.getPath(), "config.xml");
        if (!bootConfigFile.exists()) {
            throw new FileNotFoundException("not found:" + bootConfigFile.getPath());
        }
        this.bootConfig = BcXmlUtil.createDocument(bootConfigFile);
        this.parseBootConfig(this.bootConfig);
    }

    protected void parseBootConfig(Document bootCofigDom2) throws Exception {
        this.appContext.developerName = BcXmlUtil.getTextValue(bootCofigDom2, "developer/name");
        this.appContext.developerUrl = BcXmlUtil.getTextValue(bootCofigDom2, "developer/url");
        this.appContext.developerCopyright = BcXmlUtil.getTextValue(bootCofigDom2, "developer/copyright");
        this.appContext.vendorName = BcXmlUtil.getTextValue(bootCofigDom2, "vendor/name");
        this.appContext.vendorUrl = BcXmlUtil.getTextValue(bootCofigDom2, "vendor/url");
        this.appContext.vendorCopyright = BcXmlUtil.getTextValue(bootCofigDom2, "vendor/copyright");
        this.appContext.appName = BcXmlUtil.getTextValue(bootCofigDom2, "application/name");
        this.appContext.version = BcXmlUtil.getTextValue(bootCofigDom2, "application/version");
        this.appContext.buildInfo = BcXmlUtil.getTextValue(bootCofigDom2, "application/build");
        this.appContext.serialCode = BcXmlUtil.getTextValue(bootCofigDom2, "application/serialCode");
        String tmpStr = BcXmlUtil.getTextValue(bootCofigDom2, "application/runMode");
        this.appContext.isTrial = Boolean.parseBoolean(BcXmlUtil.getTextValue(bootCofigDom2, "application/trial"));
        this.appContext.termOfValidity = AfbXmlUtil.parseDate(bootCofigDom2, "application/termOfValidity");
        tmpStr = BcXmlUtil.getTextValue(bootCofigDom2, "application/localeLangage");
        Locale locale = null;
        locale = BcStringUtil.isEmpty(tmpStr) ? Locale.getDefault() : BcLocaleUtil.getLocaleByLangageCode(tmpStr);
        BcLocaleUtil.setDefault(locale);
        tmpStr = BcXmlUtil.getTextValue(bootCofigDom2, "setupClass/class");
        this.setupClass = Class.forName(tmpStr);
    }

    public void setBootConfigFromZip(String optionPath) throws Exception {
        ArrayList<String> pathList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(optionPath)) {
            String classPath = System.getProperty("java.class.path");
            String pathSep = System.getProperty("path.separator");
            BcStringUtil.stringTokenize(classPath, pathSep, true, true, pathList);
        } else {
            pathList.add(optionPath);
        }
        int i = 0;
        while (i < pathList.size()) {
            block10: {
                String path = (String)pathList.get(i);
                if (!BcStringUtil.isEmpty(path)) {
                    File file2 = new File(path);
                    if (!file2.exists()) {
                        file2 = new File(String.valueOf(this.getRootDirectry().getPath()) + "/" + path);
                    }
                    if (file2.exists()) {
                        ZipFile zipFile = null;
                        try {
                            zipFile = new ZipFile(file2);
                        }
                        catch (Exception ex) {
                            break block10;
                        }
                        ZipEntry zipEntry = zipFile.getEntry("BOOT-CONFIG/config.dat");
                        if (zipEntry != null) {
                            InputStream is = zipFile.getInputStream(zipEntry);
                            BcUtf8Util.skipBOM(is);
                            byte[] bytes = BcStreamUtil.read(is);
                            is.close();
                            String xmlText = BcCipherUtil.decrypt("gw6hdf8s", bytes);
                            ByteArrayInputStream bais = new ByteArrayInputStream(xmlText.getBytes("UTF-8"));
                            BcUtf8Util.skipBOM(bais);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            BcStreamUtil.transmit(bais, baos, 1024);
                            byte[] bytes2 = baos.toByteArray();
                            ByteArrayInputStream bais2 = new ByteArrayInputStream(bytes2);
                            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                            this.bootConfig = documentBuilder.parse(bais2);
                            this.parseBootConfig(this.bootConfig);
                            break;
                        }
                        zipEntry = zipFile.getEntry("BOOT-CONFIG/config.xml");
                        if (zipEntry != null) {
                            this.bootConfig = BcXmlUtil.createDocument(zipFile.getInputStream(zipEntry));
                            this.parseBootConfig(this.bootConfig);
                            break;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void exit(int exitCode) {
        this.setExitCode(exitCode);
        this.monitor.unLock();
    }

    public void exit() {
        this.exit(this.getExitCode());
    }

    public boolean addApplicationEventHandler(AfbApplicationEventHandler eventHandler) {
        return this.applicationEventHandlerList.add(eventHandler);
    }

    public boolean removeApplicationEventHandler(AfbApplicationEventHandler eventHandler) {
        return this.applicationEventHandlerList.remove(eventHandler);
    }

    public void fireEvent(AfbApplicationEvent ev) {
        AfbApplicationEventHandler[] eventHandlers = this.applicationEventHandlerList.toArray(new AfbApplicationEventHandler[0]);
        int i = 0;
        while (i < eventHandlers.length) {
            AfbApplicationEventHandler eventHandler = eventHandlers[i];
            try {
                eventHandler.actionPerformed(ev);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }

    public Map<String, String> getFileAliasMap() {
        return this.fileAliasMap;
    }

    /* synthetic */ AfbApplication(AfbApplication afbApplication) {
        this();
    }

    private static final class SingletonHolder {
        private static final AfbApplication instance = new AfbApplication(null);

        private SingletonHolder() {
        }
    }
}

