/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.SAXException;

public class XML11Serializer
extends XMLSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;

    public XML11Serializer() {
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputFormat format) {
        super(format);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(Writer writer, OutputFormat format) {
        super(writer, format);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputStream output, OutputFormat format) {
        super(output, format != null ? format : new OutputFormat("xml", null, false));
        this._format.setVersion("1.1");
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            if (state.inCData || state.doCData) {
                if (!state.inCData) {
                    this._printer.printText("<![CDATA[");
                    state.inCData = true;
                }
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                int end = start + length;
                int index = start;
                while (index < end) {
                    char ch = chars[index];
                    if (ch == ']' && index + 2 < end && chars[index + 1] == ']' && chars[index + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        index += 2;
                    } else if (!XML11Char.isXML11Valid(ch)) {
                        if (++index < end) {
                            this.surrogates(ch, chars[index], true);
                        } else {
                            this.fatalError("The character '" + ch + "' is an invalid XML character");
                        }
                    } else if (this._encodingInfo.isPrintable(ch) && XML11Char.isXML11ValidLiteral(ch)) {
                        this._printer.printText(ch);
                    } else {
                        this._printer.printText("]]>&#x");
                        this._printer.printText(Integer.toHexString(ch));
                        this._printer.printText(";<![CDATA[");
                    }
                    ++index;
                }
                this._printer.setNextIndent(saveIndent);
            } else if (state.preserveSpace) {
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(chars, start, length, true, state.unescaped);
                this._printer.setNextIndent(saveIndent);
            } else {
                this.printText(chars, start, length, false, state.unescaped);
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    protected void printEscaped(String source) throws IOException {
        int length = source.length();
        int i = 0;
        while (i < length) {
            char ch = source.charAt(i);
            if (!XML11Char.isXML11Valid(ch)) {
                if (++i < length) {
                    this.surrogates(ch, source.charAt(i), false);
                } else {
                    this.fatalError("The character '" + (char)ch + "' is an invalid XML character");
                }
            } else if (ch == '\n' || ch == '\r' || ch == '\t' || ch == '\u0085' || ch == '\u2028') {
                this.printHex(ch);
            } else if (ch == '<') {
                this._printer.printText("&lt;");
            } else if (ch == '&') {
                this._printer.printText("&amp;");
            } else if (ch == '\"') {
                this._printer.printText("&quot;");
            } else if (ch >= ' ' && this._encodingInfo.isPrintable(ch)) {
                this._printer.printText(ch);
            } else {
                this.printHex(ch);
            }
            ++i;
        }
    }

    @Override
    protected final void printCDATAText(String text) throws IOException {
        int length = text.length();
        int index = 0;
        while (index < length) {
            char ch = text.charAt(index);
            if (ch == ']' && index + 2 < length && text.charAt(index + 1) == ']' && text.charAt(index + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String msg;
                    if ((this.features & 0x10) == 0 && (this.features & 2) == 0) {
                        msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null);
                        this.modifyDOMError(msg, (short)3, null, this.fCurrentNode);
                        boolean continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!continueProcess) {
                            throw new IOException();
                        }
                    } else {
                        msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                        this.modifyDOMError(msg, (short)1, null, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                index += 2;
            } else if (!XML11Char.isXML11Valid(ch)) {
                if (++index < length) {
                    this.surrogates(ch, text.charAt(index), true);
                } else {
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                }
            } else if (this._encodingInfo.isPrintable(ch) && XML11Char.isXML11ValidLiteral(ch)) {
                this._printer.printText(ch);
            } else {
                this._printer.printText("]]>&#x");
                this._printer.printText(Integer.toHexString(ch));
                this._printer.printText(";<![CDATA[");
            }
            ++index;
        }
    }

    @Override
    protected final void printXMLChar(int ch) throws IOException {
        if (ch == 13 || ch == 133 || ch == 8232) {
            this.printHex(ch);
        } else if (ch == 60) {
            this._printer.printText("&lt;");
        } else if (ch == 38) {
            this._printer.printText("&amp;");
        } else if (ch == 62) {
            this._printer.printText("&gt;");
        } else if (this._encodingInfo.isPrintable((char)ch) && XML11Char.isXML11ValidLiteral(ch)) {
            this._printer.printText((char)ch);
        } else {
            this.printHex(ch);
        }
    }

    @Override
    protected final void surrogates(int high, int low, boolean inContent) throws IOException {
        if (XMLChar.isHighSurrogate(high)) {
            if (!XMLChar.isLowSurrogate(low)) {
                this.fatalError("The character '" + (char)low + "' is an invalid XML character");
            } else {
                int supplemental = XMLChar.supplemental((char)high, (char)low);
                if (!XML11Char.isXML11Valid(supplemental)) {
                    this.fatalError("The character '" + (char)supplemental + "' is an invalid XML character");
                } else if (inContent && this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(supplemental));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(supplemental);
                }
            }
        } else {
            this.fatalError("The character '" + (char)high + "' is an invalid XML character");
        }
    }

    @Override
    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        int length = text.length();
        if (preserveSpace) {
            int index = 0;
            while (index < length) {
                char ch = text.charAt(index);
                if (!XML11Char.isXML11Valid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index), true);
                    } else {
                        this.fatalError("The character '" + ch + "' is an invalid XML character");
                    }
                } else if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                } else {
                    this.printXMLChar(ch);
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < length) {
                char ch = text.charAt(index);
                if (!XML11Char.isXML11Valid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index), true);
                    } else {
                        this.fatalError("The character '" + ch + "' is an invalid XML character");
                    }
                } else if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                } else {
                    this.printXMLChar(ch);
                }
                ++index;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        block8: {
            if (!preserveSpace) ** GOTO lbl25
            while (length-- > 0) {
                if (!XML11Char.isXML11Valid(ch = chars[start++])) {
                    if (length-- > 0) {
                        this.surrogates(ch, chars[start++], true);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                if (!XML11Char.isXML11Valid(ch = chars[start++])) {
                    if (length-- > 0) {
                        this.surrogates(ch, chars[start++], true);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
lbl25:
                // 5 sources

                ** while (length-- > 0)
            }
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        return true;
    }
}

