/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resolver;

import org.apache.tools.ant.types.resolver.ApacheCatalogResolver;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.helpers.PublicId;

public class ApacheCatalog
extends Catalog {
    private ApacheCatalogResolver resolver = null;

    @Override
    protected Catalog newCatalog() {
        ApacheCatalog cat = (ApacheCatalog)super.newCatalog();
        cat.setResolver(this.resolver);
        return cat;
    }

    public void setResolver(ApacheCatalogResolver resolver2) {
        this.resolver = resolver2;
    }

    @Override
    public void addEntry(CatalogEntry entry) {
        int type = entry.getEntryType();
        if (type == PUBLIC) {
            String publicid = PublicId.normalize(entry.getEntryArg(0));
            String systemid = this.normalizeURI(entry.getEntryArg(1));
            if (this.resolver == null) {
                this.catalogManager.debug.message(1, "Internal Error: null ApacheCatalogResolver");
            } else {
                this.resolver.addPublicEntry(publicid, systemid, this.base);
            }
        } else if (type == URI) {
            String uri = this.normalizeURI(entry.getEntryArg(0));
            String altURI = this.normalizeURI(entry.getEntryArg(1));
            if (this.resolver == null) {
                this.catalogManager.debug.message(1, "Internal Error: null ApacheCatalogResolver");
            } else {
                this.resolver.addURIEntry(uri, altURI, this.base);
            }
        }
        super.addEntry(entry);
    }
}

