/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.property.LocalProperties;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private static final int NUMBER_TRIES = 100;
    private Vector nestedTasks = new Vector();
    private final Object semaphore = new Object();
    private int numThreads = 0;
    private int numThreadsPerProcessor = 0;
    private long timeout;
    private volatile boolean stillRunning;
    private boolean timedOut;
    private boolean failOnAny;
    private TaskList daemonTasks;
    private StringBuffer exceptionMessage;
    private int numExceptions = 0;
    private Throwable firstException;
    private Location firstLocation;
    private Integer firstExitStatus;

    public void addDaemons(TaskList daemonTasks) {
        if (this.daemonTasks != null) {
            throw new BuildException("Only one daemon group is supported");
        }
        this.daemonTasks = daemonTasks;
    }

    public void setPollInterval(int pollInterval) {
    }

    public void setFailOnAny(boolean failOnAny) {
        this.failOnAny = failOnAny;
    }

    @Override
    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void setThreadsPerProcessor(int numThreadsPerProcessor) {
        this.numThreadsPerProcessor = numThreadsPerProcessor;
    }

    public void setThreadCount(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void execute() throws BuildException {
        this.updateThreadCounts();
        if (this.numThreads == 0) {
            this.numThreads = this.nestedTasks.size();
        }
        this.spinThreads();
    }

    private void updateThreadCounts() {
        if (this.numThreadsPerProcessor != 0) {
            this.numThreads = Runtime.getRuntime().availableProcessors() * this.numThreadsPerProcessor;
        }
    }

    private void processExceptions(TaskRunnable[] runnables) {
        if (runnables == null) {
            return;
        }
        int i = 0;
        while (i < runnables.length) {
            Throwable t = runnables[i].getException();
            if (t != null) {
                ++this.numExceptions;
                if (this.firstException == null) {
                    this.firstException = t;
                }
                if (t instanceof BuildException && this.firstLocation == Location.UNKNOWN_LOCATION) {
                    this.firstLocation = ((BuildException)t).getLocation();
                }
                if (t instanceof ExitStatusException && this.firstExitStatus == null) {
                    ExitStatusException ex = (ExitStatusException)t;
                    this.firstExitStatus = ex.getStatus();
                    this.firstLocation = ex.getLocation();
                }
                this.exceptionMessage.append(StringUtils.LINE_SEP);
                this.exceptionMessage.append(t.getMessage());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void spinThreads() throws BuildException {
        numTasks = this.nestedTasks.size();
        runnables = new TaskRunnable[numTasks];
        this.stillRunning = true;
        this.timedOut = false;
        interrupted = false;
        threadNumber = 0;
        e = this.nestedTasks.elements();
        while (e.hasMoreElements()) {
            nestedTask = (Task)e.nextElement();
            runnables[threadNumber] = new TaskRunnable(nestedTask);
            ++threadNumber;
        }
        maxRunning = numTasks < this.numThreads ? numTasks : this.numThreads;
        running = new TaskRunnable[maxRunning];
        threadNumber = 0;
        group = new ThreadGroup("parallel");
        daemons = null;
        if (this.daemonTasks != null && TaskList.access$0(this.daemonTasks).size() != 0) {
            daemons = new TaskRunnable[TaskList.access$0(this.daemonTasks).size()];
        }
        v0 = this.semaphore;
        ** synchronized (v0)
lbl22:
        // 1 sources

        var9_10 = this.semaphore;
        synchronized (var9_10) {
            if (daemons != null) {
                i = 0;
                while (i < daemons.length) {
                    daemons[i] = new TaskRunnable((Task)TaskList.access$0(this.daemonTasks).get(i));
                    daemonThread = new Thread(group, daemons[i]);
                    daemonThread.setDaemon(true);
                    daemonThread.start();
                    ++i;
                }
            }
            i = 0;
            while (i < maxRunning) {
                running[i] = runnables[threadNumber++];
                thread = new Thread(group, running[i]);
                thread.start();
                ++i;
            }
            if (this.timeout != 0L) {
                timeoutThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        try {
                            long start = System.currentTimeMillis();
                            long end = start + Parallel.this.timeout;
                            long now = System.currentTimeMillis();
                            while (now < end) {
                                this.wait(end - now);
                                now = System.currentTimeMillis();
                            }
                            Object object = Parallel.this.semaphore;
                            synchronized (object) {
                                Parallel.this.stillRunning = false;
                                Parallel.this.timedOut = true;
                                Parallel.this.semaphore.notifyAll();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                timeoutThread.start();
            }
            try {
                block9: while (threadNumber < numTasks && this.stillRunning) {
                    i = 0;
                    while (i < maxRunning) {
                        if (running[i] == null || running[i].isFinished()) {
                            running[i] = runnables[threadNumber++];
                            thread = new Thread(group, running[i]);
                            thread.start();
                            continue block9;
                        }
                        ++i;
                    }
                    this.semaphore.wait();
                }
                block11: while (this.stillRunning) {
                    i = 0;
                    while (i < maxRunning) {
                        if (running[i] != null && !running[i].isFinished()) {
                            this.semaphore.wait();
                            continue block11;
                        }
                        ++i;
                    }
                    this.stillRunning = false;
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
            if (!this.timedOut && !this.failOnAny) {
                this.killAll(running);
            }
        }
        if (interrupted) {
            throw new BuildException("Parallel execution interrupted.");
        }
        if (this.timedOut) {
            throw new BuildException("Parallel execution timed out");
        }
        this.exceptionMessage = new StringBuffer();
        this.numExceptions = 0;
        this.firstException = null;
        this.firstExitStatus = null;
        this.firstLocation = Location.UNKNOWN_LOCATION;
        this.processExceptions(daemons);
        this.processExceptions(runnables);
        if (this.numExceptions == 1) {
            if (this.firstException instanceof BuildException) {
                throw (BuildException)this.firstException;
            }
            throw new BuildException(this.firstException);
        }
        if (this.numExceptions > 1) {
            if (this.firstExitStatus == null) {
                throw new BuildException(this.exceptionMessage.toString(), this.firstLocation);
            }
            throw new ExitStatusException(this.exceptionMessage.toString(), this.firstExitStatus, this.firstLocation);
        }
    }

    private void killAll(TaskRunnable[] running) {
        boolean oneAlive;
        int tries = 0;
        do {
            oneAlive = false;
            int i = 0;
            while (i < running.length) {
                if (running[i] != null && !running[i].isFinished()) {
                    running[i].interrupt();
                    Thread.yield();
                    oneAlive = true;
                }
                ++i;
            }
            if (!oneAlive) continue;
            ++tries;
            Thread.yield();
        } while (oneAlive && tries < 100);
    }

    public static class TaskList
    implements TaskContainer {
        private List tasks = new ArrayList();

        @Override
        public void addTask(Task nestedTask) {
            this.tasks.add(nestedTask);
        }

        static /* synthetic */ List access$0(TaskList taskList) {
            return taskList.tasks;
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Throwable exception;
        private Task task;
        private boolean finished;
        private volatile Thread thread;

        TaskRunnable(Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    try {
                        LocalProperties.get(Parallel.this.getProject()).copy();
                        this.thread = Thread.currentThread();
                        this.task.perform();
                    }
                    catch (Throwable t) {
                        this.exception = t;
                        if (Parallel.this.failOnAny) {
                            Parallel.this.stillRunning = false;
                        }
                        Object object = Parallel.this.semaphore;
                        synchronized (object) {
                            this.finished = true;
                            Parallel.this.semaphore.notifyAll();
                            break block15;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = Parallel.this.semaphore;
                    synchronized (object) {
                        this.finished = true;
                        Parallel.this.semaphore.notifyAll();
                    }
                    throw throwable;
                }
                Object object = Parallel.this.semaphore;
                synchronized (object) {
                    this.finished = true;
                    Parallel.this.semaphore.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        boolean isFinished() {
            return this.finished;
        }

        void interrupt() {
            this.thread.interrupt();
        }
    }
}

