/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.StringUtils;

public class DefaultExcludes
extends Task {
    private String add = "";
    private String remove = "";
    private boolean defaultrequested = false;
    private boolean echo = false;
    private int logLevel = 1;

    @Override
    public void execute() throws BuildException {
        if (!this.defaultrequested && this.add.equals("") && this.remove.equals("") && !this.echo) {
            throw new BuildException("<defaultexcludes> task must set at least one attribute (echo=\"false\" doesn't count since that is the default");
        }
        if (this.defaultrequested) {
            DirectoryScanner.resetDefaultExcludes();
        }
        if (!this.add.equals("")) {
            DirectoryScanner.addDefaultExclude(this.add);
        }
        if (!this.remove.equals("")) {
            DirectoryScanner.removeDefaultExclude(this.remove);
        }
        if (this.echo) {
            StringBuffer message = new StringBuffer("Current Default Excludes:");
            message.append(StringUtils.LINE_SEP);
            String[] excludes = DirectoryScanner.getDefaultExcludes();
            int i = 0;
            while (i < excludes.length) {
                message.append("  ");
                message.append(excludes[i]);
                message.append(StringUtils.LINE_SEP);
                ++i;
            }
            this.log(message.toString(), this.logLevel);
        }
    }

    public void setDefault(boolean def) {
        this.defaultrequested = def;
    }

    public void setAdd(String add) {
        this.add = add;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }
}

