/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.StringMap;

@ServiceConsumer(value=ContextDataProvider.class, resolution="optional", cardinality="multiple")
public class ThreadContextDataInjector {
    private static final Logger LOGGER = StatusLogger.getLogger();
    public static Collection<ContextDataProvider> contextDataProviders = new ConcurrentLinkedDeque<ContextDataProvider>();
    private static final List<ContextDataProvider> SERVICE_PROVIDERS = ThreadContextDataInjector.getServiceProviders();

    @Deprecated
    public static void initServiceProviders() {
    }

    private static List<ContextDataProvider> getServiceProviders() {
        ArrayList providers = new ArrayList();
        ServiceLoaderUtil.loadServices(ContextDataProvider.class, MethodHandles.lookup(), false).forEach(providers::add);
        return Collections.unmodifiableList(providers);
    }

    public static void copyProperties(List<Property> properties, StringMap result) {
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                Property prop = properties.get(i);
                result.putValue(prop.getName(), prop.getValue());
                ++i;
            }
        }
    }

    private static List<ContextDataProvider> getProviders() {
        ArrayList<ContextDataProvider> providers = new ArrayList<ContextDataProvider>(contextDataProviders.size() + SERVICE_PROVIDERS.size());
        providers.addAll(contextDataProviders);
        providers.addAll(SERVICE_PROVIDERS);
        return providers;
    }

    static /* synthetic */ List access$0() {
        return ThreadContextDataInjector.getProviders();
    }

    public static class ForCopyOnWriteThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$0();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap ignore) {
            if (this.providers.size() == 1 && (props == null || props.isEmpty())) {
                return this.providers.get(0).supplyStringMap();
            }
            int count = props == null ? 0 : props.size();
            StringMap[] maps = new StringMap[this.providers.size()];
            int i = 0;
            while (i < this.providers.size()) {
                maps[i] = this.providers.get(i).supplyStringMap();
                count += maps[i].size();
                ++i;
            }
            StringMap result = ContextDataFactory.createContextData(count);
            ThreadContextDataInjector.copyProperties(props, result);
            StringMap[] stringMapArray = maps;
            int n = maps.length;
            int n2 = 0;
            while (n2 < n) {
                StringMap map = stringMapArray[n2];
                result.putAll(map);
                ++n2;
            }
            return result;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            return ThreadContext.getThreadContextMap().getReadOnlyContextData();
        }
    }

    public static class ForDefaultThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$0();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap ignore) {
            Map<Object, Object> copy;
            if (this.providers.size() == 1) {
                copy = this.providers.get(0).supplyContextData();
            } else {
                copy = new HashMap();
                for (ContextDataProvider provider : this.providers) {
                    copy.putAll(provider.supplyContextData());
                }
            }
            if (props == null || props.isEmpty()) {
                return copy.isEmpty() ? ContextDataFactory.emptyFrozenContextData() : ForDefaultThreadContextMap.frozenStringMap(copy);
            }
            JdkMapAdapterStringMap result = new JdkMapAdapterStringMap(new HashMap<Object, Object>(copy), false);
            int i = 0;
            while (i < props.size()) {
                Property prop = props.get(i);
                if (!copy.containsKey(prop.getName())) {
                    result.putValue(prop.getName(), prop.getValue());
                }
                ++i;
            }
            result.freeze();
            return result;
        }

        private static JdkMapAdapterStringMap frozenStringMap(Map<String, String> copy) {
            return new JdkMapAdapterStringMap(copy, true);
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            ReadOnlyThreadContextMap map = ThreadContext.getThreadContextMap();
            if (map != null) {
                return map.getReadOnlyContextData();
            }
            Map<String, String> copy = ThreadContext.getImmutableContext();
            return copy.isEmpty() ? ContextDataFactory.emptyFrozenContextData() : new JdkMapAdapterStringMap(copy, true);
        }
    }

    public static class ForGarbageFreeThreadContextMap
    implements ContextDataInjector {
        private final List<ContextDataProvider> providers = ThreadContextDataInjector.access$0();

        @Override
        public StringMap injectContextData(List<Property> props, StringMap reusable) {
            ThreadContextDataInjector.copyProperties(props, reusable);
            int i = 0;
            while (i < this.providers.size()) {
                reusable.putAll(this.providers.get(i).supplyStringMap());
                ++i;
            }
            return reusable;
        }

        @Override
        public ReadOnlyStringMap rawContextData() {
            return ThreadContext.getThreadContextMap().getReadOnlyContextData();
        }
    }
}

