/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;

class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();
    private final long timeoutInNanos;
    private static final int ONE_MILLISECOND_IN_NANOSECONDS = 1000000;

    public TimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        timeoutNanos = this.timeoutInNanos;
        if (cursorSequence.get() >= sequence) ** GOTO lbl17
        var10_6 = this.mutex;
        synchronized (var10_6) {
            while (cursorSequence.get() < sequence) {
                barrier.checkAlert();
                timeoutNanos = TimeoutBlockingWaitStrategy.awaitNanos(this.mutex, timeoutNanos);
                if (timeoutNanos > 0L) continue;
                throw TimeoutException.INSTANCE;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var10_6
            if (true) ** GOTO lbl17
        }
        do {
            barrier.checkAlert();
lbl17:
            // 3 sources

        } while ((availableSequence = dependentSequence.get()) < sequence);
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAllWhenBlocking() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public String toString() {
        return "TimeoutBlockingWaitStrategy{mutex=" + this.mutex + ", timeoutInNanos=" + this.timeoutInNanos + '}';
    }

    private static long awaitNanos(Object mutex, long timeoutNanos) throws InterruptedException {
        long millis = timeoutNanos / 1000000L;
        long nanos = timeoutNanos % 1000000L;
        long t0 = System.nanoTime();
        mutex.wait(millis, (int)nanos);
        long t1 = System.nanoTime();
        return timeoutNanos - (t1 - t0);
    }
}

