/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.JXPathTypeConversionException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.TypeConverter;
import org.apache.commons.jxpath.util.TypeUtils;

public class BasicTypeConverter
implements TypeConverter {
    @Override
    public boolean canConvert(Object object, Class toType) {
        Class<?> fromType;
        if (object == null) {
            return true;
        }
        Class useType = TypeUtils.wrapPrimitive(toType);
        if (useType.isAssignableFrom(fromType = object.getClass())) {
            return true;
        }
        if (useType == String.class) {
            return true;
        }
        if (object instanceof Boolean && (Number.class.isAssignableFrom(useType) || "java.util.concurrent.atomic.AtomicBoolean".equals(useType.getName()))) {
            return true;
        }
        if (object instanceof Number && (Number.class.isAssignableFrom(useType) || useType == Boolean.class)) {
            return true;
        }
        if (object instanceof String && (useType == Boolean.class || useType == Character.class || useType == Byte.class || useType == Short.class || useType == Integer.class || useType == Long.class || useType == Float.class || useType == Double.class)) {
            return true;
        }
        if (fromType.isArray()) {
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                int length = Array.getLength(object);
                int i = 0;
                while (i < length) {
                    Object value = Array.get(object, i);
                    if (!this.canConvert(value, cType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (Collection.class.isAssignableFrom(useType)) {
                return this.canCreateCollection(useType);
            }
            if (Array.getLength(object) > 0) {
                Object value = Array.get(object, 0);
                return this.canConvert(value, useType);
            }
            return this.canConvert("", useType);
        }
        if (object instanceof Collection) {
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                for (Object value : (Collection)object) {
                    if (this.canConvert(value, cType)) continue;
                    return false;
                }
                return true;
            }
            if (Collection.class.isAssignableFrom(useType)) {
                return this.canCreateCollection(useType);
            }
            if (((Collection)object).size() > 0) {
                Object value;
                if (object instanceof List) {
                    value = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value = it.next();
                }
                return this.canConvert(value, useType);
            }
            return this.canConvert("", useType);
        }
        if (object instanceof NodeSet) {
            return this.canConvert(((NodeSet)object).getValues(), useType);
        }
        if (object instanceof Pointer) {
            return this.canConvert(((Pointer)object).getValue(), useType);
        }
        return ConvertUtils.lookup((Class)useType) != null;
    }

    @Override
    public Object convert(Object object, Class toType) {
        Object value;
        Class<?> fromType;
        if (object == null) {
            return toType.isPrimitive() ? this.convertNullToPrimitive(toType) : null;
        }
        if (toType == Object.class) {
            if (object instanceof NodeSet) {
                return this.convert(((NodeSet)object).getValues(), toType);
            }
            if (object instanceof Pointer) {
                return this.convert(((Pointer)object).getValue(), toType);
            }
            return object;
        }
        Class useType = TypeUtils.wrapPrimitive(toType);
        if (useType.isAssignableFrom(fromType = object.getClass())) {
            return object;
        }
        if (fromType.isArray()) {
            int length = Array.getLength(object);
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                Object array = Array.newInstance(cType, length);
                int i = 0;
                while (i < length) {
                    Object value2 = Array.get(object, i);
                    Array.set(array, i, this.convert(value2, cType));
                    ++i;
                }
                return array;
            }
            if (Collection.class.isAssignableFrom(useType)) {
                Collection collection = this.allocateCollection(useType);
                int i = 0;
                while (i < length) {
                    collection.add(Array.get(object, i));
                    ++i;
                }
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value3 = Array.get(object, 0);
                return this.convert(value3, useType);
            }
            return this.convert("", useType);
        }
        if (object instanceof Collection) {
            int length = ((Collection)object).size();
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                Object array = Array.newInstance(cType, length);
                Iterator it = ((Collection)object).iterator();
                int i = 0;
                while (i < length) {
                    Object value4 = it.next();
                    Array.set(array, i, this.convert(value4, cType));
                    ++i;
                }
                return array;
            }
            if (Collection.class.isAssignableFrom(useType)) {
                Collection collection = this.allocateCollection(useType);
                collection.addAll((Collection)object);
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value5;
                if (object instanceof List) {
                    value5 = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value5 = it.next();
                }
                return this.convert(value5, useType);
            }
            return this.convert("", useType);
        }
        if (object instanceof NodeSet) {
            return this.convert(((NodeSet)object).getValues(), useType);
        }
        if (object instanceof Pointer) {
            return this.convert(((Pointer)object).getValue(), useType);
        }
        if (useType == String.class) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            if (Number.class.isAssignableFrom(useType)) {
                return this.allocateNumber(useType, (Boolean)object != false ? 1 : 0);
            }
            if ("java.util.concurrent.atomic.AtomicBoolean".equals(useType.getName())) {
                try {
                    return useType.getConstructor(Boolean.TYPE).newInstance(object);
                }
                catch (Exception e) {
                    throw new JXPathTypeConversionException(useType.getName(), e);
                }
            }
        }
        if (object instanceof Number) {
            double value6 = ((Number)object).doubleValue();
            if (useType == Boolean.class) {
                return value6 == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (Number.class.isAssignableFrom(useType)) {
                return this.allocateNumber(useType, value6);
            }
        }
        if (object instanceof String && (value = this.convertStringToPrimitive(object, useType)) != null) {
            return value;
        }
        Converter converter = ConvertUtils.lookup((Class)useType);
        if (converter != null) {
            return converter.convert(useType, object);
        }
        throw new JXPathTypeConversionException("Cannot convert " + object.getClass() + " to " + useType);
    }

    protected Object convertNullToPrimitive(Class toType) {
        if (toType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toType == Character.TYPE) {
            return new Character('\u0000');
        }
        if (toType == Byte.TYPE) {
            return new Byte(0);
        }
        if (toType == Short.TYPE) {
            return new Short(0);
        }
        if (toType == Integer.TYPE) {
            return new Integer(0);
        }
        if (toType == Long.TYPE) {
            return new Long(0L);
        }
        if (toType == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toType == Double.TYPE) {
            return new Double(0.0);
        }
        return null;
    }

    protected Object convertStringToPrimitive(Object object, Class toType) {
        if ((toType = TypeUtils.wrapPrimitive(toType)) == Boolean.class) {
            return Boolean.valueOf((String)object);
        }
        if (toType == Character.class) {
            return new Character(((String)object).charAt(0));
        }
        if (toType == Byte.class) {
            return new Byte((String)object);
        }
        if (toType == Short.class) {
            return new Short((String)object);
        }
        if (toType == Integer.class) {
            return new Integer((String)object);
        }
        if (toType == Long.class) {
            return new Long((String)object);
        }
        if (toType == Float.class) {
            return new Float((String)object);
        }
        if (toType == Double.class) {
            return new Double((String)object);
        }
        return null;
    }

    protected Number allocateNumber(Class type, double value) {
        if ((type = TypeUtils.wrapPrimitive(type)) == Byte.class) {
            return new Byte((byte)value);
        }
        if (type == Short.class) {
            return new Short((short)value);
        }
        if (type == Integer.class) {
            return new Integer((int)value);
        }
        if (type == Long.class) {
            return new Long((long)value);
        }
        if (type == Float.class) {
            return new Float((float)value);
        }
        if (type == Double.class) {
            return new Double(value);
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf((long)value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        String classname = type.getName();
        Class<Number> initialValueType = null;
        if ("java.util.concurrent.atomic.AtomicInteger".equals(classname)) {
            initialValueType = Integer.TYPE;
        }
        if ("java.util.concurrent.atomic.AtomicLong".equals(classname)) {
            initialValueType = Long.TYPE;
        }
        if (initialValueType != null) {
            try {
                return (Number)type.getConstructor(initialValueType).newInstance(this.allocateNumber(initialValueType, value));
            }
            catch (Exception e) {
                throw new JXPathTypeConversionException(classname, e);
            }
        }
        return null;
    }

    protected boolean canCreateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
            try {
                type.getConstructor(new Class[0]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return type == List.class || type == Collection.class || type == Set.class;
    }

    protected Collection allocateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathInvalidAccessException("Cannot create collection of type: " + type, ex);
            }
        }
        if (type == List.class || type == Collection.class) {
            return new ArrayList();
        }
        if (type == Set.class) {
            return new HashSet();
        }
        throw new JXPathInvalidAccessException("Cannot create collection of type: " + type);
    }

    protected Collection unmodifiableCollection(Collection collection) {
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    static final class ValueNodeSet
    implements NodeSet {
        private List values;
        private List pointers;

        public ValueNodeSet(List values) {
            this.values = values;
        }

        @Override
        public List getValues() {
            return Collections.unmodifiableList(this.values);
        }

        @Override
        public List getNodes() {
            return Collections.unmodifiableList(this.values);
        }

        @Override
        public List getPointers() {
            if (this.pointers == null) {
                this.pointers = new ArrayList();
                int i = 0;
                while (i < this.values.size()) {
                    this.pointers.add(new ValuePointer(this.values.get(i)));
                    ++i;
                }
                this.pointers = Collections.unmodifiableList(this.pointers);
            }
            return this.pointers;
        }
    }

    static final class ValuePointer
    implements Pointer {
        private static final long serialVersionUID = -4817239482392206188L;
        private Object bean;

        public ValuePointer(Object object) {
            this.bean = object;
        }

        @Override
        public Object getValue() {
            return this.bean;
        }

        @Override
        public Object getNode() {
            return this.bean;
        }

        @Override
        public Object getRootNode() {
            return this.bean;
        }

        @Override
        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object clone() {
            return this;
        }

        public int compareTo(Object object) {
            return 0;
        }

        @Override
        public String asPath() {
            if (this.bean == null) {
                return "null()";
            }
            if (this.bean instanceof Number) {
                String string = this.bean.toString();
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            if (this.bean instanceof Boolean) {
                return (Boolean)this.bean != false ? "true()" : "false()";
            }
            if (this.bean instanceof String) {
                return "'" + this.bean + "'";
            }
            return "{object of type " + this.bean.getClass().getName() + "}";
        }
    }
}

