/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.servlet.HttpSessionAndServletContext;
import org.apache.commons.jxpath.servlet.HttpSessionHandler;
import org.apache.commons.jxpath.servlet.KeywordVariables;
import org.apache.commons.jxpath.servlet.PageContextHandler;
import org.apache.commons.jxpath.servlet.PageScopeContext;
import org.apache.commons.jxpath.servlet.PageScopeContextHandler;
import org.apache.commons.jxpath.servlet.ServletContextHandler;
import org.apache.commons.jxpath.servlet.ServletRequestAndContext;
import org.apache.commons.jxpath.servlet.ServletRequestHandler;

public final class JXPathServletContexts {
    private static JXPathContextFactory factory;

    static {
        JXPathIntrospector.registerDynamicClass(PageScopeContext.class, PageScopeContextHandler.class);
        JXPathIntrospector.registerDynamicClass(PageContext.class, PageContextHandler.class);
        JXPathIntrospector.registerDynamicClass(ServletContext.class, ServletContextHandler.class);
        JXPathIntrospector.registerDynamicClass(ServletRequestAndContext.class, ServletRequestHandler.class);
        JXPathIntrospector.registerDynamicClass(HttpSessionAndServletContext.class, HttpSessionHandler.class);
        factory = JXPathContextFactory.newInstance();
    }

    public static JXPathContext getPageContext(PageContext pageContext) {
        JXPathContext context = (JXPathContext)pageContext.getAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT");
        if (context == null) {
            JXPathContext parentContext = JXPathServletContexts.getRequestContext(pageContext.getRequest(), pageContext.getServletContext());
            context = factory.newContext(parentContext, pageContext);
            context.setVariables(new KeywordVariables("page", new PageScopeContext(pageContext)));
            pageContext.setAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT", (Object)context);
        }
        return context;
    }

    public static JXPathContext getRequestContext(ServletRequest request, ServletContext servletContext) {
        ServletRequestAndContext handle;
        JXPathContext context = (JXPathContext)request.getAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT");
        if (context != null && (handle = (ServletRequestAndContext)context.getContextBean()).getServletRequest() == request) {
            return context;
        }
        JXPathContext parentContext = null;
        if (request instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            parentContext = session != null ? JXPathServletContexts.getSessionContext(session, servletContext) : JXPathServletContexts.getApplicationContext(servletContext);
        }
        ServletRequestAndContext handle2 = new ServletRequestAndContext(request, servletContext);
        context = factory.newContext(parentContext, handle2);
        context.setVariables(new KeywordVariables("request", handle2));
        request.setAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT", (Object)context);
        return context;
    }

    public static JXPathContext getSessionContext(HttpSession session, ServletContext servletContext) {
        JXPathContext context = (JXPathContext)session.getAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT");
        if (context == null) {
            JXPathContext parentContext = JXPathServletContexts.getApplicationContext(servletContext);
            HttpSessionAndServletContext handle = new HttpSessionAndServletContext(session, servletContext);
            context = factory.newContext(parentContext, handle);
            context.setVariables(new KeywordVariables("session", handle));
            session.setAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT", (Object)context);
        }
        return context;
    }

    public static JXPathContext getApplicationContext(ServletContext servletContext) {
        JXPathContext context = (JXPathContext)servletContext.getAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT");
        if (context == null) {
            context = factory.newContext(null, servletContext);
            context.setVariables(new KeywordVariables("application", servletContext));
            servletContext.setAttribute("org.apache.commons.jxpath.JXPATH_CONTEXT", (Object)context);
        }
        return context;
    }
}

