/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.event;

import java.util.Hashtable;
import org.apache.bsf.util.event.generator.EventAdapterGenerator;

public class EventAdapterRegistry {
    private static Hashtable reg = new Hashtable();
    private static ClassLoader cl = null;
    private static String adapterPackage = "org.apache.bsf.util.event.adapters";
    private static String adapterSuffix = "Adapter";
    private static boolean dynamic = true;

    public static Class lookup(Class listenerType) {
        String key = listenerType.getName().replace('.', '_');
        Class<Object> adapterClass = (Class<Object>)reg.get(key);
        if (adapterClass == null) {
            block4: {
                String en = key.substring(0, key.lastIndexOf("Listener"));
                String cn = String.valueOf(adapterPackage) + "." + en + adapterSuffix;
                try {
                    adapterClass = cl != null ? cl.loadClass(cn) : Thread.currentThread().getContextClassLoader().loadClass(cn);
                }
                catch (ClassNotFoundException e) {
                    if (!dynamic) break block4;
                    adapterClass = EventAdapterGenerator.makeEventAdapterClass(listenerType, false);
                }
            }
            if (adapterClass != null) {
                reg.put(key, adapterClass);
            }
        }
        return adapterClass;
    }

    public static void register(Class listenerType, Class eventAdapterClass) {
        String key = listenerType.getName().replace('.', '_');
        reg.put(key, eventAdapterClass);
    }

    public static void setClassLoader(ClassLoader cloader) {
        cl = cloader;
    }

    public static void setDynamic(boolean dynamic) {
        EventAdapterRegistry.dynamic = dynamic;
    }
}

