/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils {
    private static Log logger = LogFactory.getLog(JavaUtils.class.getName());

    public static boolean JDKcompile(String fileName, String classPath) {
        String option = logger.isDebugEnabled() ? "-g" : "-O";
        String[] args = new String[]{"javac", option, "-classpath", classPath, fileName};
        logger.debug("JavaEngine: Compiling " + fileName);
        logger.debug("JavaEngine: Classpath is " + classPath);
        try {
            Process p = Runtime.getRuntime().exec(args);
            p.waitFor();
            return p.exitValue() != 0;
        }
        catch (IOException e) {
            logger.error("ERROR: IO exception during exec(javac).", e);
        }
        catch (SecurityException e) {
            logger.error("ERROR: Unable to create subprocess to exec(javac).", e);
        }
        catch (InterruptedException e) {
            logger.error("ERROR: Wait for exec(javac) was interrupted.", e);
        }
        return false;
    }
}

