/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.bsf.util.ObjInfo;
import org.apache.bsf.util.ScriptSymbolTable;
import org.apache.bsf.util.StringUtils;
import org.apache.bsf.util.cf.CodeFormatter;

public class CodeBuffer {
    private StringWriter fieldDeclSW = new StringWriter();
    private StringWriter methodDeclSW = new StringWriter();
    private StringWriter initializerSW = new StringWriter();
    private StringWriter constructorSW = new StringWriter();
    private StringWriter serviceMethodSW = new StringWriter();
    private PrintWriter fieldDeclPW = new PrintWriter(this.fieldDeclSW);
    private PrintWriter methodDeclPW = new PrintWriter(this.methodDeclSW);
    private PrintWriter initializerPW = new PrintWriter(this.initializerSW);
    private PrintWriter constructorPW = new PrintWriter(this.constructorSW);
    private PrintWriter serviceMethodPW = new PrintWriter(this.serviceMethodSW);
    private Stack symbolTableStack = new Stack();
    private Hashtable symbolTable = new Hashtable();
    private Hashtable usedSymbolIndices = new Hashtable();
    private ObjInfo finalStatementInfo;
    private CodeBuffer parent;
    private Vector imports;
    private Vector constructorArguments;
    private Vector constructorExceptions;
    private Vector serviceMethodExceptions;
    private Vector implementsVector;
    private String packageName;
    private String className;
    private String serviceMethodName;
    private String extendsName;
    private Class serviceMethodReturnType;

    public CodeBuffer() {
        this.symbolTableStack.push(this.symbolTable);
        this.imports = new Vector();
        this.constructorArguments = new Vector();
        this.constructorExceptions = new Vector();
        this.serviceMethodExceptions = new Vector();
        this.implementsVector = new Vector();
        this.packageName = null;
        this.className = "Test";
        this.serviceMethodName = "exec";
        this.extendsName = null;
        this.serviceMethodReturnType = Void.TYPE;
    }

    public CodeBuffer(CodeBuffer parent) {
        this.symbolTableStack.push(this.symbolTable);
        this.imports = new Vector();
        this.constructorArguments = new Vector();
        this.constructorExceptions = new Vector();
        this.serviceMethodExceptions = new Vector();
        this.implementsVector = new Vector();
        this.packageName = null;
        this.className = "Test";
        this.serviceMethodName = "exec";
        this.extendsName = null;
        this.serviceMethodReturnType = Void.TYPE;
        this.parent = parent;
    }

    public void addConstructorArgument(ObjInfo arg) {
        this.constructorArguments.addElement(arg);
    }

    public void addConstructorException(String exceptionName) {
        if (!this.constructorExceptions.contains(exceptionName)) {
            this.constructorExceptions.addElement(exceptionName);
        }
    }

    public void addConstructorStatement(String statement) {
        this.constructorPW.println(statement);
    }

    public void addFieldDeclaration(String statement) {
        this.fieldDeclPW.println(statement);
    }

    public void addImplements(String importName) {
        if (!this.implementsVector.contains(importName)) {
            this.implementsVector.addElement(importName);
        }
    }

    public void addImport(String importName) {
        if (!this.imports.contains(importName)) {
            this.imports.addElement(importName);
        }
    }

    public void addInitializerStatement(String statement) {
        this.initializerPW.println(statement);
    }

    public void addMethodDeclaration(String statement) {
        this.methodDeclPW.println(statement);
    }

    public void addServiceMethodException(String exceptionName) {
        if (!this.serviceMethodExceptions.contains(exceptionName)) {
            this.serviceMethodExceptions.addElement(exceptionName);
        }
    }

    public void addServiceMethodStatement(String statement) {
        this.serviceMethodPW.println(statement);
    }

    private void appendIfNecessary(PrintWriter pw, StringBuffer buf) {
        if (buf.length() > 0) {
            pw.print(buf.toString());
        }
    }

    public String buildNewSymbol(String prefix) {
        Integer nextNum = this.getSymbolIndex(prefix);
        if (nextNum == null) {
            nextNum = new Integer(0);
        }
        int iNextNum = nextNum;
        String symbol = String.valueOf(prefix) + "_" + iNextNum;
        while (this.getSymbol(symbol) != null) {
            symbol = String.valueOf(prefix) + "_" + ++iNextNum;
        }
        this.putSymbolIndex(prefix, new Integer(iNextNum + 1));
        return symbol;
    }

    public void clearSymbolTable() {
        this.symbolTable = new Hashtable();
        this.symbolTableStack = new Stack();
        this.symbolTableStack.push(this.symbolTable);
        this.usedSymbolIndices = new Hashtable();
    }

    public String getClassName() {
        return this.className;
    }

    public Vector getConstructorArguments() {
        return this.constructorArguments;
    }

    public StringBuffer getConstructorBuffer() {
        this.constructorPW.flush();
        return this.constructorSW.getBuffer();
    }

    public Vector getConstructorExceptions() {
        return this.constructorExceptions;
    }

    public String getExtends() {
        return this.extendsName;
    }

    public StringBuffer getFieldBuffer() {
        this.fieldDeclPW.flush();
        return this.fieldDeclSW.getBuffer();
    }

    public ObjInfo getFinalServiceMethodStatement() {
        return this.finalStatementInfo;
    }

    public Vector getImplements() {
        return this.implementsVector;
    }

    public Vector getImports() {
        return this.imports;
    }

    public StringBuffer getInitializerBuffer() {
        this.initializerPW.flush();
        return this.initializerSW.getBuffer();
    }

    public StringBuffer getMethodBuffer() {
        this.methodDeclPW.flush();
        return this.methodDeclSW.getBuffer();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public StringBuffer getServiceMethodBuffer() {
        this.serviceMethodPW.flush();
        return this.serviceMethodSW.getBuffer();
    }

    public Vector getServiceMethodExceptions() {
        return this.serviceMethodExceptions;
    }

    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public Class getServiceMethodReturnType() {
        if (this.finalStatementInfo != null) {
            return this.finalStatementInfo.objClass;
        }
        if (this.serviceMethodReturnType != null) {
            return this.serviceMethodReturnType;
        }
        return Void.TYPE;
    }

    public ObjInfo getSymbol(String symbol) {
        ObjInfo ret = (ObjInfo)this.symbolTable.get(symbol);
        if (ret == null && this.parent != null) {
            ret = this.parent.getSymbol(symbol);
        }
        return ret;
    }

    Integer getSymbolIndex(String prefix) {
        if (this.parent != null) {
            return this.parent.getSymbolIndex(prefix);
        }
        return (Integer)this.usedSymbolIndices.get(prefix);
    }

    public Hashtable getSymbolTable() {
        return this.symbolTable;
    }

    public void merge(CodeBuffer otherCB) {
        Vector otherImports = otherCB.getImports();
        int i = 0;
        while (i < otherImports.size()) {
            this.addImport((String)otherImports.elementAt(i));
            ++i;
        }
        this.appendIfNecessary(this.fieldDeclPW, otherCB.getFieldBuffer());
        this.appendIfNecessary(this.methodDeclPW, otherCB.getMethodBuffer());
        this.appendIfNecessary(this.initializerPW, otherCB.getInitializerBuffer());
        this.appendIfNecessary(this.constructorPW, otherCB.getConstructorBuffer());
        this.appendIfNecessary(this.serviceMethodPW, otherCB.getServiceMethodBuffer());
        ObjInfo oldRet = this.getFinalServiceMethodStatement();
        if (oldRet != null && oldRet.isExecutable()) {
            this.addServiceMethodStatement(String.valueOf(oldRet.objName) + ";");
        }
        this.setFinalServiceMethodStatement(otherCB.getFinalServiceMethodStatement());
    }

    public void popSymbolTable() {
        this.symbolTableStack.pop();
        this.symbolTable = (Hashtable)this.symbolTableStack.peek();
    }

    public void print(PrintWriter out, boolean formatOutput) {
        if (formatOutput) {
            new CodeFormatter().formatCode(new StringReader(this.toString()), out);
        } else {
            out.print(this.toString());
        }
        out.flush();
    }

    public void pushSymbolTable() {
        this.symbolTable = this.symbolTableStack.push(new ScriptSymbolTable(this.symbolTable));
    }

    public void putSymbol(String symbol, ObjInfo obj) {
        this.symbolTable.put(symbol, obj);
    }

    void putSymbolIndex(String prefix, Integer index) {
        if (this.parent != null) {
            this.parent.putSymbolIndex(prefix, index);
        } else {
            this.usedSymbolIndices.put(prefix, index);
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setExtends(String extendsName) {
        this.extendsName = extendsName;
    }

    public void setFinalServiceMethodStatement(ObjInfo finalStatementInfo) {
        this.finalStatementInfo = finalStatementInfo;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setServiceMethodName(String serviceMethodName) {
        this.serviceMethodName = serviceMethodName;
    }

    public void setServiceMethodReturnType(Class serviceMethodReturnType) {
        this.serviceMethodReturnType = serviceMethodReturnType;
    }

    public void setSymbolTable(Hashtable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public boolean symbolTableIsStacked() {
        return this.symbolTable instanceof ScriptSymbolTable;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ObjInfo ret = this.finalStatementInfo;
        if (this.packageName != null && !this.packageName.equals("")) {
            pw.println("package " + this.packageName + ";");
            pw.println();
        }
        if (this.imports.size() > 0) {
            int i = 0;
            while (i < this.imports.size()) {
                pw.println("import " + this.imports.elementAt(i) + ";");
                ++i;
            }
            pw.println();
        }
        pw.println("public class " + this.className + (this.extendsName != null && !this.extendsName.equals("") ? " extends " + this.extendsName : "") + (this.implementsVector.size() > 0 ? " implements " + StringUtils.getCommaListFromVector(this.implementsVector) : ""));
        pw.println("{");
        pw.print(this.getFieldBuffer().toString());
        StringBuffer buf = this.getInitializerBuffer();
        if (buf.length() > 0) {
            pw.println();
            pw.println("{");
            pw.print(buf.toString());
            pw.println("}");
        }
        if ((buf = this.getConstructorBuffer()).length() > 0) {
            pw.println();
            pw.println("public " + this.className + "(" + (this.constructorArguments.size() > 0 ? StringUtils.getCommaListFromVector(this.constructorArguments) : "") + ")" + (this.constructorExceptions.size() > 0 ? " throws " + StringUtils.getCommaListFromVector(this.constructorExceptions) : ""));
            pw.println("{");
            pw.print(buf.toString());
            pw.println("}");
        }
        if ((buf = this.getServiceMethodBuffer()).length() > 0 || ret != null) {
            pw.println();
            pw.println("public " + StringUtils.getClassName(this.getServiceMethodReturnType()) + " " + this.serviceMethodName + "()" + (this.serviceMethodExceptions.size() > 0 ? " throws " + StringUtils.getCommaListFromVector(this.serviceMethodExceptions) : ""));
            pw.println("{");
            pw.print(buf.toString());
            if (ret != null) {
                if (ret.isValueReturning()) {
                    pw.println();
                    pw.println("return " + ret.objName + ";");
                } else if (ret.isExecutable()) {
                    pw.println(String.valueOf(ret.objName) + ";");
                }
            }
            pw.println("}");
        }
        pw.print(this.getMethodBuffer().toString());
        pw.println("}");
        pw.flush();
        return sw.toString();
    }
}

