/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleExports
implements Cloneable,
Node {
    private final int exports_index;
    private final int exports_flags;
    private final int exports_to_count;
    private final int[] exports_to_index;

    ModuleExports(DataInput file) throws IOException {
        this.exports_index = file.readUnsignedShort();
        this.exports_flags = file.readUnsignedShort();
        this.exports_to_count = file.readUnsignedShort();
        this.exports_to_index = new int[this.exports_to_count];
        int i = 0;
        while (i < this.exports_to_count) {
            this.exports_to_index[i] = file.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleExports(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.exports_index);
        file.writeShort(this.exports_flags);
        file.writeShort(this.exports_to_count);
        int[] nArray = this.exports_to_index;
        int n = this.exports_to_index.length;
        int n2 = 0;
        while (n2 < n) {
            int entry = nArray[n2];
            file.writeShort(entry);
            ++n2;
        }
    }

    public String toString() {
        return "exports(" + this.exports_index + ", " + this.exports_flags + ", " + this.exports_to_count + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.exports_index, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.exports_flags));
        buf.append(", to(").append(this.exports_to_count).append("):\n");
        int[] nArray = this.exports_to_index;
        int n = this.exports_to_index.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleExports copy() {
        try {
            return (ModuleExports)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

