/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.barcode;

import ext.base.log.BcLogUtil;
import nlc.lib.barcode.DcfAbstractBarcodeContext;

public class DcfNw7Context
extends DcfAbstractBarcodeContext {
    private static final long serialVersionUID = 166891824772679852L;
    public static final char START_a = 'a';
    public static final char START_b = 'b';
    public static final char START_c = 'c';
    public static final char START_d = 'd';
    public static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '$', '/', ':', '+', '.', 'a', 'b', 'c', 'd'};
    public double narowBarWidth = 0.25;
    public double widwBarWidth = 0.625;
    public double barHeight = 6.0;
    public double characterGap = this.widwBarWidth;
    public char startCode;
    public char stopCode;
    public int fontSize = 9;

    public String createBarcodeData(String value, char starCode) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(starCode);
        sb.append(value);
        sb.append(this.stopCode);
        return sb.toString();
    }

    public static int calcCheckDigit(String value, String wheight) throws Exception {
        int sum = 0;
        int i = 0;
        while (i < value.length()) {
            int valueInt = Integer.parseInt(Character.toString(value.charAt(i)));
            int waitInt = Integer.parseInt(Character.toString(wheight.charAt(i)));
            sum += valueInt * waitInt;
            ++i;
        }
        int checkDigit = sum % 7;
        return checkDigit;
    }

    public static void main(String[] args) throws Exception {
        DcfNw7Context nw7Context = new DcfNw7Context();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            ++i;
        }
        String value = "11223344556";
        String wheight = "46231546231";
        int checkDigit = DcfNw7Context.calcCheckDigit(value, wheight);
        String barcodeData = nw7Context.createBarcodeData(value, 'a');
        BcLogUtil.debug("barcodeData=" + barcodeData);
    }
}

