/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.swg;

import ext.base.core.BcNumberUtil;
import ext.base.mmd.MmdField;
import ext.base.runtime.BcRuntimeContext;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcWords;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgDialog;
import ext.lib.swg.SwgImagePanel;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JScrollPane;

public class JswgJvmInformationPanel
extends SwgDecoratePanel
implements Runnable {
    private static final long serialVersionUID = -8504877499095534640L;
    protected BcRuntimeContext sysInfo;
    protected Thread thread;
    protected BcTableModel tableModel;
    protected SwgTableView tableView;
    protected final int itemColumnIndex = 0;
    protected final int valueColumnIndex = 1;
    protected int totalMemoryRowId = -1;
    protected Window window;
    private static final String defaultValue = "\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u3088\u308a\u53d6\u5f97\u4e0d\u53ef";

    public JswgJvmInformationPanel() throws Exception {
        this.setBorderSize(10, 40, 0, 0);
    }

    public void init(BcRuntimeContext runtimeContext) throws Exception {
        this.sysInfo = runtimeContext;
        SwgImagePanel imagePanel = new SwgImagePanel();
        imagePanel.setImage(this.getClass().getResource("images/jctop.gif"));
        imagePanel.setPreferredSize(new Dimension(10, 100));
        this.add((Component)imagePanel, "North");
        this.tableModel = JswgJvmInformationPanel.cretaeRuntimeInfoTable(runtimeContext.getSystemProperties());
        BcTableColumnModel tableColumnModel = this.tableModel.getTableColumnModel();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            String value = (String)this.tableModel.getValueAt(i, 0);
            if (value.equals("total memory")) {
                this.totalMemoryRowId = i;
                break;
            }
            ++i;
        }
        this.setCancelButton(BcWords.getInstance().ok);
        this.tableView = new SwgTableView(this.tableModel, tableColumnModel);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)new JScrollPane(this.tableView), "Center");
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    String totalMemoryByte = BcNumberUtil.toString(Runtime.getRuntime().totalMemory());
                    String totalMemoryMB = BcNumberUtil.toString((int)((double)Runtime.getRuntime().totalMemory() / Math.pow(1024.0, 2.0)));
                    String freeMemoryByte = BcNumberUtil.toString(Runtime.getRuntime().freeMemory());
                    String freeMemoryMB = BcNumberUtil.toString((int)((double)Runtime.getRuntime().freeMemory() / Math.pow(1024.0, 2.0)));
                    this.tableModel.setValueAt(String.valueOf(totalMemoryByte) + " byte (" + totalMemoryMB + " MB)", this.totalMemoryRowId, 1);
                    this.tableModel.setValueAt(String.valueOf(freeMemoryByte) + " byte (" + freeMemoryMB + " MB)", this.totalMemoryRowId + 1, 1);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
    }

    @Override
    public void cancelButtonAction() throws Exception {
        super.cancelButtonAction();
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsDialog(Component ownerCompo, BcRuntimeContext sysInfo) throws Exception {
        this.init(sysInfo);
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        this.window = dialog;
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    JswgJvmInformationPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    JswgJvmInformationPanel.this.handleException(ex);
                }
            }
        });
        dialog.setTitle("Java \u5b9f\u884c\u74b0\u5883\u60c5\u5831");
        SwgUtil.setCenter(dialog, 780.0, 540.0);
        dialog.setVisible(true);
    }

    public static BcTableModel cretaeRuntimeInfoTable(Properties sysProps) {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        JswgJvmInformationPanel.createTableColumn(tableColumnModel);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        JswgJvmInformationPanel.createTableRow(sysProps, tableModel);
        return tableModel;
    }

    protected static void createTableColumn(BcTableColumnModel tableColumnModel) {
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn(tableColumnModel.getColumnCount());
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.columnCount = 28;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("\u9805\u76ee");
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn(tableColumnModel.getColumnCount());
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.columnCount = 48;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("\u5024");
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
    }

    protected static void createTableRow(Properties sysProps, BcTableModel tableModel) {
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.version"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vendor"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vendor.url"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.home"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vm.specification.name"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vm.specification.version"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vm.specification.vendor"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vm.name"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vm.version"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.vm.vendor"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.specification.name"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.specification.version"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.specification.vendor"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.class.version"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.class.path"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.library.path"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.io.tmpdir"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.compiler"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "java.ext.dirs"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "os.name"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "os.version"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "os.arch"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "file.separator"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "file.encoding"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "path.separator"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "line.separator"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "user.name"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "user.home"));
        tableModel.addRow(JswgJvmInformationPanel.getRowValueVector(sysProps, "user.dir"));
        Vector<String> valVec = new Vector<String>();
        valVec.add("total memory");
        valVec.add("");
        tableModel.addRow(valVec);
        valVec = new Vector();
        valVec.add("free memory");
        valVec.add("");
        tableModel.addRow(valVec);
    }

    protected static Vector getRowValueVector(Properties sysProps, String key) {
        Properties nameProps = JswgJvmInformationPanel.createNameProperties();
        Vector<String> valVec = new Vector<String>();
        valVec.add(nameProps.getProperty(key));
        valVec.add(sysProps.getProperty(key, defaultValue));
        return valVec;
    }

    protected static Properties createNameProperties() {
        Properties nameJpProps = new Properties();
        nameJpProps.setProperty("java.version", "Java Runtime Environment \u306e\u30d0\u30fc\u30b8\u30e7\u30f3");
        nameJpProps.setProperty("java.vendor", "Java Runtime Environment \u306e\u30d9\u30f3\u30c0\u30fc");
        nameJpProps.setProperty("java.vendor.url", "Java \u30d9\u30f3\u30c0\u30fc\u306e URL");
        nameJpProps.setProperty("java.home", "Java \u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        nameJpProps.setProperty("java.vm.specification.version", "Java Virtual Machine \u306e\u4ed5\u69d8\u30d0\u30fc\u30b8\u30e7\u30f3");
        nameJpProps.setProperty("java.vm.specification.vendor", "Java Virtual Machine \u306e\u4ed5\u69d8\u306e\u30d9\u30f3\u30c0\u30fc");
        nameJpProps.setProperty("java.vm.specification.name", "Java Virtual Machine \u306e\u4ed5\u69d8\u540d");
        nameJpProps.setProperty("java.vm.version", "Java Virtual Machine \u306e\u5b9f\u88c5\u30d0\u30fc\u30b8\u30e7\u30f3");
        nameJpProps.setProperty("java.vm.vendor", "Java Virtual Machine \u306e\u5b9f\u88c5\u306e\u30d9\u30f3\u30c0\u30fc");
        nameJpProps.setProperty("java.vm.name", "Java Virtual Machine \u306e\u5b9f\u88c5\u540d");
        nameJpProps.setProperty("java.specification.version", "Java Runtime Environment \u306e\u4ed5\u69d8\u30d0\u30fc\u30b8\u30e7\u30f3");
        nameJpProps.setProperty("java.specification.vendor", "Java Runtime Environment \u306e\u4ed5\u69d8\u306e\u30d9\u30f3\u30c0\u30fc");
        nameJpProps.setProperty("java.specification.name", "Java Runtime Environment \u306e\u4ed5\u69d8\u540d");
        nameJpProps.setProperty("java.class.version", "Java \u30af\u30e9\u30b9\u306e\u5f62\u5f0f\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7");
        nameJpProps.setProperty("java.class.path", "Java \u30af\u30e9\u30b9\u30d1\u30b9");
        nameJpProps.setProperty("java.library.path", "Java \u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u30ed\u30fc\u30c9\u6642\u306b\u691c\u7d22\u3059\u308b\u30d1\u30b9\u306e\u30ea\u30b9\u30c8");
        nameJpProps.setProperty("java.io.tmpdir", "\u30c7\u30d5\u30a9\u30eb\u30c8\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9");
        nameJpProps.setProperty("java.compiler", "\u4f7f\u7528\u3059\u308b JIT \u30b3\u30f3\u30d1\u30a4\u30e9\u306e\u540d\u524d");
        nameJpProps.setProperty("java.ext.dirs", "\u62e1\u5f35\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d1\u30b9");
        nameJpProps.setProperty("os.name", "\u30aa\u30da\u30ec\u30fc\u30c6\u30a3\u30f3\u30b0\u30b7\u30b9\u30c6\u30e0\u540d");
        nameJpProps.setProperty("os.arch", "\u30aa\u30da\u30ec\u30fc\u30c6\u30a3\u30f3\u30b0\u30b7\u30b9\u30c6\u30e0\u306e\u30a2\u30fc\u30ad\u30c6\u30af\u30c1\u30e3");
        nameJpProps.setProperty("os.version", "\u30aa\u30da\u30ec\u30fc\u30c6\u30a3\u30f3\u30b0\u30b7\u30b9\u30c6\u30e0\u306e\u30d0\u30fc\u30b8\u30e7\u30f3");
        nameJpProps.setProperty("file.separator", "\u30d5\u30a1\u30a4\u30eb\u533a\u5207\u308a\u6587\u5b57 (UNIX \u3067\u306f '/')");
        nameJpProps.setProperty("file.encoding", "\u30d5\u30a1\u30a4\u30eb\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0");
        nameJpProps.setProperty("path.separator", "\u30d1\u30b9\u533a\u5207\u308a\u6587\u5b57 (UNIX \u3067\u306f ':')");
        nameJpProps.setProperty("line.separator", "\u884c\u533a\u5207\u308a\u6587\u5b57 (UNIX \u3067\u306f '\\n')");
        nameJpProps.setProperty("user.name", "\u30e6\u30fc\u30b6\u306e\u30a2\u30ab\u30a6\u30f3\u30c8\u540d");
        nameJpProps.setProperty("user.home", "\u30e6\u30fc\u30b6\u306e\u30db\u30fc\u30e0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        nameJpProps.setProperty("user.dir", "\u30e6\u30fc\u30b6\u306e\u73fe\u5728\u306e\u4f5c\u696d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        return nameJpProps;
    }
}

