/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.server;

import ext.base.charset.BcUtf8Util;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.poi.PoiAbstractCsvWriter;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.util.List;

public class ApcmCsvWriterForDb
extends PoiAbstractCsvWriter {
    protected void outputHeader(Writer writer, ResultSetMetaData rsmd, List<BcTableColumn> tableColumnList) throws Exception {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            int idx = i + 1;
            String value = rsmd.getColumnName(idx);
            if (i > 0) {
                this.output(writer, this.exportCondition.fieldSeparator);
            }
            this.outputValue(writer, value, tableColumn.getMmdField());
            ++i;
        }
        this.output(writer, this.exportCondition.lineSeparator);
    }

    protected long outputRows(Writer writer, SqlResultSet rs, List<BcTableColumn> tableColumnList) throws Exception {
        long rowCount = 0L;
        while (rs.next()) {
            if (rowCount > 0L) {
                this.output(writer, this.exportCondition.lineSeparator);
            }
            ++rowCount;
            this.outputRow(writer, rs, tableColumnList);
        }
        if (this.exportCondition.lineSeparatorLast) {
            this.output(writer, this.exportCondition.lineSeparator);
        }
        return rowCount;
    }

    protected void outputRow(Writer writer, SqlResultSet rs, List<BcTableColumn> tableColumnList) throws Exception {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            int idx = i + 1;
            Object value = rs.getObject(idx);
            String strValue = BcStringUtil.toString(value);
            if (i > 0) {
                this.output(writer, this.exportCondition.fieldSeparator);
            }
            this.outputValue(writer, strValue, tableColumn.getMmdField());
            ++i;
        }
    }

    public long output(DtsSession dtsSession, String sql, Writer writer) throws Exception {
        BcLogUtil.debug("output:sql=" + sql);
        long rowCount = 0L;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd);
            if (this.exportCondition.headerEnabled) {
                this.outputHeader(writer, rsmd, tableColumnList);
            }
            rowCount = this.outputRows(writer, rs, tableColumnList);
            rs.close();
        }
        return rowCount;
    }

    public long output(DtsSession dtsSession, String sql, File destFile) throws Exception {
        BcLogUtil.info("\u51fa\u529b\u5148=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        long rowCount = 0L;
        Throwable throwable = null;
        Object var7_7 = null;
        try (FileOutputStream os = new FileOutputStream(destFile, false);){
            if (BcStringUtil.equalsIgnoreCase(this.exportCondition.encoding, "UTF-8") && this.exportCondition.bomEnabled) {
                os.write(BcUtf8Util.bomBytes);
            }
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, this.exportCondition.encoding);){
                rowCount = this.output(dtsSession, sql, writer);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return rowCount;
    }
}

