/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.client;

import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableModel;
import ext.base.thread.BcMonitor;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgTableViewUtil;
import ext.scf4.client.ScfOnlineTableModel;
import ext.scf6.client.RmiAbstractTableLoader;
import ext.scf6.client.RmiTableLoadEventHandler;
import java.util.List;

public class RmiTableLoader
extends RmiAbstractTableLoader
implements RmiTableLoadEventHandler {
    protected BcTableModel tableModel;
    protected BcTableColumnModel tableColumnModel;
    protected BcTableContext tableContext;

    public RmiTableLoader(RmiAgent agent) throws Exception {
        super(agent);
        this.agent = agent;
        this.setPriority(5);
        this.addTableLoadEventHandler(this);
    }

    public synchronized void loadTable(BcTableModel tableModel, BcTableColumnModel tableColumnModel, BcTableContext tableContext, RmiRequest rmiReq, BcMonitor parentMonitor) throws Exception {
        this.tableModel = tableModel;
        this.tableColumnModel = tableColumnModel;
        this.tableContext = tableContext;
        this.rmiReq = rmiReq;
        this.parentMonitor = parentMonitor;
        this.startLoad();
    }

    public synchronized void loadTable(BcTableModel tableModel, BcTableColumnModel tableColumnModel, BcTableContext tableContext, RmiRequest rmiReq) throws Exception {
        this.loadTable(tableModel, tableColumnModel, tableContext, rmiReq, null);
    }

    public synchronized void loadTable(BcTableModel tableModel, BcTableContext tableContext, RmiRequest rmiReq, BcMonitor parentMonitor) throws Exception {
        this.loadTable(tableModel, tableModel.getTableColumnModel(), tableContext, rmiReq, parentMonitor);
    }

    public synchronized void loadTable(BcTableModel tableModel, BcTableContext tableContext, RmiRequest rmiReq) throws Exception {
        this.loadTable(tableModel, tableContext, rmiReq, null);
    }

    public synchronized void loadTable(BcTableModel tableModel, RmiRequest rmiReq, BcMonitor parentMonitor) throws Exception {
        this.loadTable(tableModel, null, rmiReq, parentMonitor);
    }

    public synchronized void loadTable(BcTableModel tableModel, RmiRequest rmiReq) throws Exception {
        this.loadTable(tableModel, rmiReq, null);
    }

    @Override
    public void createTableColumnModel(List<BcTableColumn> tableColumnList) throws Exception {
        if (this.tableColumnModel == null) {
            this.tableColumnModel = new BcTableColumnModel();
        }
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            this.tableColumnModel.addColumn(tableColumn);
            ++i;
        }
        SwgTableViewUtil.setEditable(this.tableColumnModel, false);
    }

    @Override
    public void tableLoadStarted() throws Exception {
    }

    public void tableColumnListReceived(List<BcTableColumn> tableColumnList) throws Exception {
    }

    @Override
    public void tableColumnModelCreated() throws Exception {
    }

    @Override
    public void tableContextReceived(BcTableContext tableContext) throws Exception {
        if (this.tableContext != null) {
            this.tableContext.title = tableContext.title;
            this.tableContext.tableName = tableContext.tableName;
            this.tableContext.setConditionList(tableContext.getConditionList());
        }
    }

    @Override
    public void rowCountReceived(long rowCount) throws Exception {
        if (ScfOnlineTableModel.class.isAssignableFrom(this.tableModel.getClass())) {
            ScfOnlineTableModel onlineTableModel = (ScfOnlineTableModel)this.tableModel;
            onlineTableModel.setHandleId(this.handleId);
            onlineTableModel.setRowCount((int)rowCount);
        }
    }

    @Override
    public void loadedRowSizeChanged(long rowCount, long loadedRowCount) throws Exception {
    }

    @Override
    public void tableLoadFinished(boolean eod) throws Exception {
    }

    @Override
    protected void addRowList(List<List> rowList) throws Exception {
        this.tableModel.addRowList(rowList);
    }

    @Override
    public void exceptionHandl(Throwable throwable) throws Exception {
    }
}

