/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.dao;

import ext.base.core.BcInteger;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamUtil;
import ext.lib.activation.BcMimeUtil;
import ext.lib.awt.AwtImageUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.orm.persistence.OrmPersistenceUtil;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.scf5.model.ScfFileResource;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ScfAbstractFileResourceDAO
extends OrmAbstractDAO<ScfFileResource> {
    public ScfAbstractFileResourceDAO() {
        super(new ScfFileResource[0]);
    }

    public String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? " ," : " ," + tableAlias + ".";
        String selectColumns = this.getPersistenceProxy().createCommonSelectPhrase(this.getEntityClass(), tableAlias) + asTable2 + "file_name" + asTable2 + "file_extention" + asTable2 + "mime_type" + asTable2 + "image_width" + asTable2 + "image_height" + asTable2 + "resource_attribute_id" + asTable2 + "class_01_id" + asTable2 + "class_02_id" + asTable2 + "note_";
        return selectColumns;
    }

    public void putFileResource(DtsSession dtsSession, ScfFileResource fileResource, InputStream is, int isSize) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        OrmPersistenceUtil.putPreTrans(dtsSession, fileResource, this.tableName);
        String query = "UPDATE " + this.getTableName() + " SET " + this.getPersistenceProxy().createCommonSetPhrase(sqlContext, (Object)fileResource) + ",file_name=" + sqlContext.toSet(fileResource.fileName) + ",file_extention=" + sqlContext.toSet(fileResource.fileExtention) + ",mime_type=" + sqlContext.toSet(fileResource.mimeType) + ",image_width=" + fileResource.imageWidth + ",image_height=" + fileResource.imageHeight + ",resource_attribute_id=" + fileResource.resourceAttributeId + ",class_01_id=" + fileResource.class01Id + ",class_02_id=" + fileResource.class02Id + ",note_=" + sqlContext.toSet(fileResource.note) + " WHERE id = " + fileResource.getDataId();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            int n = stmt.executeUpdate(query);
        }
        if (is != null) {
            String whereClause = "id=" + fileResource.getDataId();
            sqlContext.putBinary(dtsSession.getConnection(), this.tableName, "file_binary", whereClause, is, isSize);
            is.close();
        }
    }

    public void putFileResource(DtsSession dtsSession, ScfFileResource fileResource, InputStream is, String fileName) throws Exception {
        if (is != null) {
            if (!BcStringUtil.isEmpty(fileName)) {
                fileResource.fileName = fileName;
                fileResource.fileExtention = BcFileUtil.getExtention(fileName);
                fileResource.mimeType = BcMimeUtil.getMimeType(fileName);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BcStreamUtil.transmit(is, baos, 1024);
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream is2 = new ByteArrayInputStream(bytes);
            this.putFileResource(dtsSession, fileResource, (InputStream)is2, bytes.length);
        } else {
            this.putFileResource(dtsSession, fileResource, null, 0);
        }
    }

    public void putFileResource(DtsSession dtsSession, ScfFileResource fileResource, File file) throws Exception {
        if (file != null) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            this.putFileResource(dtsSession, fileResource, (InputStream)is, file.getName());
        } else {
            this.putFileResource(dtsSession, fileResource, null, 0);
        }
    }

    public void putImageResource(DtsSession dtsSession, ScfFileResource fileResource, Image srcImage, String fileName) throws Exception {
        fileResource.fileName = fileName;
        fileResource.fileExtention = BcFileUtil.getExtention(fileName);
        fileResource.mimeType = BcMimeUtil.getMimeType(fileName);
        BufferedImage bufferedImage = AwtImageUtil.toBufferedImage(srcImage);
        fileResource.imageWidth = bufferedImage.getWidth();
        fileResource.imageHeight = bufferedImage.getHeight();
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersBySuffix(fileResource.fileExtention);
        if (!imageWriters.hasNext()) {
            throw new Exception("fileExtention=" + fileResource.fileExtention);
        }
        ImageWriter imageWriter = imageWriters.next();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(bufferedImage);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        this.putFileResource(dtsSession, fileResource, (InputStream)byteArrayInputStream, bytes.length);
    }

    public void putImageResource(DtsSession dtsSession, ScfFileResource fileResource, File file) throws Exception {
        String suffix = BcFileUtil.getExtention(file);
        this.putImageResource(dtsSession, fileResource, file, suffix);
    }

    public void putImageResource(DtsSession dtsSession, ScfFileResource fileResource, File file, String suffix) throws Exception {
        if (file != null) {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersBySuffix(suffix);
            if (!imageReaders.hasNext()) {
                throw new Exception("fileExtention=" + BcFileUtil.getExtention(file));
            }
            ImageReader imageReader = imageReaders.next();
            imageReader.setInput(new FileImageInputStream(file));
            BufferedImage srcImage = imageReader.read(0);
            fileResource.imageWidth = srcImage.getWidth();
            fileResource.imageHeight = srcImage.getHeight();
            this.putFileResource(dtsSession, fileResource, file);
        } else {
            this.putFileResource(dtsSession, fileResource, null);
        }
    }

    public void putImageResource(DtsSession dtsSession, ScfFileResource fileResource, InputStream is, String fileName) throws Exception {
        String fileExtention = BcFileUtil.getExtention(fileName);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersBySuffix(fileExtention);
        if (!imageReaders.hasNext()) {
            throw new Exception("no imageReader");
        }
        ImageReader imageReader = imageReaders.next();
        imageReader.setInput(new MemoryCacheImageInputStream(is));
        BufferedImage srcImage = imageReader.read(0);
        this.putImageResource(dtsSession, fileResource, srcImage, fileName);
    }

    public int deleteFileResource(DtsSession dtsSession, int fileResourceId) throws Exception {
        String query = "DELETE FROM " + this.getTableName() + " WHERE id = " + fileResourceId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public int deleteFileResourceByAttributeId(DtsSession dtsSession, int resourceAttributeId) throws Exception {
        String query = "DELETE FROM " + this.getTableName() + " WHERE resource_attribute_id = " + resourceAttributeId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public void getFileResource(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, ScfFileResource fileResource) throws Exception {
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, fileResource);
        fileResource.fileName = rs.getString(columnIndex);
        fileResource.fileExtention = rs.getString(columnIndex);
        fileResource.mimeType = rs.getString(columnIndex);
        fileResource.imageWidth = rs.getInt(columnIndex);
        fileResource.imageHeight = rs.getInt(columnIndex);
        fileResource.resourceAttributeId = rs.getInt(columnIndex);
        fileResource.class01Id = rs.getShort(columnIndex);
        fileResource.class02Id = rs.getShort(columnIndex);
        fileResource.note = rs.getString(columnIndex);
    }

    public ScfFileResource getFileResource(DtsSession dtsSession, String query) throws Exception {
        ScfFileResource fileResource = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                fileResource = new ScfFileResource();
                this.getFileResource(dtsSession, rs, columnIndex, fileResource);
            }
            rs.close();
        }
        return fileResource;
    }

    public ScfFileResource getFileResource(DtsSession dtsSession, long fileResourceId) throws Exception {
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.getTableName() + " WHERE id = " + fileResourceId;
        return this.getFileResource(dtsSession, query);
    }

    public ScfFileResource getFileResourceByFileName(DtsSession dtsSession, String fileName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getSelectColumns01(null) + " FROM " + this.getTableName() + " WHERE file_name" + sqlContext.toCondition_string("=", fileName);
        return this.getFileResource(dtsSession, query);
    }

    public FwBinaryHelper getBinaryInputStream(DtsSession dtsSession, long fileResourceId) throws Exception {
        String query = "SELECT file_binary FROM " + this.getTableName() + " WHERE id = " + fileResourceId;
        FwBinaryHelper binaryHelper = null;
        SqlStatement stmt = dtsSession.getConnection().createStatement();
        SqlResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            binaryHelper = new FwBinaryHelper();
            binaryHelper.stmt = stmt;
            binaryHelper.rs = rs;
            binaryHelper.is = rs.getBinaryStream(1);
        } else {
            rs.close();
            stmt.close();
        }
        return binaryHelper;
    }

    public Image getAsImage(DtsSession dtsSession, long fileResourceId) throws Exception {
        FwBinaryHelper binaryHelper = null;
        BufferedImage bufferedImage = null;
        try {
            binaryHelper = this.getBinaryInputStream(dtsSession, fileResourceId);
            if (binaryHelper == null) {
                return null;
            }
            bufferedImage = ImageIO.read(new BufferedInputStream(binaryHelper.is));
        }
        finally {
            binaryHelper.rs.close();
            binaryHelper.stmt.close();
        }
        return bufferedImage;
    }

    public void getAsByte(DtsSession dtsSession, int fileResourceId, OutputStream os) throws Exception {
        FwBinaryHelper binaryHelper = null;
        try {
            binaryHelper = this.getBinaryInputStream(dtsSession, fileResourceId);
            if (binaryHelper == null) {
                return;
            }
            BcStreamUtil.transmit(binaryHelper.is, os, false, 4096);
        }
        finally {
            binaryHelper.rs.close();
            binaryHelper.stmt.close();
        }
    }

    public byte[] getAsByteArray(DtsSession dtsSession, int fileResourceId) throws Exception {
        byte[] bytes = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.getAsByte(dtsSession, fileResourceId, baos);
            bytes = baos.toByteArray();
        }
        return bytes;
    }

    public class FwBinaryHelper {
        public SqlStatement stmt;
        public SqlResultSet rs;
        public InputStream is;
    }
}

