/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.lib.swg.SwgBorderPanel;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

class HswgTableColumnConfigurePanel
extends SwgBorderPanel {
    protected TableModel tableModel;
    protected SwgTableView tableView;
    protected JScrollPane tableScrollPane = new JScrollPane();
    protected SwgButton selectAllBbutton;
    protected SwgButton releaseAllButton;

    public HswgTableColumnConfigurePanel() throws Exception {
        this.selectAllBbutton = new SwgButton(BcWords.getInstance().selectAll);
        this.releaseAllButton = new SwgButton(BcWords.getInstance().releaseAll);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.tableScrollPane, "Center");
        this.southPanel.setLayout(new FlowLayout(0));
        this.selectAllBbutton.addActionListener(this.actionListener);
        this.southPanel.add(this.selectAllBbutton);
        this.releaseAllButton.addActionListener(this.actionListener);
        this.southPanel.add(this.releaseAllButton);
    }

    public void setDataModel(TableModel tableModel) throws Exception {
        this.tableModel = tableModel;
        this.tableView = new SwgTableView(tableModel, this.createTableColumnModel());
        this.tableScrollPane.getViewport().add(this.tableView);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.selectAllBbutton) {
            SwgTableViewUtil.setValueAllRow(this.tableView, true, 2);
        } else if (ev.getSource() == this.releaseAllButton) {
            SwgTableViewUtil.setValueAllRow(this.tableView, false, 2);
        }
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().columnName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 50;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().displayOrder;
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().visible;
        mmdField.dataClass = Boolean.class;
        mmdField.columnCount = 4;
        mmdField.horizonalAlignment = 0;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }
}

