/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.poi.PoiExportEventHandler;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgProgressBar;
import ext.lib.swg.SwgUtil;
import ext.scf4.swg.HswgExportWizerd;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.table.TableModel;

public class HswgExportProcessiongPanel
extends SwgDecoratePanel
implements PoiExportEventHandler {
    private static final long serialVersionUID = 6912339374123465999L;
    protected HswgExportWizerd exportWizerd;
    protected SwgProgressBar progressBar = new SwgProgressBar();
    long startMillis = -1L;
    protected Window window;

    public HswgExportProcessiongPanel(HswgExportWizerd exportWizerd) throws Exception {
        this.exportWizerd = exportWizerd;
        exportWizerd.csvWriter.addExportEventHandler(this);
        this.setBorderSize(80, 40, 10, 10);
        String msg = BcMessageCreator.getInstance().bindMessage("\u51fa\u529b\u4e2d\u3067\u3059\uff0e\uff0e\uff0e\n \u51fa\u529b\u5148={0}", exportWizerd.destFilePath);
        this.setDescription(msg, 80);
        this.setComponent();
    }

    protected void setComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 120;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, this.progressBar, (double)(c1x + 40), (double)ly, 430.0, (double)rowHeight);
        ly += rowHeight + rowGap;
        ly += rowHeight + rowGap;
    }

    @Override
    public void rowExported(TableModel tableModel, int rowId) throws Exception {
        if (this.startMillis < 0L) {
            this.startMillis = System.currentTimeMillis();
        }
        if (rowId % 10 != 0) {
            return;
        }
        this.progressBar.setMaximum(tableModel.getRowCount());
        int rowCount = rowId + 1;
        this.progressBar.setValue(rowCount);
        double progressPer = (double)rowCount / (double)tableModel.getRowCount() * 100.0;
        long period = System.currentTimeMillis() - this.startMillis;
        double restTime = (double)period / progressPer * (100.0 - progressPer);
        String restTimeStr = BcTimeUtil.getTermString((long)restTime);
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsFrame() throws Exception {
        final SwgFrame frame = new SwgFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setResizable(false);
        frame.setDefaultCloseOperation(0);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ev) {
                try {
                    HswgExportProcessiongPanel.this.exportWizerd.doExport2();
                    String msg = BcMessageCreator.getInstance().bindMessage("\u51fa\u529b\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\n \u51fa\u529b\u5148={0}", HswgExportProcessiongPanel.this.exportWizerd.destFilePath);
                    SwgOptionPane.showMessageDialog(frame, msg, BcWords.getInstance().information, 1);
                    HswgExportProcessiongPanel.this.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    SwgOptionPane.showMessageDialog(frame, ex, BcWords.getInstance().error, 0);
                    HswgExportProcessiongPanel.this.close();
                }
            }
        });
        frame.setTitle(BcWords.getInstance().export);
        frame.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = frame;
        SwgUtil.setCenter(this.window, 580.0, 320.0);
        this.window.setVisible(true);
    }
}

