/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.base.thread.BcMonitor;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.table.FxTableColumn;
import ext.lib.fx.table.FxTableUtil;
import ext.scf3.client.ScfTableLoadTask;
import java.util.Collection;
import java.util.List;
import javafx.scene.control.TableView;

public class HfxTableLoadTask
extends ScfTableLoadTask {
    private TableView tableView;
    private BcTableContext tableContext;
    private BcMonitor monitor = new BcMonitor();

    @Override
    public void tableColumnReceived(ScfTableLoadTask tableLoadTask, final List<BcTableColumn> bcTableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
        super.tableColumnReceived(tableLoadTask, bcTableColumnList, rowSize, tableContext);
        this.monitor.lock();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    List<FxTableColumn> tableColumnList = FxTableUtil.createTableColumnList(bcTableColumnList, null);
                    HfxTableLoadTask.this.tableView.getColumns().addAll(tableColumnList);
                    HfxTableLoadTask.this.monitor.unLock();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.monitor.sync();
        this.tableContext = tableContext;
    }

    @Override
    public void rowListReceived(ScfTableLoadTask tableLoadTask, final List<List> rowList) throws Exception {
        super.rowListReceived(tableLoadTask, rowList);
        this.monitor.lock();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxTableLoadTask.this.tableView.getItems().addAll((Collection)rowList);
                    HfxTableLoadTask.this.monitor.unLock();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.monitor.sync();
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public void setTableView(TableView tableView) {
        this.tableView = tableView;
    }

    public BcTableContext getTableContext() {
        return this.tableContext;
    }
}

