/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableUtil;
import ext.base.util.BcWords;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.table.FxTableViewEvent;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.client.RmiLocalAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.task.TskTaskManager;
import ext.libx.fx.FxxProgressIndicationPane;
import ext.libx.fx.FxxUtil;
import ext.scf.client.ScfClientContainer;
import ext.scf3.client.ScfTableLoadEventHandler;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf3.stub.ScfDatabaseStub;
import ext.scf4.client.ScfStandAloneHelper;
import ext.scf4.fx.HfxTableLoadOnlineTask;
import ext.scf4.fx.HfxTableLoadTask;
import ext.scf4.fx.HfxTablePane;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class HfxLoadableTablePane
extends HfxTablePane
implements ScfTableLoadEventHandler,
FxTableViewEvent {
    protected BcTableColumnModel tableColumnModel;
    protected BcTableContext tableContext;
    private HfxTableLoadTask tableLoadTask;
    private boolean isLocal;
    private boolean isOnLine;
    protected RmiRequest rmiReq;
    protected boolean isRun = false;
    protected boolean visualSaveEnavled = false;
    protected VBox vBox;
    protected FxButton cancelButton;

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isOnLine() {
        return this.isOnLine;
    }

    public void setOnline(boolean isOnLine) {
        this.isOnLine = isOnLine;
    }

    public void doLoad(RmiRequest rmiReq) throws Exception {
        this.rmiReq = rmiReq;
        this.loadPreCommon();
        this.getTableLoadTask().init();
        this.tableLoadTask.setRequest(rmiReq);
        this.tableLoadTask.setTableView(this.getTableView());
        TskTaskManager.getInstance().startTask(this.tableLoadTask);
    }

    protected void loadPreCommon() throws Exception {
        this.isRun = false;
        TableView tableView = this.createTableView();
        this.setTableView(tableView);
    }

    public RmiRequest getRequest() {
        return this.rmiReq;
    }

    protected ScfTableLoadTask getTableLoadTask() throws Exception {
        if (this.tableLoadTask == null) {
            this.tableLoadTask = this.createTableLoadTask();
        }
        return this.tableLoadTask;
    }

    protected HfxTableLoadTask createTableLoadTask() throws Exception {
        RmiLocalAgent localAgent = ScfStandAloneHelper.getInstance().getLocalAgent(ScfClientContainer.getInstance().getAgent(), this.isLocal);
        HfxTableLoadTask tableLoadTask = null;
        if (this.isOnLine()) {
            tableLoadTask = new HfxTableLoadOnlineTask();
            throw new Exception("Not supported online mode.");
        }
        tableLoadTask = new HfxTableLoadTask();
        tableLoadTask.setLocalAgent(localAgent);
        tableLoadTask.getEventListenerList().add(ScfTableLoadEventHandler.class, this);
        return tableLoadTask;
    }

    protected TableView createTableView() throws Exception {
        InnerTableView tableView = new InnerTableView();
        tableView.setItems(FXCollections.observableArrayList());
        return tableView;
    }

    @Override
    public void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        this.isRun = true;
        this.setPogressIndicator();
    }

    @Override
    public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        this.tableColumnModel = BcTableUtil.createTableColumnModel(tableColumnList);
        SwgTableViewUtil.setEditable(this.tableColumnModel, false);
        this.tableContext = tableContext;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxLoadableTablePane.this.setMainContent((Node)HfxLoadableTablePane.this.getTableView());
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        if (tableLoadTask instanceof HfxTableLoadOnlineTask) {
            HfxTableLoadOnlineTask hfxTableLoadOnlineTask = (HfxTableLoadOnlineTask)tableLoadTask;
        }
    }

    @Override
    public void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
    }

    @Override
    public void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
    }

    @Override
    public void loadedRowSizeChanged(ScfTableLoadTask tableLoadTask, int rowCount, int loadedRowCount) throws Exception {
    }

    @Override
    public void generalResultReceived(ScfTableLoadTask tableLoadTask, final Object generalResult) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Region region = FxxUtil.creatRegion(generalResult);
                    HfxLoadableTablePane.this.setMainContent((Node)region);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    @Override
    public void cancelStarted(ScfTableLoadTask tableLoadTask, Object source) throws Exception {
    }

    @Override
    public void canceled(ScfTableLoadTask tableLoadTask) throws Exception {
    }

    @Override
    public void tableLoadError(ScfTableLoadTask tableLoadTask, final Throwable throwable) {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Region exceptionPane = FxxUtil.createExceptionPane(throwable);
                    HfxLoadableTablePane.this.setMainContent((Node)exceptionPane);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected void canceled() throws Exception {
        FxTextArea txetArea = new FxTextArea();
        txetArea.setEditable(false);
        txetArea.setText("Statement was canceled.");
        this.setMainContent((Node)txetArea);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.cancelButton) {
            this.tableLoadTask.cancel(this);
        }
    }

    protected void setPogressIndicator() throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxLoadableTablePane.this.setPogressIndicator_L2();
                }
                catch (Exception ex) {
                    HfxLoadableTablePane.this.handleException(ex);
                }
            }
        });
    }

    protected void setPogressIndicator_L2() throws Exception {
        if (this.vBox != null) {
            this.setMainContent((Node)this.vBox);
            return;
        }
        FxxProgressIndicationPane progressIndicationPane = new FxxProgressIndicationPane();
        this.setPogressIndicator_L3((Pane)progressIndicationPane.vBox);
        this.setMainContent((Node)progressIndicationPane);
    }

    protected void setPogressIndicator_L3(Pane pane) throws Exception {
        FxLabel searchingLabel = new FxLabel(BcWords.getInstance().searching);
        FxUtil.setFont((Node)searchingLabel, FxFontUtil.font_12_black);
        pane.getChildren().addAll((Object[])new Node[]{searchingLabel});
        this.cancelButton = new FxButton(BcWords.getInstance().cancel);
        this.cancelButton.setGraphic((Node)FxImageHelper.createImageView_icon("sign_forbidden_64x64.png"));
        this.cancelButton.setOnAction(this.actionEventHandler);
        pane.getChildren().addAll((Object[])new Node[]{this.cancelButton});
    }

    public void executeQuery(String datasourceName, SqlSelectSql selectSql) throws Exception {
        RmiRequest rmiReq = ScfDatabaseStub.getInstance().generalList(datasourceName, selectSql);
        this.doLoad(rmiReq);
    }

    public void executeQuery(String datasourceName, CharSequence query) throws Exception {
        RmiRequest rmiReq = ScfDatabaseStub.getInstance().generalList(datasourceName, query);
        this.doLoad(rmiReq);
    }

    protected class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            HfxLoadableTablePane.this.rowSelectionChanged(this, rowIdList, prevRowId, nextRowId);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
            HfxLoadableTablePane.this.rowSelected(tableView, tablePositionList, ev, doubleClicked);
        }
    }
}

