/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.client;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.rmi.model.RmiRespons;
import ext.scf.stub.ScfHandleStub;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf3.stub.ScfDatabaseStub;
import ext.scf4.client.ScfOnlineTableModel;
import java.util.List;

public class ScfTableLoadOnlineTask
extends ScfTableLoadTask {
    private ScfOnlineTableModel onlineTableModel;
    private List<Integer> rowNumberList;

    public ScfOnlineTableModel getOnlineTableModel() {
        return this.onlineTableModel;
    }

    public void setOnlineTableModel(ScfOnlineTableModel onlineTableModel) {
        this.onlineTableModel = onlineTableModel;
    }

    public List<Integer> getRowNumberList() {
        return this.rowNumberList;
    }

    @Override
    public Object taskProcess() throws Exception {
        this.status = 2;
        if (this.handleRes == null) {
            this.tableLoadStarted(this);
            RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq1);
            this.setHandleRespons(rmiRes);
        }
        try {
            while (!this.eod) {
                if (this.status != 2) {
                    break;
                }
                this.loadRows();
            }
        }
        finally {
            try {
                ScfHandleStub.getInstance().removeHandle(this.getLocalAgent(), this.handleId);
            }
            finally {
                this.status = 1;
            }
        }
        this.tableLoadFinished(this, this.eod);
        return this.loadedRowSize;
    }

    @Override
    protected void loadRows() throws Exception {
        this.rowNumberList = this.onlineTableModel.getEmptyRowNumberList(this.requireRowCount);
        if (BcCollectionUtil.isEmpty(this.rowNumberList)) {
            this.eod = true;
            return;
        }
        String rowNumbers = BcStringUtil.toCsv(this.rowNumberList).toString();
        List<List> rowList = ScfDatabaseStub.getInstance().getRowByRowNumbers(this.getLocalAgent(), this.handleId, rowNumbers);
        this.rowListReceived(this, rowList);
    }
}

