/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.datasource;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamFilter;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.thread.BcMonitor;
import ext.base.util.BcSortUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.fx.FxPlatform;
import ext.lib.sql.context.SqlContext_Access;
import ext.scf.datasource.RpcsMeasurementModificationPane;
import ext.scf.datasource.Y_BackupContext;
import ext.scf.datasource.Y_ProgressPane;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Y_BackupManager {
    BcLogger logger;
    BcMonitor monitor1;
    BcMonitor monitor2;
    File dataDir;
    File xmlFile;
    File mdbDir;
    File mdbFile;
    File backupDir;
    File storageFile;
    String backupFileExtention = "bak";
    SecretKey secretKey;
    List<Y_BackupContext> backupList;
    boolean restored;
    public static final String TAG_backup = "backup";
    public static final String TAG_backupDir = "backupDir";
    public static final String TAG_datasource = "datasource";
    public static final String TAG_path = "path";
    public static final String TAG_length = "length";
    public static final String TAG_lastModified = "lastModified";
    public static final String TAG_backupTime = "backupTime";

    public void preprocessing(BcLogger logger, BcMonitor monitor) throws Exception {
        logger.info("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u63a5\u7d9a\u306e\u524d\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3057\u305f...");
        this.logger = logger;
        this.monitor1 = monitor;
        monitor.lock();
        this.dataDir = new File(AfbApplication.getInstance().toReal("${DATA_DIR}"));
        String fileName = TAG_backup + BcXmlUtil.EXTENTION_dot_xml;
        this.xmlFile = new File(this.dataDir, fileName);
        if (!this.xmlFile.exists()) {
            monitor.unLock();
            return;
        }
        this.backupList = this.parseXml(this.xmlFile);
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        String dtsUrl = dtsSessionFactory.getConnectionManager().getDtsUrl();
        String mdbPath = SqlContext_Access.extractDBQ(dtsUrl);
        logger.info("MDB\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9=" + mdbPath);
        this.mdbFile = new File(mdbPath);
        this.mdbDir = this.mdbFile.getParentFile();
        this.storageFile = new File(this.backupDir, this.mdbFile.getName());
        logger.info("\u9000\u907f\u30d5\u30a1\u30a4\u30eb=" + this.storageFile.getPath());
        if (!this.storageFile.exists()) {
            throw new Exception("\u9000\u907f\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 " + this.storageFile.getPath());
        }
        if (this.mdbFile.exists()) {
            String baseName = BcFileUtil.getBaseName(this.mdbFile);
            String errFileName = BcFileUtil.createFileName(String.valueOf(baseName) + "_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS(), "err");
            File errFile = new File(this.mdbDir, errFileName);
            BcFileUtil.rename(this.mdbFile, errFile);
        }
        this.backupList = this.checkFileExists(this.backupList);
        if (this.backupList.size() > 0) {
            this.openDialog(this.backupList, this);
        } else {
            this.preprocessing_L2();
        }
    }

    protected void preprocessing_L2() throws Exception {
        if (!this.restored) {
            this.copyFile(this.logger, this.storageFile, this.mdbFile);
        }
        Document xmlDoc = this.createXml(this.backupList);
        BcFileUtil.deleteFile(this.xmlFile);
        BcXmlUtil.output(xmlDoc, this.xmlFile, true);
        this.monitor1.unLock();
    }

    public void postProcessing(BcLogger logger, BcMonitor monitor2) throws Exception {
        if (!this.xmlFile.exists()) {
            monitor2.unLock();
            return;
        }
        logger.info("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u63a5\u7d9a\u306e\u5f8c\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3057\u305f...");
        this.monitor2 = monitor2;
        monitor2.lock();
        if (this.isFileUpdated(this.mdbFile, this.storageFile)) {
            logger.info("MDB\u30d5\u30a1\u30a4\u30eb\u304c\u5909\u66f4\u304c\u3055\u308c\u307e\u3057\u305f\u3002\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
            String baseName = BcFileUtil.getBaseName(this.storageFile);
            String backupFileName = BcFileUtil.createFileName(String.valueOf(baseName) + "_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS(), this.backupFileExtention);
            File backupFile = new File(this.backupDir, backupFileName);
            logger.info("\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb=" + backupFile.getPath());
            BcFileUtil.rename(this.storageFile, backupFile);
            logger.info("MDB\u30d5\u30a1\u30a4\u30eb\u3092\u9000\u907f\u4e2d...");
            this.copyFile(logger, this.mdbFile, this.storageFile);
            logger.info("MDB\u30d5\u30a1\u30a4\u30eb\u306e\u9000\u907f\u3092\u5b8c\u4e86");
        }
        logger.info("MDB\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u4e2d...");
        boolean b = BcFileUtil.deleteFile(this.mdbFile);
        logger.info("MDB\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u7d50\u679c=" + b);
        monitor2.unLock();
    }

    public void copyFile(BcLogger logger, File fromFile, File toFile) throws Exception {
        BcFileUtil.copyFile(fromFile, toFile, 409600);
        logger.debug("copy file finiised.");
    }

    protected Y_BackupContext toBackupContext(File file) throws Exception {
        Y_BackupContext backupContext = new Y_BackupContext();
        backupContext.fileName = file.getName();
        backupContext.length = file.length();
        backupContext.lastModified = file.lastModified();
        backupContext.backupTime = System.currentTimeMillis();
        return backupContext;
    }

    protected boolean isFileUpdated(File file1, File file2) throws Exception {
        boolean isUpdated = BcFileUtil.isSameSizeAndLastModified(file1, file2);
        return isUpdated;
    }

    protected List<Y_BackupContext> parseXml(File xmlFile) throws Exception {
        ArrayList<Y_BackupContext> backupList = new ArrayList<Y_BackupContext>();
        Document lafXml = BcXmlUtil.createDocument(xmlFile);
        this.parseXml(lafXml, backupList);
        BcLogUtil.debug("backupList.size()=" + backupList.size());
        return backupList;
    }

    public void parseXml(Document xmlDoc, List<Y_BackupContext> backupList) throws Exception {
        List<Node> domNodeList1 = BcXmlUtil.getNodeList((Node)xmlDoc, (short)1);
        int i = 0;
        while (i < domNodeList1.size()) {
            Node domNode1 = domNodeList1.get(i);
            if (domNode1.getNodeName().equals(TAG_backupDir)) {
                this.backupDir = new File(BcXmlUtil.getTextValue(domNode1));
                this.logger.debug("\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30c7\u30a3\u30ec\u30af\u30c8\u30ea=" + this.backupDir.getPath());
            } else if (domNode1.getNodeName().equals(TAG_datasource)) {
                Y_BackupContext backupContext = new Y_BackupContext();
                backupContext.fileName = BcXmlUtil.getTextValue(domNode1, TAG_path);
                backupContext.length = BcNumberUtil.parseLong(BcXmlUtil.getTextValue(domNode1, TAG_length), -1L);
                String tmpStr = BcXmlUtil.getTextValue(domNode1, TAG_lastModified);
                backupContext.lastModified = this.parseDateTime(tmpStr);
                tmpStr = BcXmlUtil.getTextValue(domNode1, TAG_backupTime);
                backupContext.backupTime = this.parseDateTime(tmpStr);
                backupList.add(backupContext);
            }
            ++i;
        }
    }

    protected long parseDateTime(String tmpStr) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(tmpStr);
        return calendar.getTimeInMillis();
    }

    protected Document createXml(List<Y_BackupContext> backupList) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDoc = documentBuilder.newDocument();
        Element rootElem = xmlDoc.createElement(TAG_backup);
        xmlDoc.appendChild(rootElem);
        Element backupDirElem = xmlDoc.createElement(TAG_backupDir);
        BcXmlUtil.setTextValue(backupDirElem, this.backupDir.getPath());
        rootElem.appendChild(backupDirElem);
        int i = 0;
        while (i < backupList.size()) {
            Y_BackupContext backup = backupList.get(i);
            Element datasourceElem = xmlDoc.createElement(TAG_datasource);
            BcXmlUtil.setTextValue(datasourceElem, TAG_path, backup.fileName);
            BcXmlUtil.setTextValue(datasourceElem, TAG_length, backup.length);
            BcXmlUtil.setTextValue(datasourceElem, TAG_lastModified, BcTimeUtil.toString(backup.lastModified, "yyyy/MM/dd HH:mm:ss"));
            BcXmlUtil.setTextValue(datasourceElem, TAG_backupTime, BcTimeUtil.toString(backup.backupTime, "yyyy/MM/dd HH:mm:ss"));
            rootElem.appendChild(datasourceElem);
            ++i;
        }
        return xmlDoc;
    }

    protected List<Y_BackupContext> checkFileExists(List<Y_BackupContext> backupList1) throws Exception {
        HashMap<String, Y_BackupContext> ctxMap = new HashMap<String, Y_BackupContext>();
        int i = 0;
        while (i < backupList1.size()) {
            Y_BackupContext backup = backupList1.get(i);
            ctxMap.put(backup.fileName, backup);
            ++i;
        }
        HashMap<String, File> fileNameMap = new HashMap<String, File>();
        File[] files = this.backupDir.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            File file = files[i2];
            if (this.backupFileExtention.equals(BcFileUtil.getExtention(file))) {
                fileNameMap.put(file.getName(), file);
                Y_BackupContext backupContext = (Y_BackupContext)ctxMap.get(file.getName());
                if (backupContext == null) {
                    backupContext = this.toBackupContext(file);
                    ctxMap.put(file.getName(), backupContext);
                }
            }
            ++i2;
        }
        ArrayList<Y_BackupContext> backupList2 = new ArrayList<Y_BackupContext>();
        for (Map.Entry mapEntry : ctxMap.entrySet()) {
            Y_BackupContext backup = (Y_BackupContext)mapEntry.getValue();
            File file = new File(this.backupDir, backup.fileName);
            if (!file.exists()) continue;
            backupList2.add(backup);
        }
        BcSortUtil.sort(backupList2, false, new Object[]{TAG_lastModified, "fileName"});
        return backupList2;
    }

    protected void encryptFile(final File file1, final File file2) throws Exception {
        final Y_ProgressPane progressPane = new Y_ProgressPane();
        final BcMonitor monitor3 = new BcMonitor();
        monitor3.lock();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    progressPane.setDescription("aaaaaa");
                    progressPane.show(null);
                    File tmpFile = File.createTempFile(file2.getName(), null, file2.getParentFile());
                    Y_BackupManager.this.oneTimePadCipher(file1, tmpFile);
                    tmpFile.renameTo(file2);
                    progressPane.close();
                    monitor3.unLock();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        monitor3.sync();
    }

    protected void decryptFile(File file1, File file2) throws Exception {
        File tmpFile = File.createTempFile(file2.getName(), null, file2.getParentFile());
        this.oneTimePadCipher(file1, tmpFile);
        tmpFile.renameTo(file2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void oneTimePadCipher(File plainFile, File cipherfile) throws Exception {
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            FileInputStream io = new FileInputStream(plainFile);
            try {
                try (FileOutputStream os = new FileOutputStream(cipherfile);){
                    InneerStreamTransmitter streamTransmitter = new InneerStreamTransmitter();
                    streamTransmitter.setBufferSize(204800);
                    streamTransmitter.transmit(io, os);
                }
                if (io == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (io == null) throw throwable;
                io.close();
                throw throwable;
            }
            io.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void dataSelect(Y_BackupContext backup) throws Exception {
        File backupFile = new File(this.backupDir, backup.fileName);
        this.copyFile(this.logger, backupFile, this.mdbFile);
        this.restored = true;
    }

    public void deleteData(Y_BackupContext backup) throws Exception {
        File backupFile = new File(this.backupDir, backup.fileName);
        BcFileUtil.deleteFile(backupFile);
        this.backupList = this.checkFileExists(this.backupList);
    }

    protected void openDialog(final List<Y_BackupContext> backupList, final Y_BackupManager Y_BackupSystem) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RpcsMeasurementModificationPane pane = new RpcsMeasurementModificationPane(Y_BackupSystem);
                    pane.setData(backupList);
                    pane.show(null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    class InneerStreamTransmitter
    extends BcStreamTransmitter {
        BcStreamFilter streamFilter = new BcStreamFilter("EASY");

        InneerStreamTransmitter() {
        }

        @Override
        protected byte[] dataConvert(byte[] bytes) {
            byte[] bytes2 = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                bytes2[i] = (byte)(bytes[i] ^ this.streamFilter.getNextByte());
                ++i;
            }
            return bytes2;
        }

        @Override
        protected void fireTransferd(long value) throws Exception {
        }
    }
}

