/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.common;

import ext.base.log.BcLogUtil;
import ext.scf.common.ScfHandle;
import ext.scf.common.ScfHandleResource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ScfHandleImpl
implements ScfHandle,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8409299222143097715L;
    protected String handleId;
    protected long startTimeMillis = Long.MAX_VALUE;
    protected long lifeSpanMillis = -1L;
    protected long lastAccessTimeMillis = Long.MAX_VALUE;
    protected int accessCount;
    protected List<ScfHandleResource> resourceList = new ArrayList<ScfHandleResource>();
    protected Object owner;
    protected String note;

    @Override
    public String getHandleId() {
        return this.handleId;
    }

    @Override
    public void setHandleId(String handleId) {
        this.handleId = handleId;
    }

    @Override
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public void setStartTimeMillis(long startTime) {
        this.startTimeMillis = startTime;
    }

    @Override
    public long getLifeSpanMillis() {
        return this.lifeSpanMillis;
    }

    @Override
    public void setLifeSpanMillis(long lifeSpanMillis) {
        this.lifeSpanMillis = lifeSpanMillis;
    }

    @Override
    public long getLastAccessTimeMillis() {
        return this.lastAccessTimeMillis;
    }

    @Override
    public void setLastAccessTimeMillis(long lastAccessTimeMillis) {
        this.lastAccessTimeMillis = lastAccessTimeMillis;
    }

    @Override
    public void incrementAccessCount() {
        ++this.accessCount;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public ScfHandleResource getHandleResource(int index) throws Exception {
        return this.resourceList.get(index);
    }

    @Override
    public void addHandleResource(ScfHandleResource handleResource) {
        this.resourceList.add(handleResource);
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public void close() throws Exception {
        this.handleId = null;
        if (this.resourceList != null) {
            ScfHandleResource[] sandleResources = this.resourceList.toArray(new ScfHandleResource[0]);
            int i = 0;
            while (i < sandleResources.length) {
                try {
                    sandleResources[i].releaseResource();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i;
            }
            this.resourceList.clear();
            this.resourceList = null;
        }
        this.owner = null;
        this.note = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ScfHandleImpl obj = (ScfHandleImpl)super.clone();
        return obj;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeObject(this.handleId);
        os.writeLong(this.startTimeMillis);
        os.writeLong(this.lifeSpanMillis);
        os.writeLong(this.lastAccessTimeMillis);
        os.writeInt(this.accessCount);
        os.writeObject(this.resourceList);
        if (this.owner != null) {
            os.writeObject(this.owner.toString());
        } else {
            os.writeObject(this.owner);
        }
        os.writeObject(this.note);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.handleId = (String)is.readObject();
        this.startTimeMillis = is.readLong();
        this.lifeSpanMillis = is.readLong();
        this.lastAccessTimeMillis = is.readLong();
        this.accessCount = is.readInt();
        this.resourceList = (List)is.readObject();
        this.owner = is.readObject();
        this.note = (String)is.readObject();
    }
}

