/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xwdl.fx;

import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.lib.http.client.HtclContentLoader;
import ext.lib.http.client.HtclHttpClientUtil;
import ext.lib.task.TskAbstractCallable;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xwdl.fx.XwdlCondition;
import ext.module.xwdl.fx.XwdlDownloadEventHandler;
import ext.module.xwdl.fx.XwdlElemnt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.regex.Pattern;

public class XwdlDownlodTask
extends TskAbstractCallable {
    HtclContentLoader contentLoader = new HtclContentLoader();
    XwdlDownloadEventHandler downloadEventHandler;
    XwdlCondition xwdlCondition;
    Pattern illegalFileNamePattern = Pattern.compile("[(\\|/|:|\\*|?|\"|<|>|\\\\|)]");

    public XwdlDownlodTask(XwdlDownloadEventHandler downloadEventHandler, XwdlCondition xwdlCondition) throws Exception {
        this.downloadEventHandler = downloadEventHandler;
        this.xwdlCondition = xwdlCondition;
        this.contentLoader.getHttpContentLoader().socketTimeout = 10000L;
        this.contentLoader.getHttpContentLoader().connectionTimeout = 10000L;
    }

    protected Object taskProcess() throws Exception {
        while (true) {
            XwdlElemnt xwdlElemnt = this.xwdlCondition.getNextDownload();
            BcLogUtil.debug("xwdlElemnt=" + xwdlElemnt);
            if (xwdlElemnt == null) break;
            this.taskProcess_L2(xwdlElemnt);
        }
        return null;
    }

    protected void taskProcess_L2(XwdlElemnt xwdlElemnt) throws Exception {
        try {
            ++xwdlElemnt.tryCnt;
            URL url = new URL(xwdlElemnt.url);
            XfilUriEntity uriEntity = XfilUtil.toUriEntity(url.toURI());
            String tmpPath = uriEntity.path.replace("...", "-");
            tmpPath = tmpPath.replace(":80", "_80");
            File destDir = new File(this.xwdlCondition.getDestDir(), tmpPath);
            File destFile = new File(destDir, uriEntity.name);
            if (destFile.exists()) {
                BcLogUtil.warning("\u51fa\u529b\u5148\u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002" + destFile.getPath());
            }
            if (xwdlElemnt.rLength < 0) {
                xwdlElemnt.rLength = HtclHttpClientUtil.getContentLength(url);
                if (xwdlElemnt.rLength < 0) {
                    BcLogUtil.debug("rLength=" + xwdlElemnt.rLength + ":\u30b3\u30f3\u30c6\u30f3\u30c8\u306e\u9577\u3055\u4e0d\u660e");
                }
            }
            if (xwdlElemnt.tempFile == null) {
                xwdlElemnt.tempFile = new File(destDir, String.valueOf(destFile.getName()) + ".ztmp");
                BcFileUtil.makeParent(xwdlElemnt.tempFile);
            }
            long rangeStart = xwdlElemnt.tempFile.length();
            long rangeEnd = xwdlElemnt.rLength;
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (FileOutputStream fos = new FileOutputStream(xwdlElemnt.tempFile);){
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    this.contentLoader.getContent(url, bos, rangeStart, rangeEnd);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                BcLogUtil.debug("\u5f85\u6a5f" + this.xwdlCondition.dowlloadWaitMs + "\u30df\u30ea\u79d2 \u4f8b\u5916=" + ex);
                Thread.sleep(this.xwdlCondition.dowlloadWaitMs);
                this.xwdlCondition.addDownload(xwdlElemnt);
                return;
            }
            boolean isCompllete = false;
            if (xwdlElemnt.rLength > 0) {
                if (xwdlElemnt.tempFile.length() == (long)xwdlElemnt.rLength) {
                    isCompllete = true;
                } else if (xwdlElemnt.tempFile.length() > (long)xwdlElemnt.rLength) {
                    BcLogUtil.error("\u30b5\u30a4\u30ba\u7570\u5e38:" + xwdlElemnt.tempFile.length() + ">" + xwdlElemnt.rLength);
                }
            } else {
                isCompllete = true;
            }
            if (isCompllete) {
                BcFileUtil.makeParent(destFile);
                BcFileUtil.rename(xwdlElemnt.tempFile, destFile);
                this.downloadEventHandler.downloaded(destFile, url);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            this.xwdlCondition.addDownloadFix(xwdlElemnt, ex);
        }
    }
}

