/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.fx;

import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.fx.XdtsMenuIF;
import ext.module.xdts.fx.XdtsProfileMenuPane;
import ext.module.xfil.fx.XfilMenuPane;
import ext.module.xsys.client.XsysClientModule;
import ext.module.xsys.common.XsysConstants;
import ext.scf.client.ScfClientContainer;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.layout.StackPane;

public class XsysMenuPane
extends FxBorderPane {
    List<String> classNameList = new ArrayList<String>();
    List<XdtsMenuIF> instanceList = new ArrayList<XdtsMenuIF>();
    FxTabPane tabPane1 = new FxTabPane();

    public XsysMenuPane() throws Exception {
        ScfClientContainer clientContainer = ScfClientContainer.getInstance();
        if (XsysClientModule.properties.containsKey(XsysConstants.Function.DatabaseClient.name())) {
            this.classNameList.add(XdtsProfileMenuPane.class.getName());
        }
        if (XsysClientModule.properties.containsKey(XsysConstants.Function.Filer.name())) {
            this.classNameList.add(XfilMenuPane.class.getName());
        }
        this.setComponant();
        this.start();
    }

    protected void setComponant() throws Exception {
        this.tabPane1.setSide(Side.TOP);
        int i = 0;
        while (i < this.classNameList.size()) {
            String className = this.classNameList.get(i);
            XdtsMenuIF menuInterface = null;
            try {
                Class<?> clazz = Class.forName(className);
                menuInterface = (XdtsMenuIF)BcReflectUtil.getInstance(clazz);
                this.instanceList.add(menuInterface);
            }
            catch (ClassNotFoundException ex) {
                BcLogUtil.error(ex);
            }
            catch (Exception ex) {
                throw ex;
            }
            Tab tab = new Tab();
            tab.setText(menuInterface.getTitle());
            tab.setGraphic((Node)menuInterface.getImageView());
            tab.setContent((Node)menuInterface);
            tab.setClosable(false);
            this.tabPane1.getTabs().add((Object)tab);
            ++i;
        }
        if (this.tabPane1.getTabs().size() > 0) {
            Tab tab = (Tab)this.tabPane1.getTabs().get(0);
            this.tabPane1.getSelectionModel().select((Object)tab);
        }
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{this.tabPane1});
        this.setCenter((Node)stackPane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setMenu(MenuBar menuBar) throws Exception {
        int i = 0;
        while (i < this.instanceList.size()) {
            XdtsMenuIF menuIF = this.instanceList.get(i);
            menuIF.setMenu(menuBar);
            ++i;
        }
    }

    public void start() throws Exception {
        int i = 0;
        while (i < this.instanceList.size()) {
            XdtsMenuIF menuIF = this.instanceList.get(i);
            menuIF.start();
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }
}

