/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.server;

import ext.appfw.common.AfbApplication;
import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.server.RmiAgentEventHandler;
import ext.lib.rmi.server.RmiServer;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext_H2;
import ext.module.xdts.server.XdtsServerModule;
import ext.module.xmmd.server.XmmdServerModule;
import ext.module.xsod.common.XsodWords;
import ext.scf.server.ScfAbstractServerModule;
import ext.scf.server.ScfServerContainer;
import ext.scf.server.ScfServerModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class XsodServerModule
extends ScfAbstractServerModule
implements RmiAgentEventHandler {
    String[] classNames = new String[]{XdtsServerModule.class.getName(), XmmdServerModule.class.getName()};
    List<ScfServerModule> serverModuleList = new ArrayList<ScfServerModule>();

    @Override
    public void init() throws Exception {
        int i = 0;
        while (i < this.classNames.length) {
            String className = this.classNames[i];
            Class<?> clazz = Class.forName(className);
            ScfServerModule serverModule = (ScfServerModule)BcReflectUtil.getInstance(clazz);
            this.serverModuleList.add(serverModule);
            serverModule.init();
            ++i;
        }
        this.setupDatasource();
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            RmiServer rmixServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
            rmixServer.addAgentEventHandler(this);
        }
        this.wordsSetting();
    }

    @Override
    public void start() throws Exception {
        int i = 0;
        while (i < this.serverModuleList.size()) {
            ScfServerModule serverModule = this.serverModuleList.get(i);
            serverModule.start();
            ++i;
        }
    }

    @Override
    public void end() throws Exception {
        int i = 0;
        while (i < this.serverModuleList.size()) {
            ScfServerModule serverModule = this.serverModuleList.get(i);
            serverModule.end();
            ++i;
        }
    }

    protected void setupDatasource() throws Exception {
        String dbPath = AfbApplication.getInstance().toReal("${ROOT}data/main");
        String driverClassName = "org.h2.Driver";
        String dbUrl = SqlContext_H2.cretaeUrlFile(dbPath);
        BcLogUtil.debug("dbUrl=" + dbUrl);
        Properties dbConProps = new Properties();
        dbConProps.setProperty(SqlConstants.DatasourceProperty.user.name(), "xsys_admin");
        dbConProps.setProperty(SqlConstants.DatasourceProperty.password.name(), "ex4rhk8x");
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(SqlUtil.createDriver(driverClassName), dbUrl, dbConProps);
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory("main", connectionManager);
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
    }

    protected void wordsSetting() throws Exception {
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.id", 8, XsodWords.getInstance().\u5546\u54c1ID.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.code", 12, XsodWords.getInstance().\u5546\u54c1\u30b3\u30fc\u30c9.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.name_01", 40, XsodWords.getInstance().\u54c1\u540d.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.unit_amount", 10, XsodWords.getInstance().\u5358\u4fa1.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.description_01", 20, XsodWords.getInstance().\u8aac\u660e.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.description_02", 20, XsodWords.getInstance().\u8aac\u660e.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.image_file_name", 40, XsodWords.getInstance().\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u540d.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_sales.id", 8, XsodWords.getInstance().\u58f2\u4e0aID.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_sales.amount", 8, XsodWords.getInstance().\u58f2\u4e0a\u91d1\u984d\u7a0e\u629c.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_sales.tax", 8, XsodWords.getInstance().\u6d88\u8cbb\u7a0e.toHtml());
    }

    @Override
    public void agentAdded(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void agentRemoved(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void firstStatusChecked(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void invokeException(RmiRmoArgument rmixArg, Throwable throwable) throws Exception {
        BcLogUtil.error(throwable);
    }
}

