/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.rmo;

import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.module.wbs1.server.Wbs1ServerUtil;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.dao.XsodMerchandiseDAO;
import ext.module.xsod.dao.XsodOrderDAO;
import ext.module.xsod.dao.XsodOrderSessionDAO;
import ext.module.xsod.dao.XsodSalesDAO;
import ext.module.xsod.dao.XsodSalesDetailDAO;
import ext.module.xsod.model.XsodCondition;
import ext.module.xsod.model.XsodMerchandise;
import ext.module.xsod.model.XsodOrder;
import ext.module.xsod.model.XsodOrderSession;
import ext.module.xsod.model.XsodSalesDetail;
import ext.module.xsod.model.XsodSalesPack;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class XsodOrderRMO
extends RmiAbstractRMO {
    public static final String METHOD_putOrderCollection = "putOrderCollection";
    public static final String METHOD_updateOrder = "updateOrder";
    public static final String METHOD_bill_1 = "bill_1";
    public static final String METHOD_bill_2 = "bill_2";
    public static final String METHOD_getCurrentOrderList = "getCurrentOrderList";

    public void putOrderCollection(RmiRmoArgument rmoArg) throws Exception {
        Integer orderSessionId = rmoArg.getRequest().getDataAsInteger();
        Collection orderCollection = (Collection)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var5_7 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            for (XsodOrder order : orderCollection) {
                BcLogUtil.debug("putOrderCollection:merchandiseCode=" + order.merchandiseCode + " quantity=" + order.quantity);
                order.sessionId = orderSessionId;
                order.orderDateTime = BcTimeUtil.createCalendar();
                XsodUtil.setOrderStatus(order);
            }
            XsodOrderDAO.getInstance().putEntityCollection(dtsSession, orderCollection);
            dtsSession.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateOrder(RmiRmoArgument rmoArg) throws Exception {
        XsodOrder order = (XsodOrder)rmoArg.getRequest().getData();
        short nextStatus = rmoArg.getRequest().getDataAsShort();
        switch (nextStatus) {
            case 2: {
                order.orderDateTime = BcTimeUtil.createCalendar();
                break;
            }
            case 3: {
                order.createStartDateTime = BcTimeUtil.createCalendar();
                break;
            }
            case 4: {
                order.createEndDateTime = BcTimeUtil.createCalendar();
                break;
            }
            case 5: {
                order.deliveryStartDateTime = BcTimeUtil.createCalendar();
                break;
            }
            case 6: {
                order.deliveryEndDateTime = BcTimeUtil.createCalendar();
                break;
            }
            case 9: {
                order.cancelDateTime = BcTimeUtil.createCalendar();
            }
        }
        XsodUtil.setOrderStatus(order);
        Throwable throwable = null;
        Object var5_7 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodOrderDAO.getInstance().putEntity(dtsSession, order);
            dtsSession.commit();
            rmoArg.getRespons().addData(order);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void bill_1(RmiRmoArgument rmoArg) throws Exception {
        Integer sessionId = rmoArg.getRequest().getDataAsInteger();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodSalesPack salesPack = this.bill_1_L2(dtsSession, sessionId);
            rmoArg.getRespons().addData(salesPack);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private XsodSalesPack bill_1_L2(DtsSession dtsSession, int sessionId) throws Exception {
        BcLogUtil.info("\u4f1a\u8a08\u51e6\u7406\u958b\u59cb");
        BcLogUtil.info("\u6ce8\u6587\u30c7\u30fc\u30bf\u62bd\u51fa\u4e2d...");
        List<XsodOrder> orderList = XsodOrderDAO.getInstance().getList(dtsSession, sessionId, new short[0]);
        BcLogUtil.info("\u6ce8\u6587\u30c7\u30fc\u30bf\u6570=" + orderList.size());
        List<XsodMerchandise> merchandiseList = XsodMerchandiseDAO.getInstance().getList(dtsSession, null);
        Map<String, XsodMerchandise> merchandiseMap = XsodUtil.toMerchandiseMap(merchandiseList);
        XsodSalesPack salesPack = XsodUtil.createSalesPack(orderList, merchandiseMap);
        return salesPack;
    }

    public void bill_2(RmiRmoArgument rmoArg) throws Exception {
        Integer sessionId = rmoArg.getRequest().getDataAsInteger();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodOrderSession orderSession = XsodOrderSessionDAO.getInstance().geById(dtsSession, sessionId);
            XsodSalesPack salesPack = this.bill_1_L2(dtsSession, sessionId);
            XsodSalesDAO.getInstance().putEntity(dtsSession, salesPack.sales);
            int i = 0;
            while (i < salesPack.salesDetaiList.size()) {
                XsodSalesDetail salesDetail = salesPack.salesDetaiList.get(i);
                salesDetail.salseNumber = salesPack.sales.getDataId();
                salesDetail.detailNumber = (short)(i + 1);
                ++i;
            }
            XsodSalesDetailDAO.getInstance().putEntityCollection(dtsSession, salesPack.salesDetaiList);
            orderSession.endDateTime = BcTimeUtil.createCalendar();
            XsodOrderSessionDAO.getInstance().putEntity(dtsSession, orderSession);
            dtsSession.commit();
            rmoArg.getRespons().addData(salesPack);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getCurrentOrderList(RmiRmoArgument rmoArg) throws Exception {
        XsodCondition condition = (XsodCondition)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            List<XsodOrder> orderList = XsodOrderDAO.getInstance().getList(dtsSession, condition.sessionId, condition.orderStatuses);
            List<XsodOrderSession> orderSessionList = XsodOrderSessionDAO.getInstance().getList(dtsSession, 2, -1, null);
            rmoArg.getRespons().addData(orderList);
            rmoArg.getRespons().addData(orderSessionList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

