/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.rmo;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1ArticleCondition;
import ext.module.wbs1.server.Wbs1ServerUtil;
import ext.module.xsod.common.XsodWords;
import ext.module.xsod.dao.XsodCategoryDAO;
import ext.module.xsod.model.XsodCategory;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfSqlTask;
import ext.scf8.util.KscfKeywordUtil;
import java.util.ArrayList;

public class XsodCategoryRMO
extends RmiAbstractRMO {
    public static final String METHOD_getMerchandiseCategory = "getMerchandiseCategory";
    public static final String METHOD_putMerchandiseCategory = "putMerchandiseCategory";
    public static final String METHOD_merchandiseCategoryList = "merchandiseCategoryList";

    public void putMerchandiseCategory(RmiRmoArgument rmoArg) throws Exception {
        XsodCategory merchandiseCategory = (XsodCategory)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodCategoryDAO.getInstance().putEntity(dtsSession, merchandiseCategory);
            dtsSession.commit();
            rmoArg.getRespons().addData(merchandiseCategory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getMerchandiseCategory(RmiRmoArgument rmoArg) throws Exception {
        String merchandiseCategoryCode = rmoArg.getRequest().getDataAsString();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);){
            XsodCategory merchandiseCategory = XsodCategoryDAO.getInstance().getByCode(dtsSession, merchandiseCategoryCode);
            rmoArg.getRespons().addData(merchandiseCategory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void merchandiseCategoryList(RmiRmoArgument rmoArg) throws Exception {
        Wbs1ArticleCondition articleCondition = (Wbs1ArticleCondition)rmoArg.getRequest().getData();
        DtsSession dtsSessionWk = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);
        SqlContext sqlContext = dtsSessionWk.getSqlContext();
        ScfSqlTask sqlTask = ScfSqlUtil.createSqlTask(rmoArg, dtsSessionWk);
        sqlTask.wordManager = rmoArg.getDtsSession((Object)this).getSessionFactory().wordManager;
        SqlSelectSql selectSql = new SqlSelectSql();
        this.setColumnNameList(selectSql);
        this.parseCondition(dtsSessionWk, selectSql, articleCondition);
        this.getFromClause(selectSql);
        this.setOrderByPhrase(selectSql);
        sqlTask.sql = sqlContext.buildSelectSql(selectSql);
        BcLogUtil.debug("query=" + sqlTask.sql);
        sqlTask.tableColumnNameList = selectSql.getSelectColumnList();
        sqlTask.tableContext.title = XsodWords.getInstance().\u30ab\u30c6\u30b4\u30ea\u30ea\u30b9\u30c8.toString();
        sqlTask.tableContext.setConditionList(selectSql.getConditionList());
        ScfSqlUtil.generalListNew(sqlTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectSql selectSql, Wbs1ArticleCondition articleCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        if (!BcStringUtil.isEmpty(articleCondition.keyword)) {
            String keywords = KscfKeywordUtil.conv(articleCondition.keyword);
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(String.valueOf(articleCondition.tableName) + ".text_1" + sqlContext.toKeyword(keywords));
            sb.append(" OR ");
            sb.append(String.valueOf(articleCondition.tableName) + ".text_2" + sqlContext.toKeyword(keywords));
            sb.append(")");
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sb);
            selectSql.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlSelectSql selectSql) throws Exception {
        ArrayList<String> tmpSelectColumnNameList = new ArrayList<String>();
        tmpSelectColumnNameList.addAll(selectSql.getSelectColumnList());
        selectSql.getSelectColumnList().clear();
        selectSql.getSelectColumnList().add("xsod_category.set_id");
        selectSql.getSelectColumnList().add("xsod_category.parent_code");
        selectSql.getSelectColumnList().add("xsod_category.code");
        selectSql.getSelectColumnList().add("xsod_category.name_01");
        selectSql.getSelectColumnList().add("xsod_category.name_02");
        selectSql.getSelectColumnList().add("xsod_category.merchandise_codes");
        selectSql.getSelectColumnList().add("xsod_category.image_file_name");
        selectSql.getSelectColumnList().add("xsod_category.priority");
        selectSql.getSelectColumnList().addAll(tmpSelectColumnNameList);
    }

    public void getFromClause(SqlSelectSql selectSql) throws Exception {
        String tmpFromClause = selectSql.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append("xsod_category");
        selectSql.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectSql selectSql) {
        selectSql.getOrderByList().add("xsod_category.set_id");
        selectSql.getOrderByList().add("xsod_category.parent_code");
        selectSql.getOrderByList().add("xsod_category.code");
    }
}

