/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.fx;

import ext.base.core.BcTimeUtil;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxNumberField;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxImageUtil;
import ext.lib.fx.util.FxUtil;
import ext.module.xsod.common.FxxImageCash;
import ext.module.xsod.common.XsodUtil;
import ext.module.xsod.common.XsodWords;
import ext.module.xsod.fx.XsodController;
import ext.module.xsod.fx.XsodUiFactory;
import ext.module.xsod.model.XsodMenuData;
import ext.module.xsod.model.XsodMerchandisePack;
import ext.module.xsod.model.XsodOrder;
import ext.module.xsod.model.XsodOrderSession;
import ext.module.xsod.stub.XsodOrderStub;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;

class XsodOrderDetailPane
extends FxBorderPane {
    FxFlowPane flowPane = new FxFlowPane(11);
    FxTextField merchandiseNameField = new FxTextField();
    FxNumberField quantityField = new FxNumberField();
    FxTextField seatsCodeField = new FxTextField();
    FxTextField orderDateTimeField = new FxTextField();
    FxTextField createStartDateTimeField = new FxTextField();
    FxTextField elapsedTimeField = new FxTextField();
    ImageView imageView = new ImageView();
    VBox bottomBox = new VBox();
    Button checkButton = new Button();
    XsodOrder order;

    public XsodOrderDetailPane() throws Exception {
        this.setComponent();
    }

    protected void setComponent() throws Exception {
        this.setCenter((Node)this.flowPane);
        this.merchandiseNameField.setPrefColumnCount(16);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u54c1\u540d.toString()), new Node[]{this.merchandiseNameField});
        this.flowPane.addNodeUnit(nodeUnit);
        this.quantityField.setPrefColumnCount(2);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u6570\u91cf.toString()), new Node[]{this.quantityField});
        this.flowPane.addNodeUnit(nodeUnit);
        this.seatsCodeField.setPrefColumnCount(6);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u5ba2\u5e2d\u756a\u53f7.toString()), new Node[]{this.seatsCodeField});
        nodeUnit.arrangement = 1;
        this.flowPane.addNodeUnit(nodeUnit);
        this.orderDateTimeField.setPrefColumnCount(8);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u6ce8\u6587\u65e5\u6642.toString()), new Node[]{this.orderDateTimeField});
        this.flowPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(""), new Node[]{this.imageView});
        nodeUnit.arrangement = 1;
        this.flowPane.addNodeUnit(nodeUnit);
        this.createStartDateTimeField.setPrefColumnCount(8);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XsodWords.getInstance().\u8abf\u7406\u958b\u59cb.toString()), new Node[]{this.createStartDateTimeField});
        this.flowPane.addNodeUnit(nodeUnit);
        this.elapsedTimeField.setPrefColumnCount(8);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().elapsedTime), new Node[]{this.elapsedTimeField});
        this.flowPane.addNodeUnit(nodeUnit);
        this.checkButton.setOnAction(this.actionEventHandler);
        this.bottomBox.setAlignment(Pos.CENTER);
        this.bottomBox.setSpacing(10.0);
        this.bottomBox.getChildren().addAll((Object[])new Node[]{this.checkButton});
        this.setBottom((Node)this.bottomBox);
        FxUtil.setEditable((Node)this.flowPane, false);
        FxUtil.setFont((Node)this, XsodUiFactory.getInstance().defaultFont);
        FxUtil.defaultInitialize((Node)this);
        this.checkButton.setPrefSize(200.0, 40.0);
    }

    public void setData(XsodOrderSession orderSession, XsodOrder order) throws Exception {
        this.order = order;
        XsodMenuData menuData = XsodController.getInstance().getMenuData();
        XsodMerchandisePack merchandisePack = XsodUtil.getMerchandisePackByItemCode(menuData, order.merchandiseCode);
        if (merchandisePack == null) {
            String msg = "\u6ce8\u6587\u30c7\u30fc\u30bf\u306e\u5546\u54c1\u30b3\u30fc\u30c9'" + order.merchandiseCode + "'\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
            throw new Exception(msg);
        }
        boolean langIndex = false;
        String merchandiseName = XsodUtil.getName(merchandisePack.merchandise, XsodController.getInstance().langCode, true);
        this.merchandiseNameField.setText(merchandiseName);
        this.quantityField.setValue(order.quantity);
        this.seatsCodeField.setText(orderSession.tableNumber);
        String format = "HH:mm";
        this.orderDateTimeField.setText(BcTimeUtil.toString(order.orderDateTime, format));
        this.createStartDateTimeField.setText(BcTimeUtil.toString(order.createStartDateTime, format));
        long elapsedTimeMillis = System.currentTimeMillis() - order.orderDateTime.getTimeInMillis();
        this.elapsedTimeField.setText(BcTimeUtil.getTermString(elapsedTimeMillis));
        Image image = FxxImageCash.getInstance().getImageNI(merchandisePack.merchandise.imageFileName);
        if (image != null) {
            this.imageView.setImage(image);
            FxImageUtil.setSizeExtract(this.imageView, 120.0, 120.0);
        }
        switch (order.status) {
            case 2: {
                this.checkButton.setText(XsodWords.getInstance().\u8abf\u7406\u958b\u59cb.toString());
                break;
            }
            case 3: {
                this.checkButton.setText(XsodWords.getInstance().\u8abf\u7406\u7d42\u4e86.toString());
                break;
            }
            case 4: {
                this.checkButton.setText(XsodWords.getInstance().\u914d\u9054\u958b\u59cb.toString());
                break;
            }
            case 5: {
                this.checkButton.setText(XsodWords.getInstance().\u914d\u9054\u7d42\u4e86.toString());
            }
        }
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.checkButton) {
            short nextStatus = XsodUtil.getNextStatus(this.order.status);
            XsodOrderStub.getInstance().updateOrder(this.order, nextStatus);
        }
    }
}

